/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.time.SchedulePrototype;

public class DataTableLight
implements DataTable,
Cloneable {
    private static final long serialVersionUID = -8655513677146846285L;
    private final String name;
    private final DataTable.TableConvention convention;
    private final TreeSet<Integer> maturitySet = new TreeSet();
    private final TreeSet<Integer> terminationSet = new TreeSet();
    private final HashMap<DataKey, Double> entries = new HashMap();

    public DataTableLight(String name, DataTable.TableConvention tableConvention) {
        this.name = name;
        this.convention = tableConvention;
    }

    public DataTableLight(String name, DataTable.TableConvention tableConvention, int[] maturities, int[] terminations, double[] values) {
        this(name, tableConvention);
        if (maturities.length != terminations.length || maturities.length != values.length) {
            throw new IllegalArgumentException("Number of entries need to match. Input was maturities: " + maturities.length + ", terminations: " + terminations.length + ",values: " + values.length + ". ");
        }
        for (int index = 0; index < maturities.length; ++index) {
            this.entries.put(new DataKey(maturities[index], terminations[index]), values[index]);
            this.maturitySet.add(maturities[index]);
            this.terminationSet.add(terminations[index]);
        }
    }

    public DataTableLight(String name, DataTable.TableConvention tableConvention, List<Integer> maturities, List<Integer> terminations, List<Double> values) {
        this(name, tableConvention);
        if (maturities.size() != terminations.size() || maturities.size() != values.size()) {
            throw new IllegalArgumentException("Number of entries need to match. Input was maturities: " + maturities.size() + ", terminations: " + terminations.size() + ",values: " + values.size() + ". ");
        }
        for (int index = 0; index < maturities.size(); ++index) {
            int mat = maturities.get(index);
            int term = terminations.get(index);
            double val = values.get(index);
            this.entries.put(new DataKey(mat, term), val);
            this.maturitySet.add(mat);
            this.terminationSet.add(term);
        }
    }

    @Override
    public DataTableLight addPoint(int maturity, int termination, double value) {
        DataTableLight newTable = this.clone();
        newTable.entries.put(new DataKey(maturity, termination), value);
        newTable.maturitySet.add(maturity);
        newTable.terminationSet.add(termination);
        return newTable;
    }

    @Override
    public DataTableLight addPoints(int[] maturities, int[] terminations, double[] values) {
        DataTableLight newTable = this.clone();
        for (int index = 0; index < maturities.length; ++index) {
            newTable.entries.put(new DataKey(maturities[index], terminations[index]), values[index]);
            newTable.maturitySet.add(maturities[index]);
            newTable.terminationSet.add(terminations[index]);
        }
        return newTable;
    }

    @Override
    public double getValue(int maturity, int termination) {
        DataKey key = new DataKey(maturity, termination);
        if (this.entries.containsKey(key)) {
            return this.entries.get(new DataKey(maturity, termination));
        }
        throw new NullPointerException("Key " + key.toString() + " not found in table " + this.name);
    }

    @Override
    public boolean containsEntryFor(int maturity, int termination) {
        return this.entries.containsKey(new DataKey(maturity, termination));
    }

    @Override
    public TreeSet<Integer> getMaturities() {
        return new TreeSet<Integer>((SortedSet<Integer>)this.maturitySet);
    }

    @Override
    public TreeSet<Integer> getTerminations() {
        return new TreeSet<Integer>((SortedSet<Integer>)this.terminationSet);
    }

    @Override
    public TreeSet<Integer> getTerminationsForMaturity(int maturity) {
        if (this.maturitySet.contains(maturity)) {
            TreeSet<Integer> returnSet = new TreeSet<Integer>();
            for (int termination : this.terminationSet) {
                if (!this.entries.containsKey(new DataKey(maturity, termination))) continue;
                returnSet.add(termination);
            }
            return returnSet;
        }
        return new TreeSet<Integer>();
    }

    @Override
    public TreeSet<Integer> getMaturitiesForTermination(int termination) {
        if (this.terminationSet.contains(termination)) {
            TreeSet<Integer> returnSet = new TreeSet<Integer>();
            for (int maturity : this.maturitySet) {
                if (!this.entries.containsKey(new DataKey(maturity, termination))) continue;
                returnSet.add(maturity);
            }
            return returnSet;
        }
        return new TreeSet<Integer>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataTable.TableConvention getConvention() {
        return this.convention;
    }

    @Override
    public DataTableLight clone() {
        DataTableLight newTable = new DataTableLight(this.name, this.convention);
        newTable.entries.putAll(this.entries);
        newTable.maturitySet.addAll(this.maturitySet);
        newTable.terminationSet.addAll(this.terminationSet);
        return newTable;
    }

    public String toString() {
        return this.toString(1.0);
    }

    public String toString(double unit) {
        StringBuilder builder = new StringBuilder();
        builder.append("Name: " + this.name + ", TableConvention: " + (Object)((Object)this.convention) + ",\n");
        for (int termination : this.terminationSet) {
            builder.append("\t" + termination);
        }
        for (int maturity : this.maturitySet) {
            builder.append("\n" + maturity);
            for (int termination : this.terminationSet) {
                DataKey key = new DataKey(maturity, termination);
                builder.append('\t');
                if (!this.entries.containsKey(key)) continue;
                builder.append(this.entries.get(key) * unit);
            }
        }
        return builder.toString();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public double getValue(double maturity, double termination) {
        throw new UnsupportedOperationException("Table " + this.getName() + " of class " + this.getClass() + " does not support access via double.");
    }

    @Override
    public boolean containsEntryFor(double maturity, double termination) {
        throw new UnsupportedOperationException("Table " + this.getName() + " of class " + this.getClass() + " does not support access via double.");
    }

    @Override
    public LocalDate getReferenceDate() {
        return null;
    }

    @Override
    public SchedulePrototype getScheduleMetaData() {
        return null;
    }

    private static class DataKey
    implements Serializable {
        private static final long serialVersionUID = 3391432439373885684L;
        private final int maturity;
        private final int termination;

        DataKey(int maturity, int termination) {
            this.maturity = maturity;
            this.termination = termination;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            if (this.maturity != ((DataKey)other).maturity) {
                return false;
            }
            return this.termination == ((DataKey)other).termination;
        }

        public int hashCode() {
            return this.maturity * this.termination;
        }

        public String toString() {
            return "DataKey [maturity=" + this.maturity + ", termination=" + this.termination + "]";
        }
    }
}

