/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.model;

import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.finmath.marketdata.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;

public class AnalyticModelWithVolatilityCubes
extends AnalyticModelFromCurvesAndVols
implements VolatilityCubeModel,
Cloneable {
    private static final long serialVersionUID = 5548526355763266102L;
    private final Map<String, VolatilityCube> volatilityCubeMap = new HashMap<String, VolatilityCube>();

    public AnalyticModelWithVolatilityCubes() {
    }

    public AnalyticModelWithVolatilityCubes(LocalDate referenceDate) {
        super(referenceDate);
    }

    public AnalyticModelWithVolatilityCubes(LocalDate referenceDate, Map<String, Curve> curvesMap, Map<String, VolatilitySurface> volatilitySurfaceMap, Map<String, VolatilityCube> volatilityCubeMap) {
        super(referenceDate, curvesMap, volatilitySurfaceMap);
        this.volatilityCubeMap.putAll(volatilityCubeMap);
    }

    @Override
    public VolatilityCube getVolatilityCube(String name) {
        return this.volatilityCubeMap.get(name);
    }

    @Override
    public VolatilityCubeModel addVolatilityCube(VolatilityCube volatilityCube) {
        LocalDate cubeDate = volatilityCube.getReferenceDate();
        if (this.getReferenceDate() != null && cubeDate != null && !this.getReferenceDate().equals(cubeDate)) {
            throw new IllegalArgumentException("Reference date of curve does not match reference date of model.");
        }
        AnalyticModelWithVolatilityCubes newModel = this.clone();
        newModel.volatilityCubeMap.put(volatilityCube.getName(), volatilityCube);
        return newModel;
    }

    @Override
    public VolatilityCubeModel addVolatilityCube(String volatilityCubeName, VolatilityCube volatilityCube) {
        LocalDate cubeDate = volatilityCube.getReferenceDate();
        if (this.getReferenceDate() != null && cubeDate != null && !this.getReferenceDate().equals(cubeDate)) {
            throw new IllegalArgumentException("Reference date of curve does not match reference date of model.");
        }
        AnalyticModelWithVolatilityCubes newModel = this.clone();
        newModel.volatilityCubeMap.put(volatilityCubeName, volatilityCube);
        return newModel;
    }

    @Override
    public AnalyticModelWithVolatilityCubes clone() {
        return new AnalyticModelWithVolatilityCubes(this.getReferenceDate(), this.getCurves(), this.getVolatilitySurfaces(), this.getVolatilityCubes());
    }

    @Override
    public String toString() {
        return "EnhancedAnalyticModel: curves=" + this.getCurves().keySet() + ", volatilitySurfaces=" + this.getVolatilitySurfaces().keySet() + ", volatilityCubes=" + this.volatilityCubeMap.keySet();
    }

    @Override
    public Set<String> getVolatilityCubeNames() {
        return new HashSet<String>(this.volatilityCubeMap.keySet());
    }

    @Override
    public Map<String, VolatilityCube> getVolatilityCubes() {
        return Collections.unmodifiableMap(this.volatilityCubeMap);
    }
}

