/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.model.volatilities;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;

public class SABRVolatilityCubeSingleSmile
implements VolatilityCube,
Serializable {
    private static final long serialVersionUID = -2465149876882995369L;
    private final String name;
    private final LocalDate referenceDate;
    private final double correlationDecay;
    private final double iborOisDecorrelation;
    private final double underlying;
    private final double sabrAlpha;
    private final double sabrBeta;
    private final double sabrRho;
    private final double sabrNu;
    private final double sabrDisplacement;
    private final VolatilitySurface.QuotingConvention quotingConvention = VolatilitySurface.QuotingConvention.VOLATILITYNORMAL;

    public SABRVolatilityCubeSingleSmile(String name, LocalDate referenceDate, double underlying, double sabrAlpha, double sabrBeta, double sabrRho, double sabrNu, double sabrDisplacement) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.underlying = underlying;
        this.sabrAlpha = sabrAlpha;
        this.sabrBeta = sabrBeta;
        this.sabrRho = sabrRho;
        this.sabrNu = sabrNu;
        this.sabrDisplacement = sabrDisplacement;
        this.correlationDecay = 1.0;
        this.iborOisDecorrelation = 1.0;
    }

    public SABRVolatilityCubeSingleSmile(String name, LocalDate referenceDate, double underlying, double sabrAlpha, double sabrBeta, double sabrRho, double sabrNu, double sabrDisplacement, double correlationDecay) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.underlying = underlying;
        this.sabrAlpha = sabrAlpha;
        this.sabrBeta = sabrBeta;
        this.sabrRho = sabrRho;
        this.sabrNu = sabrNu;
        this.sabrDisplacement = sabrDisplacement;
        this.correlationDecay = correlationDecay;
        this.iborOisDecorrelation = 1.0;
    }

    public SABRVolatilityCubeSingleSmile(String name, LocalDate referenceDate, double underlying, double sabrAlpha, double sabrBeta, double sabrRho, double sabrNu, double sabrDisplacement, double correlationDecay, double iborOisDecorrelation) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.underlying = underlying;
        this.sabrAlpha = sabrAlpha;
        this.sabrBeta = sabrBeta;
        this.sabrRho = sabrRho;
        this.sabrNu = sabrNu;
        this.sabrDisplacement = sabrDisplacement;
        this.correlationDecay = correlationDecay;
        this.iborOisDecorrelation = iborOisDecorrelation;
    }

    @Override
    public double getValue(VolatilityCubeModel model, double termination, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        if (quotingConvention == this.quotingConvention) {
            return AnalyticFormulas.sabrBerestyckiNormalVolatilityApproximation(this.sabrAlpha, this.sabrBeta, this.sabrRho, this.sabrNu, this.sabrDisplacement, this.underlying, strike, maturity);
        }
        throw new IllegalArgumentException("This cube supports only the Quoting Convention " + (Object)((Object)this.quotingConvention));
    }

    @Override
    public double getValue(double termination, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.getValue(null, termination, maturity, strike, quotingConvention);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public String toString() {
        return super.toString() + "\n\"" + this.getName() + "\"" + this.getParameters().toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return new SABRVolatilityCubeSingleSmile(this.name, this.referenceDate, this.underlying, this.sabrAlpha, this.sabrBeta, this.sabrRho, this.sabrNu, this.sabrDisplacement, this.correlationDecay, this.iborOisDecorrelation);
    }

    @Override
    public double getCorrelationDecay() {
        return this.correlationDecay;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sabrAlpha", this.sabrAlpha);
        map.put("sabrBeta", this.sabrBeta);
        map.put("sabrRho", this.sabrRho);
        map.put("sabrNu", this.sabrNu);
        map.put("sabrDisplacement", this.sabrDisplacement);
        map.put("InherentCorrelationDecay", this.correlationDecay);
        map.put("iborOisDecorrelation", this.iborOisDecorrelation);
        map.put("DummyUnderlying", this.underlying);
        return map;
    }

    @Override
    public double getLowestStrike(VolatilityCubeModel model) {
        return -this.sabrDisplacement;
    }

    @Override
    public double getIborOisDecorrelation() {
        return this.iborOisDecorrelation;
    }
}

