/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.model.volatilities;

import java.time.LocalDate;
import net.finmath.marketdata.model.volatilities.SwaptionDataLattice;
import net.finmath.optimizer.SolverException;
import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.calibration.SABRCubeCalibration;
import net.finmath.singleswaprate.calibration.SABRShiftedSmileCalibration;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.SABRVolatilityCube;
import net.finmath.singleswaprate.model.volatilities.SABRVolatilityCubeParallel;
import net.finmath.singleswaprate.model.volatilities.SABRVolatilityCubeParallelFactory;
import net.finmath.time.SchedulePrototype;

public class VolatilityCubeFactory {
    private final LocalDate referenceDate;
    private final double displacement;
    private final double beta;
    private final double correlationDecay;
    private final double iborOisDecorrelation;
    private final SwaptionDataLattice cashPayerPremiums;
    private final SwaptionDataLattice cashReceiverPremiums;
    private final SwaptionDataLattice physicalPremiumsATM;
    private final AnnuityMapping.AnnuityMappingType annuityMappingType;
    private int maxIterations = 250;
    private int numberOfThreads = Runtime.getRuntime().availableProcessors();
    private final boolean replicationUseAsOffset = true;
    private double replicationLowerBound = -0.15;
    private double replicationUpperBound = 0.15;
    private int replicationNumberOfEvaluationPoints = 500;

    public VolatilityCubeFactory(LocalDate referenceDate, SwaptionDataLattice cashPayerPremiums, SwaptionDataLattice cashReceiverPremiums, SwaptionDataLattice physicalPremiumsATM, double displacement, double beta, double correlationDecay, double iborOisDecorrelation, AnnuityMapping.AnnuityMappingType annuityMappingType) {
        this.referenceDate = referenceDate;
        this.cashPayerPremiums = cashPayerPremiums;
        this.cashReceiverPremiums = cashReceiverPremiums;
        this.physicalPremiumsATM = physicalPremiumsATM;
        this.displacement = displacement;
        this.beta = beta;
        this.correlationDecay = correlationDecay;
        this.iborOisDecorrelation = iborOisDecorrelation;
        this.annuityMappingType = annuityMappingType;
    }

    public SABRVolatilityCubeParallel buildParallelSABRCube(String name, double rho, double volvol, SwaptionDataLattice physicalATMSwaptions, VolatilityCubeModel model) {
        SchedulePrototype fixMetaSchedule = this.cashPayerPremiums.getFixMetaSchedule();
        SchedulePrototype floatMetaSchedule = this.cashReceiverPremiums.getFloatMetaSchedule();
        String forwardCurveName = this.cashPayerPremiums.getForwardCurveName();
        return SABRVolatilityCubeParallelFactory.createSABRVolatilityCubeParallel(name, this.referenceDate, fixMetaSchedule, floatMetaSchedule, this.displacement, this.beta, rho, volvol, this.correlationDecay, this.iborOisDecorrelation, physicalATMSwaptions, model, forwardCurveName);
    }

    public SABRVolatilityCube buildShiftedSmileSABRCube(String name, VolatilityCubeModel model) throws SolverException {
        SABRShiftedSmileCalibration calibrator = new SABRShiftedSmileCalibration(this.referenceDate, this.cashPayerPremiums, this.cashReceiverPremiums, this.physicalPremiumsATM, model, this.displacement, this.beta, this.correlationDecay, this.iborOisDecorrelation);
        calibrator.setCalibrationParameters(this.maxIterations, this.numberOfThreads);
        return calibrator.build(name);
    }

    public SABRVolatilityCube buildSABRVolatilityCube(String name, VolatilityCubeModel model, int[] terminations) throws SolverException {
        SABRCubeCalibration calibrator = new SABRCubeCalibration(this.referenceDate, this.cashPayerPremiums, this.cashReceiverPremiums, this.physicalPremiumsATM, model, this.annuityMappingType, this.displacement, this.beta, this.correlationDecay, this.iborOisDecorrelation);
        calibrator.setCalibrationParameters(this.maxIterations, this.numberOfThreads);
        calibrator.setReplicationParameters(true, this.replicationLowerBound, this.replicationUpperBound, this.replicationNumberOfEvaluationPoints);
        return calibrator.calibrate(name, terminations);
    }

    public SABRVolatilityCube buildSABRVolatilityCube(String name, VolatilityCubeModel model, int[] terminations, DataTable initialRhos, DataTable initialBaseVols, DataTable initialVolvols) throws SolverException {
        SABRCubeCalibration calibrator = new SABRCubeCalibration(this.referenceDate, this.cashPayerPremiums, this.cashReceiverPremiums, this.physicalPremiumsATM, model, this.annuityMappingType, this.displacement, this.beta, this.correlationDecay, this.iborOisDecorrelation);
        calibrator.setCalibrationParameters(this.maxIterations, this.numberOfThreads);
        calibrator.setReplicationParameters(true, this.replicationLowerBound, this.replicationUpperBound, this.replicationNumberOfEvaluationPoints);
        calibrator.setInitialParameters(initialRhos, initialBaseVols, initialVolvols);
        return calibrator.calibrate(name, terminations);
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setCalibrationParameters(int maxIterations, int numberOfThreads) {
        this.maxIterations = maxIterations;
        this.numberOfThreads = numberOfThreads;
    }

    public void setReplicationParameters(double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        this.replicationLowerBound = lowerBound;
        this.replicationUpperBound = upperBound;
        this.replicationNumberOfEvaluationPoints = numberOfEvaluationPoints;
    }

    public double getReplicationLowerBound() {
        return this.replicationLowerBound;
    }

    public double getReplicationUpperBound() {
        return this.replicationUpperBound;
    }

    public double getReplicationNumberOfEvaluationPoints() {
        return this.replicationNumberOfEvaluationPoints;
    }
}

