/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.products;

import java.util.function.DoubleUnaryOperator;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.integration.SimpsonRealIntegrator;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.marketdata.products.Swap;
import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.products.AbstractAnalyticVolatilityCubeProduct;
import net.finmath.time.Schedule;

public abstract class AbstractSingleSwapRateProduct
extends AbstractAnalyticVolatilityCubeProduct {
    private final Schedule fixSchedule;
    private final Schedule floatSchedule;
    private final String discountCurveName;
    private final String forwardCurveName;
    private final String volatilityCubeName;
    private final VolatilitySurface.QuotingConvention quotingConvention = VolatilitySurface.QuotingConvention.VOLATILITYNORMAL;
    private double lowerBound = -0.15;
    private double upperBound = 0.15;
    private int numberOfEvaluationPoints = 500;

    public AbstractSingleSwapRateProduct(Schedule fixSchedule, Schedule floatSchedule, String discountCurveName, String forwardCurveName, String volatilityCubeName) {
        this.fixSchedule = fixSchedule;
        this.floatSchedule = floatSchedule;
        this.discountCurveName = discountCurveName;
        this.forwardCurveName = forwardCurveName;
        this.volatilityCubeName = volatilityCubeName;
    }

    public void setIntegrationParameters(double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.numberOfEvaluationPoints = numberOfEvaluationPoints;
    }

    public double getIntegrationLowerBound() {
        return this.lowerBound;
    }

    public double getIntegrationUpperBound() {
        return this.upperBound;
    }

    public int getIntegrationNumberOfEvaluationPoints() {
        return this.numberOfEvaluationPoints;
    }

    @Override
    public double getValue(double evaluationTime, VolatilityCubeModel model) {
        return this.getValue(evaluationTime, null, model);
    }

    public double getValue(double evaluationTime, AnnuityMapping annuityMapping, VolatilityCubeModel model) {
        if (evaluationTime > this.getFixSchedule().getPeriodStart(0)) {
            throw new IllegalArgumentException("This framework is not set up to evaluate the product " + this.getClass() + " at a time larger than the start of the first period (" + this.getFixSchedule().getPeriodStart(0) + "). Requested time was " + evaluationTime);
        }
        ForwardCurve forwardCurve = this.getForwardCurveName() == null ? new ForwardCurveFromDiscountCurve("From" + this.getDiscountCurveName(), this.getDiscountCurveName(), this.getFixSchedule().getReferenceDate(), "6M") : model.getForwardCurve(this.getForwardCurveName());
        double forwardSwapRate = Swap.getForwardSwapRate(this.getFixSchedule(), this.getFloatSchedule(), forwardCurve, model);
        AnnuityMapping internalAnnuityMapping = annuityMapping == null ? this.buildAnnuityMapping(model) : annuityMapping;
        double receiverLeg = 0.0;
        double payerLeg = 0.0;
        double lowerBound = this.getVolatilityCubeName() == null ? this.lowerBound : Math.max(this.lowerBound, model.getVolatilityCube(this.getVolatilityCubeName()).getLowestStrike(model));
        SimpsonRealIntegrator receiverIntegral = new SimpsonRealIntegrator(lowerBound, forwardSwapRate, this.numberOfEvaluationPoints);
        SimpsonRealIntegrator payerIntegral = new SimpsonRealIntegrator(forwardSwapRate, this.upperBound, this.numberOfEvaluationPoints);
        DoubleUnaryOperator receiverIntegrand = x -> this.hedgeWeight(x, internalAnnuityMapping, model) * this.valuePut(x, model, forwardSwapRate);
        DoubleUnaryOperator payerIntegrand = x -> this.hedgeWeight(x, internalAnnuityMapping, model) * this.valueCall(x, model, forwardSwapRate);
        receiverLeg = receiverIntegral.integrate(receiverIntegrand);
        payerLeg = payerIntegral.integrate(payerIntegrand);
        double value = this.payoffFunction(forwardSwapRate, internalAnnuityMapping, model) + receiverLeg + payerLeg + this.singularAddon(forwardSwapRate, internalAnnuityMapping, model);
        if (evaluationTime != this.getFixSchedule().getPeriodStart(0)) {
            value *= model.getDiscountCurve(this.getDiscountCurveName()).getDiscountFactor(model, this.getFixSchedule().getPeriodStart(0)) / model.getDiscountCurve(this.getDiscountCurveName()).getDiscountFactor(model, evaluationTime);
        }
        return value;
    }

    protected abstract double payoffFunction(double var1, AnnuityMapping var3, VolatilityCubeModel var4);

    protected abstract double hedgeWeight(double var1, AnnuityMapping var3, VolatilityCubeModel var4);

    protected abstract double singularAddon(double var1, AnnuityMapping var3, VolatilityCubeModel var4);

    protected abstract AnnuityMapping buildAnnuityMapping(VolatilityCubeModel var1);

    protected double valuePut(double optionStrike, VolatilityCubeModel model, double swapRate) {
        return this.valueCall(optionStrike, model, swapRate) - (swapRate - optionStrike);
    }

    protected double valueCall(double optionStrike, VolatilityCubeModel model, double swapRate) {
        double optionMaturity = this.getFixSchedule().getFixing(0);
        double termination = this.getFixSchedule().getPayment(this.getFixSchedule().getNumberOfPeriods() - 1);
        double volatility = model.getVolatilityCube(this.getVolatilityCubeName()).getValue(model, termination, optionMaturity, optionStrike, this.quotingConvention);
        double value = AnalyticFormulas.bachelierOptionValue(swapRate, volatility, optionMaturity, optionStrike, 1.0);
        return value;
    }

    public Schedule getFixSchedule() {
        return this.fixSchedule;
    }

    public Schedule getFloatSchedule() {
        return this.floatSchedule;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public String getVolatilityCubeName() {
        return this.volatilityCubeName;
    }
}

