/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.products;

import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.annuitymapping.AnnuityMappingFactory;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.products.AbstractSingleSwapRateProduct;
import net.finmath.time.Schedule;

public class ConstantMaturitySwap
extends AbstractSingleSwapRateProduct {
    private final AnnuityMapping.AnnuityMappingType annuityMappingType;

    public ConstantMaturitySwap(Schedule fixSchedule, Schedule floatSchedule, String discountCurveName, String forwardCurveName, String volatilityCubeName, AnnuityMapping.AnnuityMappingType annuityMappingType) {
        super(fixSchedule, floatSchedule, discountCurveName, forwardCurveName, volatilityCubeName);
        this.annuityMappingType = annuityMappingType;
    }

    @Override
    protected double payoffFunction(double swapRate, AnnuityMapping annuityMapping, VolatilityCubeModel model) {
        return swapRate * annuityMapping.getValue(swapRate);
    }

    @Override
    protected double hedgeWeight(double swapRate, AnnuityMapping annuityMapping, VolatilityCubeModel model) {
        return 2.0 * annuityMapping.getFirstDerivative(swapRate) + swapRate * annuityMapping.getSecondDerivative(swapRate);
    }

    @Override
    protected double singularAddon(double swapRate, AnnuityMapping annuityMapping, VolatilityCubeModel model) {
        return 0.0;
    }

    @Override
    protected AnnuityMapping buildAnnuityMapping(VolatilityCubeModel model) {
        AnnuityMappingFactory factory = new AnnuityMappingFactory(this.getFixSchedule(), this.getFloatSchedule(), this.getDiscountCurveName(), this.getForwardCurveName(), this.getVolatilityCubeName());
        return factory.build(this.annuityMappingType, model);
    }

    public static double analyticApproximation(double swaprate, double volatility, double swapAnnuity, double swapFixing, double swapMaturity, double payoffUnit) {
        double a = 1.0 / (swapMaturity - swapFixing);
        double b = (payoffUnit / swapAnnuity - a) / swaprate;
        double convexityAdjustment = volatility * volatility * swapFixing;
        double valueAdjusted = swaprate + convexityAdjustment;
        return (a * valueAdjusted + b * valueAdjusted * valueAdjusted + b * convexityAdjustment) / (a + b * valueAdjusted);
    }
}

