/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.stochastic;

import net.finmath.stochastic.ConditionalExpectationEstimator;
import net.finmath.stochastic.RandomOperator;
import net.finmath.stochastic.RandomVariable;

public interface RandomVariableArray
extends RandomVariable {
    public int getNumberOfElements();

    public RandomVariable getElement(int var1);

    default public int getLevel() {
        RandomVariable element = this.getElement(0);
        if (element instanceof RandomVariableArray) {
            return ((RandomVariableArray)element).getLevel() + 1;
        }
        return 1;
    }

    default public Object toDoubleArray() {
        if (this.getLevel() == 1) {
            double[] doubleArray = new double[this.getNumberOfElements()];
            for (int i = 0; i < this.getNumberOfElements(); ++i) {
                doubleArray[i] = this.getElement(i).doubleValue();
            }
            return doubleArray;
        }
        Object[] doubleArray = new Object[this.getNumberOfElements()];
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            doubleArray[i] = ((RandomVariableArray)this.getElement(i)).toDoubleArray();
        }
        return doubleArray;
    }

    public RandomVariableArray map(RandomOperator var1);

    public RandomVariable sumProduct(RandomVariableArray var1);

    @Override
    default public RandomVariableArray getConditionalExpectation(final ConditionalExpectationEstimator conditionalExpectationOperator) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return conditionalExpectationOperator.getConditionalExpectation(x);
            }
        });
    }
}

