/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.stochastic;

import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.stochastic.RandomOperator;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.RandomVariableArray;

public class RandomVariableArrayImplementation
implements RandomVariableArray {
    private static final long serialVersionUID = -5718980901166760522L;
    private final RandomVariable[] elements;

    public static RandomVariableArray of(RandomVariable[] elements) {
        return new RandomVariableArrayImplementation((RandomVariable[])elements.clone());
    }

    private RandomVariableArrayImplementation(RandomVariable[] elements) {
        if (elements.length == 0) {
            throw new IllegalArgumentException("Empty array.");
        }
        int level = this.getLevel(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            if (this.getLevel(elements[i]) == level) continue;
            throw new IllegalArgumentException("Elements must be of same array type.");
        }
        this.elements = elements;
    }

    private int getLevel(RandomVariable randomVariable) {
        if (randomVariable instanceof RandomVariableArray) {
            return ((RandomVariableArray)randomVariable).getLevel();
        }
        return 0;
    }

    @Override
    public int getNumberOfElements() {
        return this.elements.length;
    }

    @Override
    public RandomVariable getElement(int index) {
        return this.elements[index];
    }

    @Override
    public RandomVariableArray map(RandomOperator operator) {
        RandomVariable[] newElments = new RandomVariable[this.getNumberOfElements()];
        for (int i = 1; i < this.elements.length; ++i) {
            newElments[i] = operator.apply(this.elements[i]);
        }
        return new RandomVariableArrayImplementation(newElments);
    }

    @Override
    public RandomVariable sumProduct(RandomVariableArray array) {
        RandomVariable result = this.elements[0].mult(array.getElement(0));
        for (int i = 1; i < this.elements.length; ++i) {
            result = result.add(this.elements[i].mult(array.getElement(i)));
        }
        return result;
    }

    @Override
    public boolean equals(RandomVariable randomVariable) {
        boolean equal = randomVariable instanceof RandomVariableArray;
        for (int i = 0; i < this.getNumberOfElements() && equal; equal &= this.getElement(i).equals(((RandomVariableArray)randomVariable).getElement(i)), ++i) {
        }
        return equal;
    }

    @Override
    public double getFiltrationTime() {
        double time = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            time = Math.max(this.getElement(i).getFiltrationTime(), time);
        }
        return time;
    }

    @Override
    public int getTypePriority() {
        return 100;
    }

    @Override
    public double get(int pathOrState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = 1;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            size = Math.max(size, this.getElement(i).size());
        }
        return size;
    }

    @Override
    public boolean isDeterministic() {
        boolean deterministic = true;
        for (int i = 0; i < this.getNumberOfElements() && deterministic; deterministic &= this.getElement(i).isDeterministic(), ++i) {
        }
        return deterministic;
    }

    @Override
    public double[] getRealizations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double doubleValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntToDoubleFunction getOperator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DoubleStream getRealizationsStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getMin() {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            min = Math.min(min, this.getElement(i).getMin());
        }
        return min;
    }

    @Override
    public double getMax() {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.getNumberOfElements(); ++i) {
            max = Math.max(max, this.getElement(i).getMax());
        }
        return max;
    }

    @Override
    public double getAverage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getAverage(RandomVariable probabilities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getVariance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getVariance(RandomVariable probabilities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getSampleVariance() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getStandardDeviation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getStandardDeviation(RandomVariable probabilities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getStandardError() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getStandardError(RandomVariable probabilities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getQuantile(double quantile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getQuantile(double quantile, RandomVariable probabilities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] getHistogram(double[] intervalPoints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RandomVariable cache() {
        return this;
    }

    @Override
    public RandomVariable apply(final DoubleUnaryOperator operator) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.apply(operator);
            }
        });
    }

    @Override
    public RandomVariable apply(final DoubleBinaryOperator operator, final RandomVariable argument) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.apply(operator, argument);
            }
        });
    }

    @Override
    public RandomVariable apply(final DoubleTernaryOperator operator, final RandomVariable argument1, final RandomVariable argument2) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.apply(operator, argument1, argument2);
            }
        });
    }

    @Override
    public RandomVariable cap(final double cap) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.cap(cap);
            }
        });
    }

    @Override
    public RandomVariable floor(final double floor) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.floor(floor);
            }
        });
    }

    @Override
    public RandomVariable add(final double value) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.add(value);
            }
        });
    }

    @Override
    public RandomVariable sub(final double value) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.sub(value);
            }
        });
    }

    @Override
    public RandomVariable mult(final double value) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.mult(value);
            }
        });
    }

    @Override
    public RandomVariable div(final double value) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.div(value);
            }
        });
    }

    @Override
    public RandomVariable pow(final double exponent) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.pow(exponent);
            }
        });
    }

    @Override
    public RandomVariable average() {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.average();
            }
        });
    }

    @Override
    public RandomVariable squared() {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.squared();
            }
        });
    }

    @Override
    public RandomVariable sqrt() {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.sqrt();
            }
        });
    }

    @Override
    public RandomVariable exp() {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.exp();
            }
        });
    }

    @Override
    public RandomVariable log() {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.log();
            }
        });
    }

    @Override
    public RandomVariable sin() {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.sin();
            }
        });
    }

    @Override
    public RandomVariable cos() {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.cos();
            }
        });
    }

    @Override
    public RandomVariable add(final RandomVariable randomVariable) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.add(randomVariable);
            }
        });
    }

    @Override
    public RandomVariable sub(final RandomVariable randomVariable) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.sub(randomVariable);
            }
        });
    }

    @Override
    public RandomVariable bus(final RandomVariable randomVariable) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.bus(randomVariable);
            }
        });
    }

    @Override
    public RandomVariable mult(final RandomVariable randomVariable) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.mult(randomVariable);
            }
        });
    }

    @Override
    public RandomVariable div(final RandomVariable randomVariable) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.div(randomVariable);
            }
        });
    }

    @Override
    public RandomVariable vid(final RandomVariable randomVariable) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.vid(randomVariable);
            }
        });
    }

    @Override
    public RandomVariable cap(final RandomVariable cap) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.cap(cap);
            }
        });
    }

    @Override
    public RandomVariable floor(final RandomVariable floor) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.cap(floor);
            }
        });
    }

    @Override
    public RandomVariable accrue(final RandomVariable rate, final double periodLength) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.accrue(rate, periodLength);
            }
        });
    }

    @Override
    public RandomVariable discount(final RandomVariable rate, final double periodLength) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.discount(rate, periodLength);
            }
        });
    }

    @Override
    public RandomVariable choose(final RandomVariable valueIfTriggerNonNegative, final RandomVariable valueIfTriggerNegative) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.choose(valueIfTriggerNonNegative, valueIfTriggerNegative);
            }
        });
    }

    @Override
    public RandomVariable invert() {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.invert();
            }
        });
    }

    @Override
    public RandomVariable abs() {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.abs();
            }
        });
    }

    @Override
    public RandomVariable addProduct(final RandomVariable factor1, final double factor2) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.addProduct(factor1, factor2);
            }
        });
    }

    @Override
    public RandomVariable addProduct(final RandomVariable factor1, final RandomVariable factor2) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.addProduct(factor1, factor2);
            }
        });
    }

    @Override
    public RandomVariable addRatio(final RandomVariable numerator, final RandomVariable denominator) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.addRatio(numerator, denominator);
            }
        });
    }

    @Override
    public RandomVariable subRatio(final RandomVariable numerator, final RandomVariable denominator) {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.subRatio(numerator, denominator);
            }
        });
    }

    @Override
    public RandomVariable isNaN() {
        return this.map(new RandomOperator(){

            @Override
            public RandomVariable apply(RandomVariable x) {
                return x.isNaN();
            }
        });
    }
}

