/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.JTextField;
import net.finmath.time.TimeDiscretization;

public class JNumberField
extends JTextField
implements ActionListener {
    private static final long serialVersionUID = -138039675088007707L;
    private Number value = new Double(0.0);
    private DecimalFormat formatter = new DecimalFormat("0.000");
    private final Object updateLock = new Object();
    private double preferedValueIncrement = 0.0;
    private double[] admissibleValues = null;
    private double lowerBound = -1.7976931348623157E308;
    private double upperBound = Double.MAX_VALUE;

    public JNumberField() {
        this.addActionListener(this);
    }

    public JNumberField(double value, String format, ActionListener actionListener) {
        this.formatter = new DecimalFormat(format);
        this.addActionListener(actionListener);
        this.addActionListener(this);
        this.setValue(value);
    }

    public JNumberField(double value, DecimalFormat format, ActionListener actionListener) {
        this.formatter = format;
        this.addActionListener(actionListener);
        this.addActionListener(this);
        this.setValue(value);
    }

    public JNumberField(String format) {
        super(format);
        this.formatter = new DecimalFormat(format);
        this.addActionListener(this);
        this.setValue(0.0);
    }

    public Number getValue() {
        this.parseField();
        this.updateData();
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        this.updateData();
    }

    public void setFromat(String format) {
        this.formatter = new DecimalFormat(format);
        this.updateData();
    }

    public void setRange(double lowerBound, double upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.updateData();
    }

    public void setAdmissibleValues(double[] admissibleValues) {
        this.admissibleValues = admissibleValues;
    }

    public void setAdmissibleValues(TimeDiscretization timeDiscretization) {
        this.admissibleValues = new double[timeDiscretization.getNumberOfTimeSteps() + 1];
        for (int i = 0; i < this.admissibleValues.length; ++i) {
            this.admissibleValues[i] = timeDiscretization.getTime(i);
        }
    }

    public double getPreferedValueIncrement() {
        return this.preferedValueIncrement;
    }

    public void setPreferedValueIncrement(double preferedValueIncrement) {
        this.preferedValueIncrement = preferedValueIncrement;
    }

    public void add(double increment) {
        this.setValue(this.getDoubleValue() + increment);
    }

    public void addToAdmissibleValueIndex(int increment) {
        if (this.admissibleValues != null) {
            int index = this.getAdmissibleValueIndex();
            if (index < 0) {
                return;
            }
            index = Math.max(0, Math.min(index + increment, this.admissibleValues.length - 1));
            this.value = this.admissibleValues[index];
        } else {
            this.add((double)increment * this.preferedValueIncrement);
        }
        this.updateData();
    }

    public double getDoubleValue() {
        return this.getValue().doubleValue();
    }

    public int getIntValue() {
        return this.getValue().intValue();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.parseField();
        this.updateData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseField() {
        Double valueNumber = Double.NaN;
        Object object = this.updateLock;
        synchronized (object) {
            String valueText = this.getText();
            if (valueText != null) {
                try {
                    valueNumber = this.formatter.parse(this.getText()).doubleValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        this.setValue(valueNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateData() {
        if (this.value == null) {
            this.parseField();
        }
        Object object = this.updateLock;
        synchronized (object) {
            int index = this.getAdmissibleValueIndex();
            if (index >= 0) {
                this.value = this.admissibleValues[index];
            }
            this.value = new Double(Math.min(Math.max(this.lowerBound, this.value.doubleValue()), this.upperBound));
            this.setText(this.formatter.format(this.value));
            if (this.lowerBound != -1.7976931348623157E308 && this.upperBound != Double.MAX_VALUE) {
                this.setColumns(1 + Math.max(this.formatter.format(this.lowerBound).length(), this.formatter.format(this.upperBound).length()));
            } else {
                this.setColumns(1 + this.getText().length());
            }
        }
    }

    private int getAdmissibleValueIndex() {
        if (this.admissibleValues != null && this.admissibleValues.length > 0) {
            int index = Arrays.binarySearch(this.admissibleValues, this.value.doubleValue());
            if (index < 0) {
                index = -index - 1;
            }
            if (index > this.admissibleValues.length) {
                --index;
            }
            return index;
        }
        return -1;
    }
}

