/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.daycount.DayCountConvention;

public class ScheduleFromPeriods
implements Schedule,
Serializable {
    private static final long serialVersionUID = 4460864939790714361L;
    private final LocalDate referenceDate;
    private final List<Period> periods;
    private final DayCountConvention daycountconvention;
    private final double[] fixingTimes;
    private final double[] paymentTimes;
    private final double[] periodStartTimes;
    private final double[] periodEndTimes;
    private final double[] periodLength;

    public ScheduleFromPeriods(LocalDate referenceDate, DayCountConvention daycountconvention, Period ... periods) {
        this(referenceDate, Arrays.asList(periods), daycountconvention);
    }

    public ScheduleFromPeriods(LocalDate referenceDate, List<Period> periods, DayCountConvention daycountconvention) {
        if (referenceDate == null) {
            throw new IllegalArgumentException("referenceDate must not be null.");
        }
        this.referenceDate = referenceDate;
        this.periods = periods;
        this.daycountconvention = daycountconvention;
        this.fixingTimes = new double[periods.size()];
        this.paymentTimes = new double[periods.size()];
        this.periodStartTimes = new double[periods.size()];
        this.periodEndTimes = new double[periods.size()];
        this.periodLength = new double[periods.size()];
        for (int periodIndex = 0; periodIndex < periods.size(); ++periodIndex) {
            this.fixingTimes[periodIndex] = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periods.get(periodIndex).getFixing());
            this.paymentTimes[periodIndex] = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periods.get(periodIndex).getPayment());
            this.periodStartTimes[periodIndex] = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periods.get(periodIndex).getPeriodStart());
            this.periodEndTimes[periodIndex] = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, periods.get(periodIndex).getPeriodEnd());
            this.periodLength[periodIndex] = daycountconvention.getDaycountFraction(periods.get(periodIndex).getPeriodStart(), periods.get(periodIndex).getPeriodEnd());
        }
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public List<Period> getPeriods() {
        return this.periods;
    }

    @Override
    public DayCountConvention getDaycountconvention() {
        return this.daycountconvention;
    }

    @Override
    public int getNumberOfPeriods() {
        return this.periods.size();
    }

    @Override
    public Period getPeriod(int periodIndex) {
        return this.periods.get(periodIndex);
    }

    @Override
    public double getFixing(int periodIndex) {
        return this.fixingTimes[periodIndex];
    }

    @Override
    public double getPayment(int periodIndex) {
        return this.paymentTimes[periodIndex];
    }

    @Override
    public double getPeriodStart(int periodIndex) {
        return this.periodStartTimes[periodIndex];
    }

    @Override
    public double getPeriodEnd(int periodIndex) {
        return this.periodEndTimes[periodIndex];
    }

    @Override
    public double getPeriodLength(int periodIndex) {
        return this.periodLength[periodIndex];
    }

    @Override
    public Iterator<Period> iterator() {
        return this.periods.iterator();
    }

    @Override
    public int getPeriodIndex(double time) {
        if (time < this.getPeriodStart(0) || time >= this.getPeriodEnd(this.getNumberOfPeriods() - 1)) {
            throw new IllegalArgumentException("Time point not included");
        }
        for (int i = 0; i < this.getNumberOfPeriods() - 1; ++i) {
            if (!(time <= this.getPeriodEnd(i))) continue;
            return i;
        }
        return this.getNumberOfPeriods() - 1;
    }

    @Override
    public int getPeriodIndex(LocalDate date) {
        double floatingDate = FloatingpointDate.getFloatingPointDateFromDate(this.getReferenceDate(), date);
        return this.getPeriodIndex(floatingDate);
    }

    public String toString() {
        String periodOutputString = "Periods (fixing, periodStart, periodEnd, payment):";
        for (int periodIndex = 0; periodIndex < this.periods.size(); ++periodIndex) {
            periodOutputString = periodOutputString + "\n" + this.periods.get(periodIndex).getFixing() + ", " + this.periods.get(periodIndex).getPeriodStart() + ", " + this.periods.get(periodIndex).getPeriodEnd() + ", " + this.periods.get(periodIndex).getPayment();
        }
        return "ScheduleFromPeriods [referenceDate=" + this.referenceDate + ", daycountconvention=" + this.daycountconvention + "\n" + periodOutputString + "]";
    }
}

