/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.Month;
import net.finmath.time.daycount.DayCountConvention_ACT;

public class DayCountConvention_ACT_ACT_AFB
extends DayCountConvention_ACT
implements Serializable {
    private static final long serialVersionUID = 3362135261620939045L;

    @Override
    public double getDaycountFraction(LocalDate startDate, LocalDate endDate) {
        LocalDate feb29th;
        if (startDate.isAfter(endDate)) {
            return -this.getDaycountFraction(endDate, startDate);
        }
        LocalDate fractionalPeriodEnd = endDate.plusYears(startDate.getYear() - endDate.getYear());
        if (endDate.getDayOfMonth() == endDate.lengthOfMonth()) {
            fractionalPeriodEnd = fractionalPeriodEnd.withDayOfMonth(fractionalPeriodEnd.lengthOfMonth());
        }
        if (fractionalPeriodEnd.isBefore(startDate)) {
            fractionalPeriodEnd.plusYears(1L);
            if (endDate.getDayOfMonth() == endDate.lengthOfMonth()) {
                fractionalPeriodEnd = fractionalPeriodEnd.withDayOfMonth(fractionalPeriodEnd.lengthOfMonth());
            }
        }
        double daycountFraction = endDate.getYear() - fractionalPeriodEnd.getYear();
        double fractionPeriodDenominator = 365.0;
        if (fractionalPeriodEnd.isLeapYear()) {
            LocalDate feb29th2 = LocalDate.of(fractionalPeriodEnd.getYear(), Month.FEBRUARY, 29);
            if (startDate.compareTo(feb29th2) <= 0 && fractionalPeriodEnd.compareTo(feb29th2) > 0) {
                fractionPeriodDenominator = 366.0;
            }
        } else if (startDate.isLeapYear() && startDate.compareTo(feb29th = LocalDate.of(startDate.getYear(), Month.FEBRUARY, 29)) <= 0 && fractionalPeriodEnd.compareTo(feb29th) > 0) {
            fractionPeriodDenominator = 366.0;
        }
        return daycountFraction += this.getDaycount(startDate, fractionalPeriodEnd) / fractionPeriodDenominator;
    }

    public String toString() {
        return "DayCountConvention_ACT_ACT_AFB";
    }
}

