/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.Month;
import java.time.chrono.IsoChronology;
import net.finmath.time.daycount.DayCountConvention;
import net.finmath.time.daycount.DayCountConvention_ACT;

public class DayCountConvention_NL_365
implements DayCountConvention,
Serializable {
    private static final long serialVersionUID = -8175671041380283261L;

    @Override
    public double getDaycount(LocalDate startDate, LocalDate endDate) {
        if (startDate.isAfter(endDate)) {
            return -this.getDaycount(endDate, startDate);
        }
        double daycount = DayCountConvention_ACT.daysBetween(startDate, endDate);
        for (int year = startDate.getYear(); year <= endDate.getYear(); ++year) {
            LocalDate leapDay;
            if (!IsoChronology.INSTANCE.isLeapYear(year) || !startDate.isBefore(leapDay = LocalDate.of(year, Month.FEBRUARY, 29)) || endDate.isBefore(leapDay)) continue;
            daycount -= 1.0;
        }
        if (daycount < 0.0) {
            throw new AssertionError((Object)"Daycount is negative for startDate not after endDate.");
        }
        return daycount;
    }

    @Override
    public double getDaycountFraction(LocalDate startDate, LocalDate endDate) {
        if (startDate.isAfter(endDate)) {
            return -this.getDaycountFraction(endDate, startDate);
        }
        double daycountFraction = this.getDaycount(startDate, endDate) / 365.0;
        return daycountFraction;
    }
}

