/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.timeseries.models.parametric;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.timeseries.HistoricalSimulationModel;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.direct.CMAESOptimizer;

public class DisplacedLognormal
implements HistoricalSimulationModel {
    private final double[] values;
    private final double lowerBoundDisplacement;
    private final double upperBoundDisplacement = 1.0E7;
    private final int windowIndexStart;
    private final int windowIndexEnd;
    private final int maxIterations = 1000000;

    public DisplacedLognormal(double[] values) {
        this.values = values;
        this.windowIndexStart = 0;
        this.windowIndexEnd = values.length - 1;
        double valuesMin = Double.MAX_VALUE;
        for (int i = this.windowIndexStart; i <= this.windowIndexEnd; ++i) {
            valuesMin = Math.min(values[i], valuesMin);
        }
        this.lowerBoundDisplacement = -valuesMin + 1.0;
    }

    public DisplacedLognormal(double[] values, double lowerBoundDisplacement) {
        this.values = values;
        this.windowIndexStart = 0;
        this.windowIndexEnd = values.length - 1;
        double valuesMin = Double.MAX_VALUE;
        for (int i = this.windowIndexStart; i <= this.windowIndexEnd; ++i) {
            valuesMin = Math.min(values[i], valuesMin);
        }
        this.lowerBoundDisplacement = Math.max(-valuesMin + 1.0, lowerBoundDisplacement);
    }

    public DisplacedLognormal(double[] values, int windowIndexStart, int windowIndexEnd) {
        this.values = values;
        this.windowIndexStart = windowIndexStart;
        this.windowIndexEnd = windowIndexEnd;
        double valuesMin = Double.MAX_VALUE;
        for (int i = windowIndexStart; i <= windowIndexEnd; ++i) {
            valuesMin = Math.min(values[i], valuesMin);
        }
        this.lowerBoundDisplacement = -valuesMin + 1.0;
    }

    public DisplacedLognormal(double[] values, double lowerBoundDisplacement, int windowIndexStart, int windowIndexEnd) {
        this.values = values;
        this.windowIndexStart = windowIndexStart;
        this.windowIndexEnd = windowIndexEnd;
        double valuesMin = Double.MAX_VALUE;
        for (int i = windowIndexStart; i <= windowIndexEnd; ++i) {
            valuesMin = Math.min(values[i], valuesMin);
        }
        this.lowerBoundDisplacement = Math.max(-valuesMin + 1.0, lowerBoundDisplacement);
    }

    @Override
    public HistoricalSimulationModel getCloneWithWindow(int windowIndexStart, int windowIndexEnd) {
        return new DisplacedLognormal(this.values, windowIndexStart, windowIndexEnd);
    }

    public HistoricalSimulationModel getCloneWithWindow(double lowerBoundDisplacement, int windowIndexStart, int windowIndexEnd) {
        return new DisplacedLognormal(this.values, lowerBoundDisplacement, windowIndexStart, windowIndexEnd);
    }

    public double getLogLikelihoodForParameters(double omega, double alpha, double beta, double displacement) {
        double logLikelihood = 0.0;
        double volScaling = 1.0 + Math.abs(displacement);
        double volSquaredEstimate = 0.0;
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd - 1; ++i) {
            double eval = volScaling * Math.log((this.values[i] + displacement) / (this.values[i - 1] + displacement));
            volSquaredEstimate += eval * eval;
        }
        volSquaredEstimate /= (double)(this.windowIndexEnd - this.windowIndexStart);
        double eval = volScaling * Math.log((this.values[this.windowIndexStart + 1] + displacement) / (this.values[this.windowIndexStart + 1 - 1] + displacement));
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd - 1; ++i) {
            double evalNext = volScaling * Math.log((this.values[i + 1] + displacement) / (this.values[i] + displacement));
            double volSquared = volSquaredEstimate / volScaling * volScaling;
            logLikelihood += -Math.log(volSquaredEstimate) - 2.0 * Math.log((this.values[i + 1] + displacement) / volScaling) - evalNext * evalNext / volSquaredEstimate;
            eval = evalNext;
        }
        logLikelihood += -Math.log(Math.PI * 2) * (double)(this.windowIndexEnd - this.windowIndexStart);
        return logLikelihood *= 0.5;
    }

    public double getLastResidualForParameters(double omega, double alpha, double beta, double displacement) {
        double volScaling = 1.0 + Math.abs(displacement);
        double h = omega / (1.0 - alpha - beta);
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd; ++i) {
            double eval = volScaling * Math.log((this.values[i] + displacement) / (this.values[i - 1] + displacement));
            h = omega + alpha * eval * eval + beta * h;
        }
        return h;
    }

    public double[] getQuantilPredictionsForParameters(double omega, double alpha, double beta, double displacement, double[] quantiles) {
        double[] szenarios = new double[this.windowIndexEnd - this.windowIndexStart + 1 - 1];
        double volScaling = 1.0 + Math.abs(displacement);
        double volSquaredEstimate = 0.0;
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd - 1; ++i) {
            double eval = volScaling * Math.log((this.values[i] + displacement) / (this.values[i - 1] + displacement));
            volSquaredEstimate += eval * eval;
        }
        double vol = Math.sqrt(volSquaredEstimate /= (double)(this.windowIndexEnd - this.windowIndexStart)) / volScaling;
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd; ++i) {
            double y = Math.log((this.values[i] + displacement) / (this.values[i - 1] + displacement));
            szenarios[i - this.windowIndexStart - 1] = y / vol;
            double eval = volScaling * y;
            vol = Math.sqrt(volSquaredEstimate) / volScaling;
        }
        Arrays.sort(szenarios);
        double[] quantileValues = new double[quantiles.length];
        for (int i = 0; i < quantiles.length; ++i) {
            double quantileValue;
            double quantile = quantiles[i];
            double quantileIndex = (double)szenarios.length * quantile - 1.0;
            int quantileIndexLo = (int)quantileIndex;
            int quantileIndexHi = quantileIndexLo + 1;
            double szenarioRelativeChange = ((double)quantileIndexHi - quantileIndex) * Math.exp(szenarios[Math.max(quantileIndexLo, 0)] * vol) + (quantileIndex - (double)quantileIndexLo) * Math.exp(szenarios[Math.min(quantileIndexHi, szenarios.length)] * vol);
            quantileValues[i] = quantileValue = (this.values[this.windowIndexEnd] + displacement) * szenarioRelativeChange - displacement;
        }
        return quantileValues;
    }

    @Override
    public Map<String, Object> getBestParameters() {
        return this.getBestParameters(null);
    }

    @Override
    public Map<String, Object> getBestParameters(Map<String, Object> guess) {
        class GARCHMaxLikelihoodFunction
        implements MultivariateFunction,
        Serializable {
            private static final long serialVersionUID = 7072187082052755854L;

            GARCHMaxLikelihoodFunction() {
            }

            public double value(double[] variables) {
                double omega = Math.exp(variables[0]);
                double mucorr = Math.exp(-Math.exp(-variables[1]));
                double muema = Math.exp(-Math.exp(-variables[2]));
                double beta = mucorr * muema;
                double alpha = mucorr - beta;
                double displacementNormed = 1.0 / (1.0 + Math.exp(-variables[3]));
                double displacement = (1.0E7 - DisplacedLognormal.this.lowerBoundDisplacement) * displacementNormed + DisplacedLognormal.this.lowerBoundDisplacement;
                double logLikelihood = DisplacedLognormal.this.getLogLikelihoodForParameters(omega, alpha, beta, displacement);
                logLikelihood -= Math.max(1.0E-30 - omega, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(1.0E-30 - alpha, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(alpha - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(1.0E-30 - beta, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(beta - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(1.0E-30 - displacementNormed, 0.0) / 1.0E-30;
                return logLikelihood -= Math.max(displacementNormed - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
            }
        }
        GARCHMaxLikelihoodFunction objectiveFunction = new GARCHMaxLikelihoodFunction();
        double guessOmega = 1.0;
        double guessAlpha = 0.2;
        double guessBeta = 0.2;
        double guessDisplacement = (this.lowerBoundDisplacement + 1.0E7) / 2.0;
        if (guess != null) {
            guessOmega = (Double)guess.get("Omega");
            guessAlpha = (Double)guess.get("Alpha");
            guessBeta = (Double)guess.get("Beta");
            guessDisplacement = (Double)guess.get("Displacement");
        }
        guessOmega = DisplacedLognormal.restrictToOpenSet(guessOmega, 0.0, Double.MAX_VALUE);
        guessAlpha = DisplacedLognormal.restrictToOpenSet(guessAlpha, 0.0, 1.0);
        guessBeta = DisplacedLognormal.restrictToOpenSet(guessBeta, 0.0, 1.0 - guessAlpha);
        guessDisplacement = DisplacedLognormal.restrictToOpenSet(guessDisplacement, this.lowerBoundDisplacement, 1.0E7);
        double guessMucorr = guessAlpha + guessBeta;
        double guessMuema = guessBeta / (guessAlpha + guessBeta);
        double[] guessParameters = new double[]{Math.log(guessOmega), -Math.log(-Math.log(guessMucorr)), -Math.log(-Math.log(guessMuema)), -Math.log(1.0 / ((guessDisplacement - this.lowerBoundDisplacement) / (1.0E7 - this.lowerBoundDisplacement)) - 1.0)};
        CMAESOptimizer optimizer2 = new CMAESOptimizer();
        double[] bestParameters = null;
        try {
            PointValuePair result = optimizer2.optimize(1000000, (MultivariateFunction)objectiveFunction, GoalType.MAXIMIZE, guessParameters);
            bestParameters = result.getPoint();
        }
        catch (MathIllegalStateException e) {
            double[] guessParameters2 = new double[]{0.0, 0.0, 0.0, 10.0};
            System.out.println("Solver failed");
            bestParameters = guessParameters2;
        }
        double omega = Math.exp(bestParameters[0]);
        double mucorr = Math.exp(-Math.exp(-bestParameters[1]));
        double muema = Math.exp(-Math.exp(-bestParameters[2]));
        double beta = mucorr * muema;
        double alpha = mucorr - beta;
        double displacementNormed = 1.0 / (1.0 + Math.exp(-bestParameters[3]));
        double displacement = (1.0E7 - this.lowerBoundDisplacement) * displacementNormed + this.lowerBoundDisplacement;
        double[] quantiles = new double[]{0.01, 0.05, 0.5};
        double[] quantileValues = this.getQuantilPredictionsForParameters(omega, alpha, beta, displacement, quantiles);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("Omega", omega);
        results.put("Alpha", alpha);
        results.put("Beta", beta);
        results.put("Displacement", displacement);
        results.put("Likelihood", this.getLogLikelihoodForParameters(omega, alpha, beta, displacement));
        results.put("Vol", Math.sqrt(this.getLastResidualForParameters(omega, alpha, beta, displacement)));
        results.put("Quantile=1%", quantileValues[0]);
        results.put("Quantile=5%", quantileValues[1]);
        results.put("Quantile=50%", quantileValues[2]);
        return results;
    }

    private static double restrictToOpenSet(double value, double lowerBond, double upperBound) {
        value = Math.max(value, lowerBond * (1.0 + Math.signum(lowerBond) * 1.0E-15) + 1.0E-15);
        value = Math.min(value, upperBound * (1.0 - Math.signum(upperBound) * 1.0E-15) - 1.0E-15);
        return value;
    }
}

