/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.timeseries.models.parametric;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.timeseries.HistoricalSimulationModel;
import net.finmath.timeseries.TimeSeries;
import net.finmath.timeseries.TimeSeriesModelParametric;
import net.finmath.timeseries.TimeSeriesView;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimplePointChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.CMAESOptimizer;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;

public class DisplacedLognormalGJRGARCH
implements TimeSeriesModelParametric,
HistoricalSimulationModel {
    private final TimeSeries timeSeries;
    private final double lowerBoundDisplacement;
    private double upperBoundDisplacement = 1.0E7;
    private final int maxIterations = 10000000;
    private final String[] parameterNames = new String[]{"omega", "alpha", "beta", "mu", "gamma", "displacement"};
    private final double[] parameterGuess = new double[]{0.1, 0.2, 0.2, 0.0, 0.0, 10.0};
    private final double[] parameterStep = new double[]{0.01, 0.1, 0.1, 0.1, 0.1, 1.0};
    private final double[] lowerBound;
    private final double[] upperBound;

    public DisplacedLognormalGJRGARCH(TimeSeries timeSeries) {
        this(timeSeries, -1.7976931348623157E308);
    }

    public DisplacedLognormalGJRGARCH(TimeSeries timeSeries, double lowerBoundDisplacement) {
        this.timeSeries = timeSeries;
        double valuesMin = Double.MAX_VALUE;
        for (double value : timeSeries.getValues()) {
            valuesMin = Math.min(value, valuesMin);
        }
        this.lowerBoundDisplacement = Math.max(-valuesMin + 1.0, lowerBoundDisplacement);
        this.lowerBound = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, this.lowerBoundDisplacement};
        this.upperBound = new double[]{Double.POSITIVE_INFINITY, 1.0, 1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, this.upperBoundDisplacement};
    }

    public DisplacedLognormalGJRGARCH(TimeSeries timeSeries, double lowerBoundDisplacement, double upperBoundDisplacement) {
        this.timeSeries = timeSeries;
        double valuesMin = Double.MAX_VALUE;
        for (double value : timeSeries.getValues()) {
            valuesMin = Math.min(value, valuesMin);
        }
        this.lowerBoundDisplacement = Math.max(-valuesMin + 1.0, lowerBoundDisplacement);
        this.upperBoundDisplacement = Math.max(this.lowerBoundDisplacement, upperBoundDisplacement);
        this.lowerBound = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, this.lowerBoundDisplacement};
        this.upperBound = new double[]{Double.POSITIVE_INFINITY, 1.0, 1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, this.upperBoundDisplacement};
    }

    public double getLogLikelihoodForParameters(double[] parameters) {
        double omega = parameters[0];
        double alpha = parameters[1];
        double beta = parameters[2];
        double mu = parameters[3];
        double gamma = parameters[4];
        double displacement = parameters[5];
        double logLikelihood = 0.0;
        double volScaling = 1.0 + Math.abs(displacement);
        double evalPrev = 0.0;
        double eval = volScaling * Math.log((this.timeSeries.getValue(1) + displacement) / (this.timeSeries.getValue(0) + displacement));
        double h = omega / (1.0 - alpha - beta);
        double m = 0.0;
        int length = this.timeSeries.getNumberOfTimePoints();
        for (int i = 1; i < length - 1; ++i) {
            double evalNext;
            m = eval;
            h = omega + (alpha + gamma * (m < mu ? 1.0 : 0.0)) * m * m + beta * h;
            double value1 = this.timeSeries.getValue(i);
            double value2 = this.timeSeries.getValue(i + 1);
            double mNext = evalNext = volScaling * Math.log((value2 + displacement) / (value1 + displacement));
            logLikelihood += -Math.log(h) - 2.0 * Math.log((value2 + displacement) / volScaling) - mNext * mNext / h;
            evalPrev = eval;
            eval = evalNext;
        }
        logLikelihood += -Math.log(Math.PI * 2) * (double)length;
        return logLikelihood *= 0.5;
    }

    public double getLastResidualForParameters(double[] parameters) {
        double omega = parameters[0];
        double alpha = parameters[1];
        double beta = parameters[2];
        double mu = parameters[3];
        double gamma = parameters[4];
        double displacement = parameters[5];
        double evalPrev = 0.0;
        double volScaling = 1.0 + Math.abs(displacement);
        double h = omega / (1.0 - alpha - beta);
        double m = 0.0;
        int length = this.timeSeries.getNumberOfTimePoints();
        for (int i = 1; i < length - 1; ++i) {
            double eval = volScaling * Math.log((this.timeSeries.getValue(i) + displacement) / (this.timeSeries.getValue(i - 1) + displacement));
            m = eval;
            h = omega + (alpha + gamma * (m < mu ? 1.0 : 0.0)) * m * m + beta * h;
            evalPrev = eval;
        }
        return h;
    }

    public double[] getSzenarios(double[] parameters) {
        double omega = parameters[0];
        double alpha = parameters[1];
        double beta = parameters[2];
        double mu = parameters[3];
        double gamma = parameters[4];
        double displacement = parameters[5];
        double[] szenarios = new double[this.timeSeries.getNumberOfTimePoints() - 1];
        double volScaling = 1.0 + Math.abs(displacement);
        double evalPrev = 0.0;
        double h = omega / (1.0 - alpha - beta);
        double m = 0.0;
        double vol = Math.sqrt(h) / volScaling;
        for (int i = 1; i <= this.timeSeries.getNumberOfTimePoints() - 1; ++i) {
            double eval;
            double y = Math.log((this.timeSeries.getValue(i) + displacement) / (this.timeSeries.getValue(i - 1) + displacement));
            m = eval = volScaling * y;
            szenarios[i - 1] = m / vol / volScaling;
            h = omega + (alpha + gamma * (m < mu ? 1.0 : 0.0)) * m * m + beta * h;
            vol = Math.sqrt(h) / volScaling;
            evalPrev = eval;
        }
        Arrays.sort(szenarios);
        return szenarios;
    }

    @Override
    public Map<String, Object> getBestParameters() {
        return this.getBestParameters(null);
    }

    @Override
    public Map<String, Object> getBestParameters(Map<String, Object> guess) {
        class GARCHMaxLikelihoodFunction
        implements MultivariateFunction,
        Serializable {
            private static final long serialVersionUID = 7072187082052755854L;

            GARCHMaxLikelihoodFunction() {
            }

            public double value(double[] parameters) {
                double omega = parameters[0];
                double alpha = parameters[1];
                double beta = parameters[2];
                double mu = parameters[3];
                double gamma = parameters[4];
                double displacement = parameters[5];
                double logLikelihood = DisplacedLognormalGJRGARCH.this.getLogLikelihoodForParameters(parameters);
                logLikelihood -= Math.max(1.0E-30 - omega, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(1.0E-30 - alpha, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(alpha - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(1.0E-30 - beta, 0.0) / 1.0E-30;
                return logLikelihood -= Math.max(beta - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
            }
        }
        final GARCHMaxLikelihoodFunction objectiveFunction = new GARCHMaxLikelihoodFunction();
        final double[] guessParameters = new double[6];
        System.arraycopy(this.parameterGuess, 0, guessParameters, 0, this.parameterGuess.length);
        if (guess != null) {
            guessParameters[0] = (Double)guess.get("Omega");
            guessParameters[1] = (Double)guess.get("Alpha");
            guessParameters[2] = (Double)guess.get("Beta");
            guessParameters[3] = (Double)guess.get("Mu");
            guessParameters[4] = (Double)guess.get("Gamme");
            guessParameters[5] = (Double)guess.get("Displacement");
        }
        LevenbergMarquardt lm = new LevenbergMarquardt(guessParameters, new double[]{1000.0}, 1000000000, 2){
            private static final long serialVersionUID = -3791313169935939272L;
            {
                super(initialParameters, targetValues, maxIteration, numberOfThreads);
            }

            @Override
            public void setValues(double[] arg0, double[] arg1) {
                arg1[0] = objectiveFunction.value(arg0);
            }
        };
        double[] bestParameters = null;
        boolean isUseLM = false;
        CMAESOptimizer optimizer2 = new CMAESOptimizer(10000000, Double.POSITIVE_INFINITY, true, 0, 0, (RandomGenerator)new MersenneTwister(), false, (ConvergenceChecker)new SimplePointChecker(0.0, 0.0)){
            {
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
            }

            public double computeObjectiveValue(double[] params) {
                return objectiveFunction.value(params);
            }

            public GoalType getGoalType() {
                return GoalType.MAXIMIZE;
            }

            public double[] getStartPoint() {
                return guessParameters;
            }

            public double[] getLowerBound() {
                return DisplacedLognormalGJRGARCH.this.lowerBound;
            }

            public double[] getUpperBound() {
                return DisplacedLognormalGJRGARCH.this.upperBound;
            }
        };
        try {
            PointValuePair result = optimizer2.optimize(new OptimizationData[]{new CMAESOptimizer.PopulationSize((int)(4.0 + 3.0 * Math.log(guessParameters.length))), new CMAESOptimizer.Sigma(this.parameterStep)});
            bestParameters = result.getPoint();
        }
        catch (MathIllegalStateException e) {
            System.out.println("Solver failed");
            bestParameters = guessParameters;
        }
        double omega = bestParameters[0];
        double alpha = bestParameters[1];
        double beta = bestParameters[2];
        double mu = bestParameters[3];
        double gamma = bestParameters[4];
        double displacement = bestParameters[5];
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("parameters", bestParameters);
        results.put("Omega", omega);
        results.put("Alpha", alpha);
        results.put("Beta", beta);
        results.put("Mu", mu);
        results.put("gamma", gamma);
        results.put("Displacement", displacement);
        results.put("Szenarios", this.getSzenarios(bestParameters));
        results.put("Likelihood", this.getLogLikelihoodForParameters(bestParameters));
        results.put("Vol", Math.sqrt(this.getLastResidualForParameters(bestParameters)));
        System.out.println(results.get("Likelihood") + "\t" + Arrays.toString(bestParameters));
        return results;
    }

    private static double restrictToOpenSet(double value, double lowerBond, double upperBound) {
        value = Math.max(value, lowerBond * (1.0 + Math.signum(lowerBond) * 1.0E-15) + 1.0E-15);
        value = Math.min(value, upperBound * (1.0 - Math.signum(upperBound) * 1.0E-15) - 1.0E-15);
        return value;
    }

    @Override
    public TimeSeriesModelParametric getCloneCalibrated(TimeSeries timeSeries) {
        return new DisplacedLognormalGJRGARCH(timeSeries);
    }

    @Override
    public HistoricalSimulationModel getCloneWithWindow(int windowIndexStart, int windowIndexEnd) {
        return new DisplacedLognormalGJRGARCH(new TimeSeriesView(this.timeSeries, windowIndexStart, windowIndexEnd));
    }

    @Override
    public double[] getParameters() {
        return (double[])this.getBestParameters().get("parameters");
    }

    @Override
    public String[] getParameterNames() {
        return this.parameterNames;
    }
}

