/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.Constants;
import net.guerlab.smart.platform.commons.entity.IOrderEntity;
import net.guerlab.smart.platform.commons.exception.UserIdInvalidException;
import net.guerlab.smart.platform.commons.exception.UserInvalidException;
import net.guerlab.smart.platform.commons.util.OrderEntityUtils;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.stream.utils.MessageUtils;
import net.guerlab.smart.platform.user.core.UserAuthConstants;
import net.guerlab.smart.platform.user.core.exception.DepartmentHasUserException;
import net.guerlab.smart.platform.user.core.exception.DepartmentIdInvalidException;
import net.guerlab.smart.platform.user.core.exception.DepartmentInvalidException;
import net.guerlab.smart.platform.user.core.exception.DepartmentNameInvalidException;
import net.guerlab.smart.platform.user.core.exception.DepartmentTypeInvalidException;
import net.guerlab.smart.platform.user.core.exception.HasSubDepartmentException;
import net.guerlab.smart.platform.user.core.exception.OnlyOneDepartmentException;
import net.guerlab.smart.platform.user.core.exception.ParentDepartmentIdInvalidException;
import net.guerlab.smart.platform.user.core.searchparams.DepartmentSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.PositionSearchParams;
import net.guerlab.smart.platform.user.core.searchparams.UserSearchParams;
import net.guerlab.smart.platform.user.service.entity.Department;
import net.guerlab.smart.platform.user.service.entity.DepartmentParents;
import net.guerlab.smart.platform.user.service.entity.DepartmentType;
import net.guerlab.smart.platform.user.service.entity.Position;
import net.guerlab.smart.platform.user.service.entity.User;
import net.guerlab.smart.platform.user.service.mapper.DepartmentMapper;
import net.guerlab.smart.platform.user.service.searchparams.DepartmentParentsSearchParams;
import net.guerlab.smart.platform.user.service.service.AfterDepartmentUpdateHandler;
import net.guerlab.smart.platform.user.service.service.DepartmentDutyDistributionService;
import net.guerlab.smart.platform.user.service.service.DepartmentParentsService;
import net.guerlab.smart.platform.user.service.service.DepartmentService;
import net.guerlab.smart.platform.user.service.service.DepartmentTypeService;
import net.guerlab.smart.platform.user.service.service.PositionService;
import net.guerlab.smart.platform.user.service.service.UserService;
import net.guerlab.smart.platform.user.stream.binders.DepartmentAddSenderChannel;
import net.guerlab.smart.platform.user.stream.binders.DepartmentUpdateSenderChannel;
import net.guerlab.spring.commons.util.SpringApplicationContextUtil;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.messaging.MessageChannel;
import org.springframework.stereotype.Service;

@Service
@EnableBinding(value={DepartmentAddSenderChannel.class, DepartmentUpdateSenderChannel.class})
public class DepartmentServiceImpl
extends BaseServiceImpl<Department, Long, DepartmentMapper>
implements DepartmentService {
    private static final Collection<DepartmentParents> EMPTY_DEPARTMENT_PARENTS = Collections.emptyList();
    private PositionService positionService;
    private UserService userService;
    private DepartmentParentsService parentsService;
    private DepartmentTypeService departmentTypeService;
    private DepartmentDutyDistributionService distributionService;
    private DepartmentAddSenderChannel departmentAddSenderChannel;
    private DepartmentUpdateSenderChannel departmentUpdateSenderChannel;

    private static Collection<Long> filterParentIds(Collection<Long> all, Collection<Long> add, Collection<Long> remove) {
        if (all == null) {
            return Collections.emptyList();
        }
        if (CollectionUtil.isNotEmpty(remove)) {
            all.removeAll(remove);
        }
        if (CollectionUtil.isNotEmpty(add)) {
            all.addAll(add);
        }
        return all;
    }

    protected void insertBefore(Department entity) {
        if (StringUtils.isBlank((CharSequence)entity.getDepartmentName())) {
            throw new DepartmentNameInvalidException();
        }
        if (!NumberHelper.greaterZero((Number)entity.getParentId())) {
            entity.setParentId(Constants.DEFAULT_PARENT_ID);
        } else {
            this.getDepartment(entity.getParentId());
        }
        if (!NumberHelper.greaterZero((Number)entity.getDirectorUserId())) {
            entity.setDirectorUserId(Constants.EMPTY_ID);
            entity.setDirectorUserName("");
        }
        if (!NumberHelper.greaterZero((Number)entity.getChargeUserId())) {
            entity.setChargeUserId(Constants.EMPTY_ID);
            entity.setChargeUserName("");
        }
        this.setDepartmentType(entity);
        entity.setDepartmentId(this.sequence.nextId());
        entity.setUpdateTime(LocalDateTime.now());
        OrderEntityUtils.propertiesCheck((IOrderEntity)entity);
    }

    private void setDepartmentType(Department entity) {
        String departmentTypeKey = StringUtils.trimToNull((String)entity.getDepartmentTypeKey());
        if (departmentTypeKey == null) {
            entity.setDepartmentTypeKey("");
            entity.setDepartmentTypeName("");
            return;
        }
        DepartmentType departmentType = (DepartmentType)((Object)this.departmentTypeService.selectById(departmentTypeKey));
        if (departmentType == null) {
            throw new DepartmentTypeInvalidException();
        }
        entity.setDepartmentTypeKey(departmentType.getDepartmentTypeKey());
        entity.setDepartmentTypeName(departmentType.getDepartmentTypeName());
    }

    protected void insertAfter(Department entity) {
        this.setParentInfo(entity);
        this.setManagerInfo(entity);
        MessageUtils.send((MessageChannel)this.departmentAddSenderChannel.output(), (Object)((Object)entity));
    }

    private void setParentInfo(Department entity) {
        Long parentId = entity.getParentId();
        if (!NumberHelper.greaterZero((Number)parentId)) {
            return;
        }
        Collection<Long> parentIds = this.parentsService.findParentIdsByDepartmentId(parentId);
        parentIds.add(parentId);
        List<DepartmentParents> parents = parentIds.stream().map(pid -> new DepartmentParents(entity.getDepartmentId(), (Long)pid)).collect(Collectors.toList());
        this.parentsService.save(parents);
    }

    private void setManagerInfo(Department entity) {
        Position position;
        if (!NumberHelper.allGreaterZero((Number[])new Number[]{entity.getDirectorUserId(), entity.getChargeUserId()})) {
            return;
        }
        Long departmentId = entity.getDepartmentId();
        ArrayList<Position> positions = new ArrayList<Position>(2);
        if (NumberHelper.greaterZero((Number)entity.getDirectorUserId())) {
            if (this.userService.selectById(entity.getDirectorUserId()) == null) {
                throw new UserInvalidException();
            }
            position = new Position(entity.getDirectorUserId(), departmentId, UserAuthConstants.POSITION_ID_DIRECTOR);
            positions.add(position);
        }
        if (NumberHelper.greaterZero((Number)entity.getChargeUserId())) {
            if (this.userService.selectById(entity.getChargeUserId()) == null) {
                throw new UserInvalidException();
            }
            position = new Position(entity.getChargeUserId(), departmentId, UserAuthConstants.POSITION_ID_CHARGE);
            positions.add(position);
        }
        this.positionService.save(positions);
    }

    protected void updateBefore(Department entity) {
        Collection<Object> adds;
        if (entity == null) {
            throw new DepartmentInvalidException();
        }
        Long departmentId = entity.getDepartmentId();
        if (!NumberHelper.greaterZero((Number)departmentId)) {
            throw new DepartmentIdInvalidException();
        }
        this.setDepartmentType(entity);
        Long parentId = entity.getParentId();
        if (parentId == null || parentId < 0L || Objects.equals(parentId, departmentId)) {
            entity.setParentId(null);
            return;
        }
        if (NumberHelper.greaterZero((Number)parentId) && this.selectById(parentId) == null) {
            throw new ParentDepartmentIdInvalidException();
        }
        Collection<Long> childrenIds = this.getChildrenIdsByDepartmentId(departmentId);
        if (childrenIds.contains(parentId)) {
            throw new ParentDepartmentIdInvalidException();
        }
        HashMap<Long, Collection<Long>> parentIdsMap = new HashMap<Long, Collection<Long>>(childrenIds.size() + 1);
        boolean topNode = Objects.equals(Constants.DEFAULT_PARENT_ID, parentId);
        Collection<Object> collection = adds = topNode ? new ArrayList() : this.parentsService.findParentIdsByDepartmentId(parentId);
        if (NumberHelper.greaterZero((Number)parentId)) {
            adds.add(parentId);
        }
        if (!childrenIds.isEmpty()) {
            Map<Long, List<Long>> parentsMap = this.findParentsMapByChildrenIds(childrenIds);
            Collection<Long> remove = this.parentsService.findParentIdsByDepartmentId(departmentId);
            parentsMap.forEach((childrenDepartmentId, childrenParentIds) -> parentIdsMap.put((Long)childrenDepartmentId, DepartmentServiceImpl.filterParentIds(childrenParentIds, adds, remove)));
        }
        parentIdsMap.put(departmentId, adds);
        this.batchSaveParents(parentIdsMap);
        entity.setUpdateTime(LocalDateTime.now());
    }

    private Collection<Long> getChildrenIdsByDepartmentId(Long departmentId) {
        Collection<Long> children = this.parentsService.findDepartmentIdsByParentId(departmentId);
        return CollectionUtil.isEmpty(children) ? Collections.emptyList() : children;
    }

    private Map<Long, List<Long>> findParentsMapByChildrenIds(Collection<Long> childrenIds) {
        DepartmentParentsSearchParams searchParams = new DepartmentParentsSearchParams();
        searchParams.setDepartmentIds(childrenIds);
        Map map = CollectionUtil.group(this.parentsService.findList(searchParams), DepartmentParents::getDepartmentId);
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(map.size());
        map.forEach((key, value) -> result.put((Long)key, CollectionUtil.toList((Collection)value, DepartmentParents::getParentId)));
        return result;
    }

    private void batchSaveParents(Map<Long, Collection<Long>> parentIdsMap) {
        DepartmentParentsSearchParams deleteSearchParams = new DepartmentParentsSearchParams();
        deleteSearchParams.setDepartmentIds(parentIdsMap.keySet());
        this.parentsService.delete(deleteSearchParams);
        List<DepartmentParents> saves = parentIdsMap.entrySet().stream().map(entry -> {
            if (entry.getValue() == null) {
                return EMPTY_DEPARTMENT_PARENTS;
            }
            Long departmentId = (Long)entry.getKey();
            return ((Collection)entry.getValue()).stream().map(parentId -> new DepartmentParents(departmentId, (Long)parentId)).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
        if (!saves.isEmpty()) {
            this.parentsService.save(saves);
        }
    }

    protected void updateAfter(Department entity) {
        SpringApplicationContextUtil.getContext().getBeansOfType(AfterDepartmentUpdateHandler.class).values().forEach(handler -> handler.afterDepartmentUpdateHandler(entity));
        MessageUtils.send((MessageChannel)this.departmentUpdateSenderChannel.output(), (Object)((Object)entity));
    }

    public void delete(Department entity, Boolean force) {
        if (entity == null) {
            throw new DepartmentInvalidException();
        }
        this.deleteById(entity.getDepartmentId(), force);
    }

    protected void deleteByIdBefore(Long id, Boolean force) {
        if (!NumberHelper.greaterZero((Number)id)) {
            throw new DepartmentIdInvalidException();
        }
        UserSearchParams userSearchParams = new UserSearchParams();
        userSearchParams.setDepartmentId(id);
        if (this.userService.selectCount((AbstractSearchParams)userSearchParams) != 0) {
            throw new DepartmentHasUserException();
        }
        DepartmentSearchParams departmentSearchParams = new DepartmentSearchParams();
        departmentSearchParams.setParentId(id);
        if (this.selectCount((AbstractSearchParams)departmentSearchParams) != 0) {
            throw new HasSubDepartmentException();
        }
        if (this.selectCount((AbstractSearchParams)((DepartmentSearchParams)null)) <= 1) {
            throw new OnlyOneDepartmentException();
        }
    }

    protected void deleteAfter(Department entity, Boolean force) {
        super.deleteByIdAfter((Object)entity.getDepartmentId(), force);
    }

    protected void deleteByIdAfter(Long id, Boolean force) {
        PositionSearchParams positionSearchParams = new PositionSearchParams();
        positionSearchParams.setDepartmentId(id);
        this.positionService.delete(positionSearchParams);
        this.distributionService.deleteByDepartmentId(id);
        DepartmentParentsSearchParams departmentParentsSearchParams = new DepartmentParentsSearchParams();
        departmentParentsSearchParams.setDepartmentId(id);
        this.parentsService.delete(departmentParentsSearchParams);
    }

    @Override
    public void setDirectorUser(Long departmentId, Long userId) {
        Department department = this.getDepartment(departmentId);
        User user = this.setManager(department, userId, UserAuthConstants.POSITION_ID_DIRECTOR);
        department.setDirectorUserId(userId);
        department.setDirectorUserName(user.getName());
        ((DepartmentMapper)this.mapper).updateByPrimaryKey((Object)department);
    }

    @Override
    public void setChargeUser(Long departmentId, Long userId) {
        Department department = this.getDepartment(departmentId);
        User user = this.setManager(department, userId, UserAuthConstants.POSITION_ID_CHARGE);
        department.setChargeUserId(userId);
        department.setChargeUserName(user.getName());
        ((DepartmentMapper)this.mapper).updateByPrimaryKey((Object)department);
    }

    private Department getDepartment(Long departmentId) {
        if (!NumberHelper.greaterZero((Number)departmentId)) {
            throw new DepartmentIdInvalidException();
        }
        return (Department)((Object)this.selectByIdOptional(departmentId).orElseThrow(DepartmentInvalidException::new));
    }

    private User getUser(Long userId) {
        if (!NumberHelper.greaterZero((Number)userId)) {
            throw new UserIdInvalidException();
        }
        return (User)((Object)this.userService.selectByIdOptional(userId).orElseThrow(UserInvalidException::new));
    }

    private User setManager(Department department, Long userId, Long dutyId) {
        User user = this.getUser(userId);
        PositionSearchParams searchParams = new PositionSearchParams();
        searchParams.setDepartmentId(department.getDepartmentId());
        searchParams.setDutyId(dutyId);
        this.positionService.delete(searchParams);
        Position position = new Position();
        position.setDepartmentId(department.getDepartmentId());
        position.setDutyId(dutyId);
        position.setUserId(userId);
        this.positionService.save(position);
        return user;
    }

    @Override
    public void removeDirectorUser(Long departmentId) {
        this.removeManager(departmentId, UserAuthConstants.POSITION_ID_DIRECTOR);
        DepartmentSearchParams searchParams = new DepartmentSearchParams();
        searchParams.setDepartmentId(departmentId);
        Department department = new Department();
        department.setDirectorUserId(Constants.EMPTY_ID);
        department.setDirectorUserName("");
        ((DepartmentMapper)this.mapper).updateByExampleSelective((Object)department, this.getExample((AbstractSearchParams)searchParams));
    }

    @Override
    public void removeChargeUser(Long departmentId) {
        this.removeManager(departmentId, UserAuthConstants.POSITION_ID_CHARGE);
        DepartmentSearchParams searchParams = new DepartmentSearchParams();
        searchParams.setDepartmentId(departmentId);
        Department department = new Department();
        department.setChargeUserId(Constants.EMPTY_ID);
        department.setChargeUserName("");
        ((DepartmentMapper)this.mapper).updateByExampleSelective((Object)department, this.getExample((AbstractSearchParams)searchParams));
    }

    private void removeManager(Long departmentId, Long dutyId) {
        PositionSearchParams searchParams = new PositionSearchParams();
        searchParams.setDepartmentId(departmentId);
        searchParams.setDutyId(dutyId);
        this.positionService.delete(searchParams);
    }

    @Override
    public void updateByDepartmentType(DepartmentType departmentType) {
        if (departmentType == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{departmentType.getDepartmentTypeKey(), departmentType.getDepartmentTypeName()})) {
            return;
        }
        DepartmentSearchParams searchParams = new DepartmentSearchParams();
        searchParams.setDepartmentTypeKey(departmentType.getDepartmentTypeKey());
        Department update = new Department();
        update.setDepartmentTypeName(departmentType.getDepartmentTypeName());
        ((DepartmentMapper)this.mapper).updateByExampleSelective((Object)update, this.getExample((AbstractSearchParams)searchParams));
    }

    @Autowired
    public void setPositionService(PositionService positionService) {
        this.positionService = positionService;
    }

    @Autowired
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Autowired
    public void setParentsService(DepartmentParentsService parentsService) {
        this.parentsService = parentsService;
    }

    @Autowired
    public void setDepartmentTypeService(DepartmentTypeService departmentTypeService) {
        this.departmentTypeService = departmentTypeService;
    }

    @Autowired
    public void setDistributionService(DepartmentDutyDistributionService distributionService) {
        this.distributionService = distributionService;
    }

    @Autowired
    public void setDepartmentAddSenderChannel(DepartmentAddSenderChannel departmentAddSenderChannel) {
        this.departmentAddSenderChannel = departmentAddSenderChannel;
    }

    @Autowired
    public void setDepartmentUpdateSenderChannel(DepartmentUpdateSenderChannel departmentUpdateSenderChannel) {
        this.departmentUpdateSenderChannel = departmentUpdateSenderChannel;
    }
}

