/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import net.guerlab.smart.platform.commons.entity.IOrderEntity;
import net.guerlab.smart.platform.commons.util.OrderEntityUtils;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.user.core.exception.DepartmentTypeKeyInvalidException;
import net.guerlab.smart.platform.user.core.exception.DepartmentTypeKeyRepeatException;
import net.guerlab.smart.platform.user.core.exception.DepartmentTypeNameInvalidException;
import net.guerlab.smart.platform.user.core.exception.DepartmentTypeNameRepeatException;
import net.guerlab.smart.platform.user.service.entity.DepartmentType;
import net.guerlab.smart.platform.user.service.mapper.DepartmentTypeMapper;
import net.guerlab.smart.platform.user.service.service.DepartmentService;
import net.guerlab.smart.platform.user.service.service.DepartmentTypeService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DepartmentTypeServiceImpl
extends BaseServiceImpl<DepartmentType, String, DepartmentTypeMapper>
implements DepartmentTypeService {
    private DepartmentService departmentService;

    protected void insertBefore(DepartmentType entity) {
        String departmentTypeKey = StringUtils.trimToNull((String)entity.getDepartmentTypeKey());
        String departmentTypeName = StringUtils.trimToNull((String)entity.getDepartmentTypeName());
        if (departmentTypeKey == null) {
            throw new DepartmentTypeKeyInvalidException();
        }
        if (departmentTypeName == null) {
            throw new DepartmentTypeNameInvalidException();
        }
        if (this.selectById(departmentTypeKey) != null) {
            throw new DepartmentTypeKeyRepeatException();
        }
        if (this.selectByDepartmentTypeName(departmentTypeName) != null) {
            throw new DepartmentTypeNameRepeatException();
        }
        OrderEntityUtils.propertiesCheck((IOrderEntity)entity);
    }

    protected void updateAfter(DepartmentType entity) {
        this.departmentService.updateByDepartmentType(entity);
    }

    @Autowired
    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }
}

