/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import java.time.LocalDateTime;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.entity.IOrderEntity;
import net.guerlab.smart.platform.commons.util.OrderEntityUtils;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.user.core.UserAuthConstants;
import net.guerlab.smart.platform.user.core.exception.DutyIdInvalidException;
import net.guerlab.smart.platform.user.core.exception.DutyInvalidException;
import net.guerlab.smart.platform.user.core.exception.DutyNameInvalidException;
import net.guerlab.smart.platform.user.core.exception.SystemDutyCannotOperationException;
import net.guerlab.smart.platform.user.core.searchparams.PositionSearchParams;
import net.guerlab.smart.platform.user.service.entity.Duty;
import net.guerlab.smart.platform.user.service.mapper.DutyMapper;
import net.guerlab.smart.platform.user.service.service.DepartmentDutyDistributionService;
import net.guerlab.smart.platform.user.service.service.DutyService;
import net.guerlab.smart.platform.user.service.service.PositionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DutyServiceImpl
extends BaseServiceImpl<Duty, Long, DutyMapper>
implements DutyService {
    private PositionService positionService;
    private DepartmentDutyDistributionService distributionService;

    protected void insertBefore(Duty entity) {
        String dutyName = StringUtils.trimToNull((String)entity.getDutyName());
        if (dutyName == null) {
            throw new DutyNameInvalidException();
        }
        entity.setDutyId(this.sequence.nextId());
        entity.setDutyName(dutyName);
        entity.setUpdateTime(LocalDateTime.now());
        OrderEntityUtils.propertiesCheck((IOrderEntity)entity);
    }

    protected void updateBefore(Duty entity) {
        this.systemDutyCheck(entity);
        entity.setUpdateTime(LocalDateTime.now());
    }

    protected void deleteBefore(Duty entity, Boolean force) {
        this.systemDutyCheck(entity);
    }

    protected void deleteByIdBefore(Long dutyId, Boolean force) {
        this.idCheck(dutyId);
    }

    protected void deleteAfter(Duty entity, Boolean force) {
        this.deleteByIdAfter(entity.getDutyId(), force);
    }

    protected void deleteByIdAfter(Long dutyId, Boolean force) {
        if (!NumberHelper.greaterZero((Number)dutyId)) {
            throw new DutyIdInvalidException();
        }
        PositionSearchParams searchParams = new PositionSearchParams();
        searchParams.setDutyId(dutyId);
        this.positionService.delete(searchParams);
        this.distributionService.deleteByDutyId(dutyId);
    }

    private void systemDutyCheck(Duty entity) {
        if (entity == null) {
            throw new DutyInvalidException();
        }
        this.idCheck(entity.getDutyId());
    }

    private void idCheck(Long dutyId) {
        if (!NumberHelper.greaterZero((Number)dutyId)) {
            throw new DutyIdInvalidException();
        }
        if (dutyId < UserAuthConstants.SYSTEM_POSITION_ID_RANGE) {
            throw new SystemDutyCannotOperationException();
        }
    }

    @Autowired
    public void setPositionService(PositionService positionService) {
        this.positionService = positionService;
    }

    @Autowired
    public void setDistributionService(DepartmentDutyDistributionService distributionService) {
        this.distributionService = distributionService;
    }
}

