/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.platform.user.service.service.impl;

import java.util.Optional;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.platform.commons.Constants;
import net.guerlab.smart.platform.commons.entity.IOrderEntity;
import net.guerlab.smart.platform.commons.util.OrderEntityUtils;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.user.core.exception.MenuNameInvalidException;
import net.guerlab.smart.platform.user.core.exception.MenuPathInvalidException;
import net.guerlab.smart.platform.user.core.searchparams.MenuPermissionSearchParams;
import net.guerlab.smart.platform.user.service.entity.Menu;
import net.guerlab.smart.platform.user.service.mapper.MenuMapper;
import net.guerlab.smart.platform.user.service.service.MenuPermissionService;
import net.guerlab.smart.platform.user.service.service.MenuService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuServiceImpl
extends BaseServiceImpl<Menu, Long, MenuMapper>
implements MenuService {
    private MenuPermissionService menuPermissionService;

    protected void insertBefore(Menu entity) {
        String name = StringUtils.trimToNull((String)entity.getName());
        String path = StringUtils.trimToNull((String)entity.getPath());
        String componentPath = StringUtils.trimToNull((String)entity.getComponentPath());
        if (name == null) {
            throw new MenuNameInvalidException();
        }
        if (path == null) {
            throw new MenuPathInvalidException();
        }
        entity.setMenuId(this.sequence.nextId());
        entity.setName(name);
        entity.setPath(path);
        entity.setDomain(StringUtils.trimToEmpty((String)entity.getDomain()));
        entity.setModule(StringUtils.trimToEmpty((String)entity.getModule()));
        entity.setComponentPath(Optional.ofNullable(componentPath).orElse("Root"));
        if (!NumberHelper.greaterZero((Number)entity.getParentId())) {
            entity.setParentId(Constants.DEFAULT_PARENT_ID);
        }
        if (entity.getHidden() == null) {
            entity.setHidden(false);
        }
        if (entity.getLeaf() == null) {
            entity.setLeaf(false);
        }
        OrderEntityUtils.propertiesCheck((IOrderEntity)entity);
    }

    protected void deleteByIdAfter(Long menuId, Boolean force) {
        this.clearMenuPermission(menuId);
    }

    private void clearMenuPermission(Long menuId) {
        if (!NumberHelper.greaterZero((Number)menuId)) {
            return;
        }
        MenuPermissionSearchParams searchParams = new MenuPermissionSearchParams();
        searchParams.setMenuId(menuId);
        this.menuPermissionService.delete(searchParams);
    }

    @Autowired
    public void setMenuPermissionService(MenuPermissionService menuPermissionService) {
        this.menuPermissionService = menuPermissionService;
    }
}

