/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class Json {
    private Json() {
    }

    public static JString jString(String value) {
        return new JString(value);
    }

    public static JBoolean jBoolean(boolean value) {
        return new JBoolean(value);
    }

    public static JNumber jNumber(BigDecimal value) {
        return new JNumber(value);
    }

    public static JNumber jNumber(int n) {
        return new JNumber(new BigDecimal(n));
    }

    public static JNumber jNumber(double n) {
        return new JNumber(new BigDecimal(n));
    }

    public static JNumber jNumber(long n) {
        return new JNumber(new BigDecimal(n));
    }

    public static JNumber jNumber(Number n) {
        if (n instanceof BigDecimal) {
            return new JNumber((BigDecimal)n);
        }
        return new JNumber(new BigDecimal(n.toString()));
    }

    public static JNull jNull() {
        return JNull.INSTANCE;
    }

    public static JArray jEmptyArray() {
        return new JArray(Collections.emptyList());
    }

    public static JArray jArray(Iterable<JValue> iterable) {
        List list = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
        return new JArray(list);
    }

    public static JArray jArray(JValue first, JValue ... rest) {
        ArrayList<JValue> list = new ArrayList<JValue>(Arrays.asList(rest));
        list.add(0, first);
        return new JArray(list);
    }

    public static JObject jEmptyObject() {
        return new JObject(Collections.emptyMap());
    }

    public static JObject jObject(String name, JValue value) {
        return new JObject(Collections.singletonMap(name, value));
    }

    @SafeVarargs
    public static JObject jObject(Map.Entry<String, JValue> first, Map.Entry<String, JValue> ... list) {
        LinkedHashMap<String, JValue> map = new LinkedHashMap<String, JValue>(list.length + 1);
        map.put(first.getKey(), first.getValue());
        for (Map.Entry<String, JValue> entry : list) {
            map.put(entry.getKey(), entry.getValue());
        }
        return new JObject(map);
    }

    public static JObject jObject(Iterable<Map.Entry<String, JValue>> value) {
        LinkedHashMap<String, JValue> map = new LinkedHashMap<String, JValue>();
        for (Map.Entry<String, JValue> e : value) {
            map.put(e.getKey(), e.getValue());
        }
        return new JObject(map);
    }

    public static JObject jObject(Map<String, JValue> value) {
        LinkedHashMap<String, JValue> map = new LinkedHashMap<String, JValue>(value);
        return new JObject(map);
    }

    public static Map.Entry<String, JValue> entry(String name, JValue value) {
        return new AbstractMap.SimpleImmutableEntry<String, JValue>(name, value);
    }

    private static <A, B> Function<A, Optional<B>> emptyOption() {
        return ignore -> Optional.empty();
    }

    public static final class JObject
    extends JValue
    implements Iterable<Map.Entry<String, JValue>> {
        public Map<String, JValue> value;

        private JObject(Map<String, JValue> value) {
            this.value = Collections.unmodifiableMap(value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JObject jObject = (JObject)o;
            return this.value.equals(jObject.value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "JObject{value=" + this.value + '}';
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fObject.apply(this);
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fObject.accept(this);
        }

        public Map<String, JValue> getValue() {
            return this.value;
        }

        public Optional<JValue> get(String name) {
            return Optional.ofNullable(this.value.get(name));
        }

        public <A> Optional<A> getAs(String name, Function<JValue, Optional<A>> f) {
            return this.get(name).flatMap(f);
        }

        public Optional<String> getAsString(String name) {
            return this.getAs(name, JValue::asString);
        }

        public Optional<JNumber> getAsNumber(String name) {
            return this.getAs(name, JValue::asJsonNumber);
        }

        public Optional<BigDecimal> getAsBigDecimal(String name) {
            return this.getAsNumber(name).map(JNumber::getValue);
        }

        public Optional<Integer> getAsInteger(String name) {
            return this.getAsNumber(name).map(JNumber::asInt);
        }

        public Optional<Double> getAsDouble(String name) {
            return this.getAsNumber(name).map(JNumber::asDouble);
        }

        public Optional<Long> getAsLong(String name) {
            return this.getAsNumber(name).map(JNumber::asLong);
        }

        public Optional<Boolean> getAsBoolean(String name) {
            return this.getAs(name, JValue::asBoolean);
        }

        public Optional<JArray> getAsArray(String name) {
            return this.getAs(name, JValue::asJsonArray);
        }

        public JArray getAsArrayOrEmpty(String name) {
            return this.getAsArray(name).orElse(Json.jEmptyArray());
        }

        public Optional<JObject> getAsObject(String name) {
            return this.getAs(name, JValue::asJsonObject);
        }

        public JObject getAsObjectOrEmpty(String name) {
            return this.getAsObject(name).orElse(Json.jEmptyObject());
        }

        public boolean isEmpty() {
            return this.value.isEmpty();
        }

        public boolean containsKey(String key) {
            return this.value.containsKey(key);
        }

        public boolean containsValue(JValue value) {
            return this.value.containsValue(value);
        }

        public Collection<JValue> values() {
            return this.value.values();
        }

        public Set<Map.Entry<String, JValue>> entrySet() {
            return this.value.entrySet();
        }

        public void forEach(BiConsumer<String, JValue> action) {
            this.value.forEach(action);
        }

        public <B> List<B> mapToList(BiFunction<String, JValue, B> f) {
            return this.entrySet().stream().map(e -> f.apply((String)e.getKey(), (JValue)e.getValue())).collect(Collectors.toList());
        }

        public <B> List<B> mapValues(Function<JValue, B> f) {
            return this.values().stream().map(f).collect(Collectors.toList());
        }

        public JValue getOrDefault(String key, JValue defaultValue) {
            return this.value.getOrDefault(key, defaultValue);
        }

        public int size() {
            return this.value.size();
        }

        public Set<String> keySet() {
            return this.value.keySet();
        }

        @Override
        public Iterator<Map.Entry<String, JValue>> iterator() {
            return this.entrySet().iterator();
        }

        public Stream<Map.Entry<String, JValue>> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        public JObject put(String name, JValue value) {
            LinkedHashMap<String, JValue> map = new LinkedHashMap<String, JValue>(this.value);
            map.put(name, Objects.requireNonNull(value, "You may not use a null value"));
            return new JObject(map);
        }

        public JObject put(String name, String value) {
            return this.put(name, Json.jString(value));
        }

        public JObject put(String name, BigDecimal value) {
            return this.put(name, Json.jNumber(value));
        }

        public JObject put(String name, Number value) {
            return this.put(name, Json.jNumber(value));
        }

        public JObject put(String name, int value) {
            return this.put(name, Json.jNumber(value));
        }

        public JObject put(String name, long value) {
            return this.put(name, Json.jNumber(value));
        }

        public JObject put(String name, double value) {
            return this.put(name, Json.jNumber(value));
        }

        public JObject put(String name, boolean value) {
            return this.put(name, Json.jBoolean(value));
        }

        public JObject remove(String name) {
            LinkedHashMap<String, JValue> map;
            if (this.containsKey(name) && (map = new LinkedHashMap<String, JValue>(this.value)).remove(name) != null) {
                return new JObject(map);
            }
            return this;
        }
    }

    public static final class JArray
    extends JValue
    implements Iterable<JValue> {
        public List<JValue> value;

        private JArray(List<JValue> value) {
            this.value = Collections.unmodifiableList(value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JArray jArray = (JArray)o;
            return this.value.equals(jArray.value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "JArray{value=" + this.value + '}';
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fArray.apply(this);
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fArray.accept(this);
        }

        public List<JValue> getValue() {
            return this.value;
        }

        @Override
        public Iterator<JValue> iterator() {
            return this.value.iterator();
        }

        public Stream<JValue> stream() {
            return StreamSupport.stream(this.value.spliterator(), false);
        }

        public Optional<JValue> get(int index) {
            return index < this.value.size() ? Optional.of(this.value.get(index)) : Optional.empty();
        }

        public Optional<JValue> headOption() {
            return this.value.stream().findFirst();
        }

        public List<JObject> getListAsObjects() {
            return this.mapOpt(JValue::asJsonObject);
        }

        public List<String> getListAsStrings() {
            return this.mapOpt(JValue::asString);
        }

        public List<BigDecimal> getListAsBigDecimals() {
            return this.mapOpt(JValue::asBigDecimal);
        }

        public <A> List<A> mapOpt(Function<JValue, Optional<A>> f) {
            Function<JValue, Stream<A>> f2 = f.andThen(opt -> opt.isPresent() ? Stream.of(opt.get()) : Stream.empty());
            return this.mapStream(f2);
        }

        public <A> List<A> mapToList(Function<JValue, A> f) {
            return this.value.stream().map(f).collect(Collectors.toList());
        }

        public JArray map(Function<JValue, JValue> f) {
            return new JArray(this.mapToList(f));
        }

        public JArray flatMap(Function<JValue, JArray> f) {
            Function f2 = f.andThen(JArray::getValue);
            return new JArray(this.flatMapToList(f2));
        }

        public <A> List<A> flatMapToList(Function<JValue, List<A>> f) {
            return this.mapStream(f.andThen(Collection::stream));
        }

        public <A> List<A> mapStream(Function<JValue, Stream<A>> f) {
            return this.value.stream().flatMap(f).collect(Collectors.toList());
        }

        public int size() {
            return this.value.size();
        }

        public JArray append(JValue toAdd) {
            ArrayList<JValue> values = new ArrayList<JValue>(this.value);
            values.add(toAdd);
            return new JArray(values);
        }

        public JArray append(String toAdd) {
            return this.append(Json.jString(toAdd));
        }

        public JArray append(BigDecimal toAdd) {
            return this.append(Json.jNumber(toAdd));
        }

        public JArray append(Number toAdd) {
            return this.append(Json.jNumber(toAdd));
        }

        public JArray append(int toAdd) {
            return this.append(Json.jNumber(toAdd));
        }

        public JArray append(long toAdd) {
            return this.append(Json.jNumber(toAdd));
        }

        public JArray append(double toAdd) {
            return this.append(Json.jNumber(toAdd));
        }

        public JArray append(boolean toAdd) {
            return this.append(Json.jBoolean(toAdd));
        }

        public JArray insert(int index, JValue toAdd) {
            ArrayList<JValue> values = new ArrayList<JValue>(this.value);
            values.add(index, toAdd);
            return new JArray(values);
        }

        public JArray replace(int index, JValue toAdd) {
            ArrayList<JValue> values = new ArrayList<JValue>(this.value);
            values.set(index, toAdd);
            return new JArray(values);
        }

        public JArray remove(int index) {
            ArrayList<JValue> values = new ArrayList<JValue>(this.value);
            values.remove(index);
            return new JArray(values);
        }
    }

    public static final class JNumber
    extends JValue {
        public BigDecimal value;

        private JNumber(BigDecimal value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JNumber jNumber = (JNumber)o;
            return this.value.equals(jNumber.value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "JNumber{value=" + this.value + '}';
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fNumber.apply(this);
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fNumber.accept(this);
        }

        public long asLong() {
            return this.value.longValue();
        }

        public int asInt() {
            return this.value.intValue();
        }

        public double asDouble() {
            return this.value.doubleValue();
        }

        public BigDecimal getValue() {
            return this.value;
        }
    }

    public static final class JNull
    extends JValue {
        public static final JNull INSTANCE = new JNull();

        private JNull() {
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return 31;
        }

        @Override
        public String toString() {
            return "JNull";
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fNull.get();
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fNull.run();
        }
    }

    public static final class JBoolean
    extends JValue {
        public final boolean value;

        private JBoolean(boolean value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JBoolean jBoolean = (JBoolean)o;
            return this.value == jBoolean.value;
        }

        @Override
        public int hashCode() {
            return this.value ? 1 : 0;
        }

        @Override
        public String toString() {
            return "JBoolean{value=" + this.value + '}';
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fBoolean.apply(this);
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fBoolean.accept(this);
        }

        public boolean isValue() {
            return this.value;
        }
    }

    public static final class JString
    extends JValue {
        public final String value;

        private JString(String value) {
            this.value = value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JString jString = (JString)o;
            return this.value.equals(jString.value);
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return "JString{value='" + this.value + '\'' + '}';
        }

        @Override
        public <X> X fold(Function<JString, X> fString, Function<JBoolean, X> fBoolean, Function<JNumber, X> fNumber, Function<JObject, X> fObject, Function<JArray, X> fArray, Supplier<X> fNull) {
            return fString.apply(this);
        }

        @Override
        public void foldUnit(Consumer<JString> fString, Consumer<JBoolean> fBoolean, Consumer<JNumber> fNumber, Consumer<JObject> fObject, Consumer<JArray> fArray, Runnable fNull) {
            fString.accept(this);
        }

        public String getValue() {
            return this.value;
        }
    }

    public static abstract class JValue
    implements Serializable {
        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        public abstract String toString();

        public abstract <X> X fold(Function<JString, X> var1, Function<JBoolean, X> var2, Function<JNumber, X> var3, Function<JObject, X> var4, Function<JArray, X> var5, Supplier<X> var6);

        public abstract void foldUnit(Consumer<JString> var1, Consumer<JBoolean> var2, Consumer<JNumber> var3, Consumer<JObject> var4, Consumer<JArray> var5, Runnable var6);

        public final Optional<JArray> asJsonArray() {
            return this.fold(Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Optional::of, Optional::empty);
        }

        public final JArray asJsonArrayOrEmpty() {
            return this.asJsonArray().orElse(Json.jEmptyArray());
        }

        public final Optional<JObject> asJsonObject() {
            return this.fold(Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Optional::of, Json.emptyOption(), Optional::empty);
        }

        public final JObject asJsonObjectOrEmpty() {
            return this.asJsonObject().orElse(Json.jEmptyObject());
        }

        public final Optional<JBoolean> asJsonBoolean() {
            return this.fold(Json.emptyOption(), Optional::of, Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Optional::empty);
        }

        public final Optional<Boolean> asBoolean() {
            return this.asJsonBoolean().map(j -> j.value);
        }

        public final Optional<JNull> asJsonNull() {
            return this.fold(Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), () -> Optional.of(Json.jNull()));
        }

        public final Optional<JString> asJsonString() {
            return this.fold(Optional::of, Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Json.emptyOption(), Optional::empty);
        }

        public final Optional<String> asString() {
            return this.asJsonString().map(j -> j.value);
        }

        public final Optional<JNumber> asJsonNumber() {
            return this.fold(Json.emptyOption(), Json.emptyOption(), Optional::of, Json.emptyOption(), Json.emptyOption(), Optional::empty);
        }

        public final Optional<BigDecimal> asBigDecimal() {
            return this.asJsonNumber().map(j -> j.value);
        }
    }
}

