/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javaslang.Function1;
import javaslang.Function10;
import javaslang.Function11;
import javaslang.Function12;
import javaslang.Function13;
import javaslang.Function14;
import javaslang.Function15;
import javaslang.Function16;
import javaslang.Function17;
import javaslang.Function18;
import javaslang.Function19;
import javaslang.Function2;
import javaslang.Function20;
import javaslang.Function21;
import javaslang.Function22;
import javaslang.Function3;
import javaslang.Function4;
import javaslang.Function5;
import javaslang.Function6;
import javaslang.Function7;
import javaslang.Function8;
import javaslang.Function9;
import javaslang.Tuple1;
import javaslang.Tuple10;
import javaslang.Tuple11;
import javaslang.Tuple12;
import javaslang.Tuple13;
import javaslang.Tuple14;
import javaslang.Tuple15;
import javaslang.Tuple16;
import javaslang.Tuple17;
import javaslang.Tuple18;
import javaslang.Tuple19;
import javaslang.Tuple2;
import javaslang.Tuple20;
import javaslang.Tuple21;
import javaslang.Tuple22;
import javaslang.Tuple3;
import javaslang.Tuple4;
import javaslang.Tuple5;
import javaslang.Tuple6;
import javaslang.Tuple7;
import javaslang.Tuple8;
import javaslang.Tuple9;
import net.hamnaberg.json.Iso;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.JsonCodec;

public class Codecs {
    public static final JsonCodec<String> StringCodec = new JsonCodec<String>(){

        @Override
        public Optional<Json.JValue> toJson(String value) {
            return Optional.of(Json.jString((String)value));
        }

        @Override
        public Optional<String> fromJson(Json.JValue value) {
            return value.asString();
        }
    };
    public static final JsonCodec<Number> numberCodec = new JsonCodec<Number>(){

        @Override
        public Optional<Json.JValue> toJson(Number value) {
            return Optional.of(Json.jNumber((Number)value));
        }

        @Override
        public Optional<Number> fromJson(Json.JValue value) {
            return value.asBigDecimal().map(v -> v);
        }
    };
    public static final JsonCodec<Long> longCodec = new JsonCodec<Long>(){

        @Override
        public Optional<Json.JValue> toJson(Long value) {
            return Optional.of(Json.jNumber((Number)value));
        }

        @Override
        public Optional<Long> fromJson(Json.JValue value) {
            return value.asJsonNumber().map(Json.JNumber::asLong);
        }
    };
    public static final JsonCodec<Double> doubleCodec = new JsonCodec<Double>(){

        @Override
        public Optional<Json.JValue> toJson(Double value) {
            return Optional.of(Json.jNumber((Number)value));
        }

        @Override
        public Optional<Double> fromJson(Json.JValue value) {
            return value.asJsonNumber().map(Json.JNumber::asDouble);
        }
    };
    public static final JsonCodec<Integer> intCodec = new JsonCodec<Integer>(){

        @Override
        public Optional<Json.JValue> toJson(Integer value) {
            return Optional.of(Json.jNumber((Number)value));
        }

        @Override
        public Optional<Integer> fromJson(Json.JValue value) {
            return value.asJsonNumber().map(Json.JNumber::asInt);
        }
    };
    public static final JsonCodec<Boolean> booleanCodec = new JsonCodec<Boolean>(){

        @Override
        public Optional<Json.JValue> toJson(Boolean value) {
            return Optional.of(Json.jBoolean((boolean)value));
        }

        @Override
        public Optional<Boolean> fromJson(Json.JValue value) {
            return value.asBoolean();
        }
    };

    public static <A> JsonCodec<A> nullCodec() {
        return new JsonCodec<A>(){

            @Override
            public Optional<Json.JValue> toJson(A value) {
                return Optional.of(Json.jNull());
            }

            @Override
            public Optional<A> fromJson(Json.JValue value) {
                return Optional.empty();
            }
        };
    }

    public static <A> JsonCodec<List<A>> listCodec(final JsonCodec<A> codec) {
        return new JsonCodec<List<A>>(){

            @Override
            public Optional<List<A>> fromJson(Json.JValue value) {
                return value.asJsonArray().map(j -> j.mapOpt(codec::fromJson));
            }

            @Override
            public Optional<Json.JValue> toJson(List<A> value) {
                return Optional.of(Json.jArray((Iterable)value.stream().flatMap(a -> {
                    Optional<Json.JValue> jv = codec.toJson(a);
                    return jv.isPresent() ? Stream.of(jv.get()) : Stream.empty();
                }).collect(Collectors.toList())));
            }
        };
    }

    public static <A> JsonCodec<Optional<A>> optionalCodec(final JsonCodec<A> codec) {
        return new JsonCodec<Optional<A>>(){

            @Override
            public Optional<Optional<A>> fromJson(Json.JValue value) {
                return Optional.of(codec.fromJson(value));
            }

            @Override
            public Optional<Json.JValue> toJson(Optional<A> value) {
                return value.flatMap(v -> codec.toJson(v));
            }
        };
    }

    public static <TT, A> Function1<String, JsonCodec<TT>> codec1(final Iso<TT, Tuple1<A>> iso, final JsonCodec<A> c1) {
        return (Function1 & Serializable)n1 -> new JsonCodec<TT>((String)n1){
            final /* synthetic */ String val$n1;
            {
                this.val$n1 = string;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple1 tuple = (Tuple1)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[0])));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                return oa.flatMap(a -> Optional.of(iso.reverseGet(new Tuple1(a))));
            }
        };
    }

    public static <TT, A, B> Function2<String, String, JsonCodec<TT>> codec2(final Iso<TT, Tuple2<A, B>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2) {
        return (Function2 & Serializable)(n1, n2) -> new JsonCodec<TT>((String)n1, (String)n2){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple2 tuple = (Tuple2)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2)}))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> Optional.of(iso.reverseGet(new Tuple2(a, b)))));
            }
        };
    }

    public static <TT, A, B, C> Function3<String, String, String, JsonCodec<TT>> codec3(final Iso<TT, Tuple3<A, B, C>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3) {
        return (Function3 & Serializable)(n1, n2, n3) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple3 tuple = (Tuple3)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3)})))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> Optional.of(iso.reverseGet(new Tuple3(a, b, c))))));
            }
        };
    }

    public static <TT, A, B, C, D> Function4<String, String, String, String, JsonCodec<TT>> codec4(final Iso<TT, Tuple4<A, B, C, D>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4) {
        return (Function4 & Serializable)(n1, n2, n3, n4) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple4 tuple = (Tuple4)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4)}))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> Optional.of(iso.reverseGet(new Tuple4(a, b, c, d)))))));
            }
        };
    }

    public static <TT, A, B, C, D, E> Function5<String, String, String, String, String, JsonCodec<TT>> codec5(final Iso<TT, Tuple5<A, B, C, D, E>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5) {
        return (Function5 & Serializable)(n1, n2, n3, n4, n5) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple5 tuple = (Tuple5)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5)})))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> Optional.of(iso.reverseGet(new Tuple5(a, b, c, d, e))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F> Function6<String, String, String, String, String, String, JsonCodec<TT>> codec6(final Iso<TT, Tuple6<A, B, C, D, E, F>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6) {
        return (Function6 & Serializable)(n1, n2, n3, n4, n5, n6) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple6 tuple = (Tuple6)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6)}))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> Optional.of(iso.reverseGet(new Tuple6(a, b, c, d, e, f)))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G> Function7<String, String, String, String, String, String, String, JsonCodec<TT>> codec7(final Iso<TT, Tuple7<A, B, C, D, E, F, G>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7) {
        return (Function7 & Serializable)(n1, n2, n3, n4, n5, n6, n7) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple7 tuple = (Tuple7)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7)})))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> Optional.of(iso.reverseGet(new Tuple7(a, b, c, d, e, f, g))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H> Function8<String, String, String, String, String, String, String, String, JsonCodec<TT>> codec8(final Iso<TT, Tuple8<A, B, C, D, E, F, G, H>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8) {
        return (Function8 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple8 tuple = (Tuple8)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8)}))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> Optional.of(iso.reverseGet(new Tuple8(a, b, c, d, e, f, g, h)))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I> Function9<String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec9(final Iso<TT, Tuple9<A, B, C, D, E, F, G, H, I>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9) {
        return (Function9 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple9 tuple = (Tuple9)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9)})))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> Optional.of(iso.reverseGet(new Tuple9(a, b, c, d, e, f, g, h, i))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J> Function10<String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec10(final Iso<TT, Tuple10<A, B, C, D, E, F, G, H, I, J>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10) {
        return (Function10 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple10 tuple = (Tuple10)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10)}))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> Optional.of(iso.reverseGet(new Tuple10(a, b, c, d, e, f, g, h, i, j)))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K> Function11<String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec11(final Iso<TT, Tuple11<A, B, C, D, E, F, G, H, I, J, K>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11) {
        return (Function11 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple11 tuple = (Tuple11)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11)})))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> Optional.of(iso.reverseGet(new Tuple11(a, b, c, d, e, f, g, h, i, j, k))))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K, L> Function12<String, String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec12(final Iso<TT, Tuple12<A, B, C, D, E, F, G, H, I, J, K, L>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11, final JsonCodec<L> c12) {
        return (Function12 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11, (String)n12){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            final /* synthetic */ String val$n12;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
                this.val$n12 = string12;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple12 tuple = (Tuple12)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> c12.toJson(tuple._12).flatMap(j12 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11), Json.entry((String)this.val$n12, (Json.JValue)j12)}))))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                Optional ol = object.getAs(this.val$n12, c12::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> ol.flatMap(l -> Optional.of(iso.reverseGet(new Tuple12(a, b, c, d, e, f, g, h, i, j, k, l)))))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K, L, M> Function13<String, String, String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec13(final Iso<TT, Tuple13<A, B, C, D, E, F, G, H, I, J, K, L, M>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11, final JsonCodec<L> c12, final JsonCodec<M> c13) {
        return (Function13 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11, (String)n12, (String)n13){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            final /* synthetic */ String val$n12;
            final /* synthetic */ String val$n13;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
                this.val$n12 = string12;
                this.val$n13 = string13;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple13 tuple = (Tuple13)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> c12.toJson(tuple._12).flatMap(j12 -> c13.toJson(tuple._13).flatMap(j13 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11), Json.entry((String)this.val$n12, (Json.JValue)j12), Json.entry((String)this.val$n13, (Json.JValue)j13)})))))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                Optional ol = object.getAs(this.val$n12, c12::fromJson);
                Optional om = object.getAs(this.val$n13, c13::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> ol.flatMap(l -> om.flatMap(m -> Optional.of(iso.reverseGet(new Tuple13(a, b, c, d, e, f, g, h, i, j, k, l, m))))))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K, L, M, N> Function14<String, String, String, String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec14(final Iso<TT, Tuple14<A, B, C, D, E, F, G, H, I, J, K, L, M, N>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11, final JsonCodec<L> c12, final JsonCodec<M> c13, final JsonCodec<N> c14) {
        return (Function14 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11, (String)n12, (String)n13, (String)n14){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            final /* synthetic */ String val$n12;
            final /* synthetic */ String val$n13;
            final /* synthetic */ String val$n14;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
                this.val$n12 = string12;
                this.val$n13 = string13;
                this.val$n14 = string14;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple14 tuple = (Tuple14)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> c12.toJson(tuple._12).flatMap(j12 -> c13.toJson(tuple._13).flatMap(j13 -> c14.toJson(tuple._14).flatMap(j14 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11), Json.entry((String)this.val$n12, (Json.JValue)j12), Json.entry((String)this.val$n13, (Json.JValue)j13), Json.entry((String)this.val$n14, (Json.JValue)j14)}))))))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                Optional ol = object.getAs(this.val$n12, c12::fromJson);
                Optional om = object.getAs(this.val$n13, c13::fromJson);
                Optional on = object.getAs(this.val$n14, c14::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> ol.flatMap(l -> om.flatMap(m -> on.flatMap(n -> Optional.of(iso.reverseGet(new Tuple14(a, b, c, d, e, f, g, h, i, j, k, l, m, n)))))))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O> Function15<String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec15(final Iso<TT, Tuple15<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11, final JsonCodec<L> c12, final JsonCodec<M> c13, final JsonCodec<N> c14, final JsonCodec<O> c15) {
        return (Function15 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11, (String)n12, (String)n13, (String)n14, (String)n15){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            final /* synthetic */ String val$n12;
            final /* synthetic */ String val$n13;
            final /* synthetic */ String val$n14;
            final /* synthetic */ String val$n15;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
                this.val$n12 = string12;
                this.val$n13 = string13;
                this.val$n14 = string14;
                this.val$n15 = string15;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple15 tuple = (Tuple15)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> c12.toJson(tuple._12).flatMap(j12 -> c13.toJson(tuple._13).flatMap(j13 -> c14.toJson(tuple._14).flatMap(j14 -> c15.toJson(tuple._15).flatMap(j15 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11), Json.entry((String)this.val$n12, (Json.JValue)j12), Json.entry((String)this.val$n13, (Json.JValue)j13), Json.entry((String)this.val$n14, (Json.JValue)j14), Json.entry((String)this.val$n15, (Json.JValue)j15)})))))))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                Optional ol = object.getAs(this.val$n12, c12::fromJson);
                Optional om = object.getAs(this.val$n13, c13::fromJson);
                Optional on = object.getAs(this.val$n14, c14::fromJson);
                Optional oo = object.getAs(this.val$n15, c15::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> ol.flatMap(l -> om.flatMap(m -> on.flatMap(n -> oo.flatMap(o -> Optional.of(iso.reverseGet(new Tuple15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o))))))))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P> Function16<String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec16(final Iso<TT, Tuple16<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11, final JsonCodec<L> c12, final JsonCodec<M> c13, final JsonCodec<N> c14, final JsonCodec<O> c15, final JsonCodec<P> c16) {
        return (Function16 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11, (String)n12, (String)n13, (String)n14, (String)n15, (String)n16){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            final /* synthetic */ String val$n12;
            final /* synthetic */ String val$n13;
            final /* synthetic */ String val$n14;
            final /* synthetic */ String val$n15;
            final /* synthetic */ String val$n16;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
                this.val$n12 = string12;
                this.val$n13 = string13;
                this.val$n14 = string14;
                this.val$n15 = string15;
                this.val$n16 = string16;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple16 tuple = (Tuple16)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> c12.toJson(tuple._12).flatMap(j12 -> c13.toJson(tuple._13).flatMap(j13 -> c14.toJson(tuple._14).flatMap(j14 -> c15.toJson(tuple._15).flatMap(j15 -> c16.toJson(tuple._16).flatMap(j16 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11), Json.entry((String)this.val$n12, (Json.JValue)j12), Json.entry((String)this.val$n13, (Json.JValue)j13), Json.entry((String)this.val$n14, (Json.JValue)j14), Json.entry((String)this.val$n15, (Json.JValue)j15), Json.entry((String)this.val$n16, (Json.JValue)j16)}))))))))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                Optional ol = object.getAs(this.val$n12, c12::fromJson);
                Optional om = object.getAs(this.val$n13, c13::fromJson);
                Optional on = object.getAs(this.val$n14, c14::fromJson);
                Optional oo = object.getAs(this.val$n15, c15::fromJson);
                Optional op = object.getAs(this.val$n16, c16::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> ol.flatMap(l -> om.flatMap(m -> on.flatMap(n -> oo.flatMap(o -> op.flatMap(p -> Optional.of(iso.reverseGet(new Tuple16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)))))))))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q> Function17<String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec17(final Iso<TT, Tuple17<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11, final JsonCodec<L> c12, final JsonCodec<M> c13, final JsonCodec<N> c14, final JsonCodec<O> c15, final JsonCodec<P> c16, final JsonCodec<Q> c17) {
        return (Function17 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11, (String)n12, (String)n13, (String)n14, (String)n15, (String)n16, (String)n17){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            final /* synthetic */ String val$n12;
            final /* synthetic */ String val$n13;
            final /* synthetic */ String val$n14;
            final /* synthetic */ String val$n15;
            final /* synthetic */ String val$n16;
            final /* synthetic */ String val$n17;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
                this.val$n12 = string12;
                this.val$n13 = string13;
                this.val$n14 = string14;
                this.val$n15 = string15;
                this.val$n16 = string16;
                this.val$n17 = string17;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple17 tuple = (Tuple17)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> c12.toJson(tuple._12).flatMap(j12 -> c13.toJson(tuple._13).flatMap(j13 -> c14.toJson(tuple._14).flatMap(j14 -> c15.toJson(tuple._15).flatMap(j15 -> c16.toJson(tuple._16).flatMap(j16 -> c17.toJson(tuple._17).flatMap(j17 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11), Json.entry((String)this.val$n12, (Json.JValue)j12), Json.entry((String)this.val$n13, (Json.JValue)j13), Json.entry((String)this.val$n14, (Json.JValue)j14), Json.entry((String)this.val$n15, (Json.JValue)j15), Json.entry((String)this.val$n16, (Json.JValue)j16), Json.entry((String)this.val$n17, (Json.JValue)j17)})))))))))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                Optional ol = object.getAs(this.val$n12, c12::fromJson);
                Optional om = object.getAs(this.val$n13, c13::fromJson);
                Optional on = object.getAs(this.val$n14, c14::fromJson);
                Optional oo = object.getAs(this.val$n15, c15::fromJson);
                Optional op = object.getAs(this.val$n16, c16::fromJson);
                Optional oq = object.getAs(this.val$n17, c17::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> ol.flatMap(l -> om.flatMap(m -> on.flatMap(n -> oo.flatMap(o -> op.flatMap(p -> oq.flatMap(q -> Optional.of(iso.reverseGet(new Tuple17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q))))))))))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R> Function18<String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec18(final Iso<TT, Tuple18<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11, final JsonCodec<L> c12, final JsonCodec<M> c13, final JsonCodec<N> c14, final JsonCodec<O> c15, final JsonCodec<P> c16, final JsonCodec<Q> c17, final JsonCodec<R> c18) {
        return (Function18 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11, (String)n12, (String)n13, (String)n14, (String)n15, (String)n16, (String)n17, (String)n18){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            final /* synthetic */ String val$n12;
            final /* synthetic */ String val$n13;
            final /* synthetic */ String val$n14;
            final /* synthetic */ String val$n15;
            final /* synthetic */ String val$n16;
            final /* synthetic */ String val$n17;
            final /* synthetic */ String val$n18;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
                this.val$n12 = string12;
                this.val$n13 = string13;
                this.val$n14 = string14;
                this.val$n15 = string15;
                this.val$n16 = string16;
                this.val$n17 = string17;
                this.val$n18 = string18;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple18 tuple = (Tuple18)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> c12.toJson(tuple._12).flatMap(j12 -> c13.toJson(tuple._13).flatMap(j13 -> c14.toJson(tuple._14).flatMap(j14 -> c15.toJson(tuple._15).flatMap(j15 -> c16.toJson(tuple._16).flatMap(j16 -> c17.toJson(tuple._17).flatMap(j17 -> c18.toJson(tuple._18).flatMap(j18 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11), Json.entry((String)this.val$n12, (Json.JValue)j12), Json.entry((String)this.val$n13, (Json.JValue)j13), Json.entry((String)this.val$n14, (Json.JValue)j14), Json.entry((String)this.val$n15, (Json.JValue)j15), Json.entry((String)this.val$n16, (Json.JValue)j16), Json.entry((String)this.val$n17, (Json.JValue)j17), Json.entry((String)this.val$n18, (Json.JValue)j18)}))))))))))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                Optional ol = object.getAs(this.val$n12, c12::fromJson);
                Optional om = object.getAs(this.val$n13, c13::fromJson);
                Optional on = object.getAs(this.val$n14, c14::fromJson);
                Optional oo = object.getAs(this.val$n15, c15::fromJson);
                Optional op = object.getAs(this.val$n16, c16::fromJson);
                Optional oq = object.getAs(this.val$n17, c17::fromJson);
                Optional or = object.getAs(this.val$n18, c18::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> ol.flatMap(l -> om.flatMap(m -> on.flatMap(n -> oo.flatMap(o -> op.flatMap(p -> oq.flatMap(q -> or.flatMap(r -> Optional.of(iso.reverseGet(new Tuple18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r)))))))))))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S> Function19<String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec19(final Iso<TT, Tuple19<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11, final JsonCodec<L> c12, final JsonCodec<M> c13, final JsonCodec<N> c14, final JsonCodec<O> c15, final JsonCodec<P> c16, final JsonCodec<Q> c17, final JsonCodec<R> c18, final JsonCodec<S> c19) {
        return (Function19 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11, (String)n12, (String)n13, (String)n14, (String)n15, (String)n16, (String)n17, (String)n18, (String)n19){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            final /* synthetic */ String val$n12;
            final /* synthetic */ String val$n13;
            final /* synthetic */ String val$n14;
            final /* synthetic */ String val$n15;
            final /* synthetic */ String val$n16;
            final /* synthetic */ String val$n17;
            final /* synthetic */ String val$n18;
            final /* synthetic */ String val$n19;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
                this.val$n12 = string12;
                this.val$n13 = string13;
                this.val$n14 = string14;
                this.val$n15 = string15;
                this.val$n16 = string16;
                this.val$n17 = string17;
                this.val$n18 = string18;
                this.val$n19 = string19;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple19 tuple = (Tuple19)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> c12.toJson(tuple._12).flatMap(j12 -> c13.toJson(tuple._13).flatMap(j13 -> c14.toJson(tuple._14).flatMap(j14 -> c15.toJson(tuple._15).flatMap(j15 -> c16.toJson(tuple._16).flatMap(j16 -> c17.toJson(tuple._17).flatMap(j17 -> c18.toJson(tuple._18).flatMap(j18 -> c19.toJson(tuple._19).flatMap(j19 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11), Json.entry((String)this.val$n12, (Json.JValue)j12), Json.entry((String)this.val$n13, (Json.JValue)j13), Json.entry((String)this.val$n14, (Json.JValue)j14), Json.entry((String)this.val$n15, (Json.JValue)j15), Json.entry((String)this.val$n16, (Json.JValue)j16), Json.entry((String)this.val$n17, (Json.JValue)j17), Json.entry((String)this.val$n18, (Json.JValue)j18), Json.entry((String)this.val$n19, (Json.JValue)j19)})))))))))))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                Optional ol = object.getAs(this.val$n12, c12::fromJson);
                Optional om = object.getAs(this.val$n13, c13::fromJson);
                Optional on = object.getAs(this.val$n14, c14::fromJson);
                Optional oo = object.getAs(this.val$n15, c15::fromJson);
                Optional op = object.getAs(this.val$n16, c16::fromJson);
                Optional oq = object.getAs(this.val$n17, c17::fromJson);
                Optional or = object.getAs(this.val$n18, c18::fromJson);
                Optional os = object.getAs(this.val$n19, c19::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> ol.flatMap(l -> om.flatMap(m -> on.flatMap(n -> oo.flatMap(o -> op.flatMap(p -> oq.flatMap(q -> or.flatMap(r -> os.flatMap(s -> Optional.of(iso.reverseGet(new Tuple19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s))))))))))))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T> Function20<String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec20(final Iso<TT, Tuple20<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11, final JsonCodec<L> c12, final JsonCodec<M> c13, final JsonCodec<N> c14, final JsonCodec<O> c15, final JsonCodec<P> c16, final JsonCodec<Q> c17, final JsonCodec<R> c18, final JsonCodec<S> c19, final JsonCodec<T> c20) {
        return (Function20 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19, n20) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11, (String)n12, (String)n13, (String)n14, (String)n15, (String)n16, (String)n17, (String)n18, (String)n19, (String)n20){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            final /* synthetic */ String val$n12;
            final /* synthetic */ String val$n13;
            final /* synthetic */ String val$n14;
            final /* synthetic */ String val$n15;
            final /* synthetic */ String val$n16;
            final /* synthetic */ String val$n17;
            final /* synthetic */ String val$n18;
            final /* synthetic */ String val$n19;
            final /* synthetic */ String val$n20;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
                this.val$n12 = string12;
                this.val$n13 = string13;
                this.val$n14 = string14;
                this.val$n15 = string15;
                this.val$n16 = string16;
                this.val$n17 = string17;
                this.val$n18 = string18;
                this.val$n19 = string19;
                this.val$n20 = string20;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple20 tuple = (Tuple20)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> c12.toJson(tuple._12).flatMap(j12 -> c13.toJson(tuple._13).flatMap(j13 -> c14.toJson(tuple._14).flatMap(j14 -> c15.toJson(tuple._15).flatMap(j15 -> c16.toJson(tuple._16).flatMap(j16 -> c17.toJson(tuple._17).flatMap(j17 -> c18.toJson(tuple._18).flatMap(j18 -> c19.toJson(tuple._19).flatMap(j19 -> c20.toJson(tuple._20).flatMap(j20 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11), Json.entry((String)this.val$n12, (Json.JValue)j12), Json.entry((String)this.val$n13, (Json.JValue)j13), Json.entry((String)this.val$n14, (Json.JValue)j14), Json.entry((String)this.val$n15, (Json.JValue)j15), Json.entry((String)this.val$n16, (Json.JValue)j16), Json.entry((String)this.val$n17, (Json.JValue)j17), Json.entry((String)this.val$n18, (Json.JValue)j18), Json.entry((String)this.val$n19, (Json.JValue)j19), Json.entry((String)this.val$n20, (Json.JValue)j20)}))))))))))))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                Optional ol = object.getAs(this.val$n12, c12::fromJson);
                Optional om = object.getAs(this.val$n13, c13::fromJson);
                Optional on = object.getAs(this.val$n14, c14::fromJson);
                Optional oo = object.getAs(this.val$n15, c15::fromJson);
                Optional op = object.getAs(this.val$n16, c16::fromJson);
                Optional oq = object.getAs(this.val$n17, c17::fromJson);
                Optional or = object.getAs(this.val$n18, c18::fromJson);
                Optional os = object.getAs(this.val$n19, c19::fromJson);
                Optional ot = object.getAs(this.val$n20, c20::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> ol.flatMap(l -> om.flatMap(m -> on.flatMap(n -> oo.flatMap(o -> op.flatMap(p -> oq.flatMap(q -> or.flatMap(r -> os.flatMap(s -> ot.flatMap(t -> Optional.of(iso.reverseGet(new Tuple20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t)))))))))))))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U> Function21<String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec21(final Iso<TT, Tuple21<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11, final JsonCodec<L> c12, final JsonCodec<M> c13, final JsonCodec<N> c14, final JsonCodec<O> c15, final JsonCodec<P> c16, final JsonCodec<Q> c17, final JsonCodec<R> c18, final JsonCodec<S> c19, final JsonCodec<T> c20, final JsonCodec<U> c21) {
        return (Function21 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19, n20, n21) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11, (String)n12, (String)n13, (String)n14, (String)n15, (String)n16, (String)n17, (String)n18, (String)n19, (String)n20, (String)n21){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            final /* synthetic */ String val$n12;
            final /* synthetic */ String val$n13;
            final /* synthetic */ String val$n14;
            final /* synthetic */ String val$n15;
            final /* synthetic */ String val$n16;
            final /* synthetic */ String val$n17;
            final /* synthetic */ String val$n18;
            final /* synthetic */ String val$n19;
            final /* synthetic */ String val$n20;
            final /* synthetic */ String val$n21;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
                this.val$n12 = string12;
                this.val$n13 = string13;
                this.val$n14 = string14;
                this.val$n15 = string15;
                this.val$n16 = string16;
                this.val$n17 = string17;
                this.val$n18 = string18;
                this.val$n19 = string19;
                this.val$n20 = string20;
                this.val$n21 = string21;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple21 tuple = (Tuple21)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> c12.toJson(tuple._12).flatMap(j12 -> c13.toJson(tuple._13).flatMap(j13 -> c14.toJson(tuple._14).flatMap(j14 -> c15.toJson(tuple._15).flatMap(j15 -> c16.toJson(tuple._16).flatMap(j16 -> c17.toJson(tuple._17).flatMap(j17 -> c18.toJson(tuple._18).flatMap(j18 -> c19.toJson(tuple._19).flatMap(j19 -> c20.toJson(tuple._20).flatMap(j20 -> c21.toJson(tuple._21).flatMap(j21 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11), Json.entry((String)this.val$n12, (Json.JValue)j12), Json.entry((String)this.val$n13, (Json.JValue)j13), Json.entry((String)this.val$n14, (Json.JValue)j14), Json.entry((String)this.val$n15, (Json.JValue)j15), Json.entry((String)this.val$n16, (Json.JValue)j16), Json.entry((String)this.val$n17, (Json.JValue)j17), Json.entry((String)this.val$n18, (Json.JValue)j18), Json.entry((String)this.val$n19, (Json.JValue)j19), Json.entry((String)this.val$n20, (Json.JValue)j20), Json.entry((String)this.val$n21, (Json.JValue)j21)})))))))))))))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                Optional ol = object.getAs(this.val$n12, c12::fromJson);
                Optional om = object.getAs(this.val$n13, c13::fromJson);
                Optional on = object.getAs(this.val$n14, c14::fromJson);
                Optional oo = object.getAs(this.val$n15, c15::fromJson);
                Optional op = object.getAs(this.val$n16, c16::fromJson);
                Optional oq = object.getAs(this.val$n17, c17::fromJson);
                Optional or = object.getAs(this.val$n18, c18::fromJson);
                Optional os = object.getAs(this.val$n19, c19::fromJson);
                Optional ot = object.getAs(this.val$n20, c20::fromJson);
                Optional ou = object.getAs(this.val$n21, c21::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> ol.flatMap(l -> om.flatMap(m -> on.flatMap(n -> oo.flatMap(o -> op.flatMap(p -> oq.flatMap(q -> or.flatMap(r -> os.flatMap(s -> ot.flatMap(t -> ou.flatMap(u -> Optional.of(iso.reverseGet(new Tuple21(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u))))))))))))))))))))))));
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V> Function22<String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, String, JsonCodec<TT>> codec22(final Iso<TT, Tuple22<A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8, final JsonCodec<I> c9, final JsonCodec<J> c10, final JsonCodec<K> c11, final JsonCodec<L> c12, final JsonCodec<M> c13, final JsonCodec<N> c14, final JsonCodec<O> c15, final JsonCodec<P> c16, final JsonCodec<Q> c17, final JsonCodec<R> c18, final JsonCodec<S> c19, final JsonCodec<T> c20, final JsonCodec<U> c21, final JsonCodec<V> c22) {
        return (Function22 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19, n20, n21, n22) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8, (String)n9, (String)n10, (String)n11, (String)n12, (String)n13, (String)n14, (String)n15, (String)n16, (String)n17, (String)n18, (String)n19, (String)n20, (String)n21, (String)n22){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            final /* synthetic */ String val$n9;
            final /* synthetic */ String val$n10;
            final /* synthetic */ String val$n11;
            final /* synthetic */ String val$n12;
            final /* synthetic */ String val$n13;
            final /* synthetic */ String val$n14;
            final /* synthetic */ String val$n15;
            final /* synthetic */ String val$n16;
            final /* synthetic */ String val$n17;
            final /* synthetic */ String val$n18;
            final /* synthetic */ String val$n19;
            final /* synthetic */ String val$n20;
            final /* synthetic */ String val$n21;
            final /* synthetic */ String val$n22;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
                this.val$n9 = string9;
                this.val$n10 = string10;
                this.val$n11 = string11;
                this.val$n12 = string12;
                this.val$n13 = string13;
                this.val$n14 = string14;
                this.val$n15 = string15;
                this.val$n16 = string16;
                this.val$n17 = string17;
                this.val$n18 = string18;
                this.val$n19 = string19;
                this.val$n20 = string20;
                this.val$n21 = string21;
                this.val$n22 = string22;
            }

            @Override
            public Optional<Json.JValue> toJson(TT value) {
                Tuple22 tuple = (Tuple22)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> c9.toJson(tuple._9).flatMap(j9 -> c10.toJson(tuple._10).flatMap(j10 -> c11.toJson(tuple._11).flatMap(j11 -> c12.toJson(tuple._12).flatMap(j12 -> c13.toJson(tuple._13).flatMap(j13 -> c14.toJson(tuple._14).flatMap(j14 -> c15.toJson(tuple._15).flatMap(j15 -> c16.toJson(tuple._16).flatMap(j16 -> c17.toJson(tuple._17).flatMap(j17 -> c18.toJson(tuple._18).flatMap(j18 -> c19.toJson(tuple._19).flatMap(j19 -> c20.toJson(tuple._20).flatMap(j20 -> c21.toJson(tuple._21).flatMap(j21 -> c22.toJson(tuple._22).flatMap(j22 -> Optional.of(Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8), Json.entry((String)this.val$n9, (Json.JValue)j9), Json.entry((String)this.val$n10, (Json.JValue)j10), Json.entry((String)this.val$n11, (Json.JValue)j11), Json.entry((String)this.val$n12, (Json.JValue)j12), Json.entry((String)this.val$n13, (Json.JValue)j13), Json.entry((String)this.val$n14, (Json.JValue)j14), Json.entry((String)this.val$n15, (Json.JValue)j15), Json.entry((String)this.val$n16, (Json.JValue)j16), Json.entry((String)this.val$n17, (Json.JValue)j17), Json.entry((String)this.val$n18, (Json.JValue)j18), Json.entry((String)this.val$n19, (Json.JValue)j19), Json.entry((String)this.val$n20, (Json.JValue)j20), Json.entry((String)this.val$n21, (Json.JValue)j21), Json.entry((String)this.val$n22, (Json.JValue)j22)}))))))))))))))))))))))));
            }

            @Override
            public Optional<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                Optional oa = object.getAs(this.val$n1, c1::fromJson);
                Optional ob = object.getAs(this.val$n2, c2::fromJson);
                Optional oc = object.getAs(this.val$n3, c3::fromJson);
                Optional od = object.getAs(this.val$n4, c4::fromJson);
                Optional oe = object.getAs(this.val$n5, c5::fromJson);
                Optional of = object.getAs(this.val$n6, c6::fromJson);
                Optional og = object.getAs(this.val$n7, c7::fromJson);
                Optional oh = object.getAs(this.val$n8, c8::fromJson);
                Optional oi = object.getAs(this.val$n9, c9::fromJson);
                Optional oj = object.getAs(this.val$n10, c10::fromJson);
                Optional ok = object.getAs(this.val$n11, c11::fromJson);
                Optional ol = object.getAs(this.val$n12, c12::fromJson);
                Optional om = object.getAs(this.val$n13, c13::fromJson);
                Optional on = object.getAs(this.val$n14, c14::fromJson);
                Optional oo = object.getAs(this.val$n15, c15::fromJson);
                Optional op = object.getAs(this.val$n16, c16::fromJson);
                Optional oq = object.getAs(this.val$n17, c17::fromJson);
                Optional or = object.getAs(this.val$n18, c18::fromJson);
                Optional os = object.getAs(this.val$n19, c19::fromJson);
                Optional ot = object.getAs(this.val$n20, c20::fromJson);
                Optional ou = object.getAs(this.val$n21, c21::fromJson);
                Optional ov = object.getAs(this.val$n22, c22::fromJson);
                return oa.flatMap(a -> ob.flatMap(b -> oc.flatMap(c -> od.flatMap(d -> oe.flatMap(e -> of.flatMap(f -> og.flatMap(g -> oh.flatMap(h -> oi.flatMap(i -> oj.flatMap(j -> ok.flatMap(k -> ol.flatMap(l -> om.flatMap(m -> on.flatMap(n -> oo.flatMap(o -> op.flatMap(p -> oq.flatMap(q -> or.flatMap(r -> os.flatMap(s -> ot.flatMap(t -> ou.flatMap(u -> ov.flatMap(v -> Optional.of(iso.reverseGet(new Tuple22(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)))))))))))))))))))))))));
            }
        };
    }
}

