/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javaslang.Function1;
import javaslang.Function2;
import javaslang.Function3;
import javaslang.Function4;
import javaslang.Function5;
import javaslang.Function6;
import javaslang.Function7;
import javaslang.Function8;
import javaslang.Tuple1;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.Tuple4;
import javaslang.Tuple5;
import javaslang.Tuple6;
import javaslang.Tuple7;
import javaslang.Tuple8;
import javaslang.Value;
import javaslang.control.Option;
import net.hamnaberg.json.DecodeJson;
import net.hamnaberg.json.DecodeResult;
import net.hamnaberg.json.EncodeJson;
import net.hamnaberg.json.Iso;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.JsonCodec;

public abstract class Codecs {
    public static final JsonCodec<String> StringCodec = new JsonCodec<String>(){

        @Override
        public Option<Json.JValue> toJson(String value) {
            return Option.of((Object)Json.jString((String)value));
        }

        @Override
        public DecodeResult<String> fromJson(Json.JValue value) {
            return DecodeResult.fromOption(value.asString());
        }

        public String toString() {
            return "StringCodec";
        }
    };
    public static final JsonCodec<Number> numberCodec = new JsonCodec<Number>(){

        @Override
        public Option<Json.JValue> toJson(Number value) {
            return Option.of((Object)Json.jNumber((Number)value));
        }

        @Override
        public DecodeResult<Number> fromJson(Json.JValue value) {
            return DecodeResult.fromOption(value.asBigDecimal().map(v -> v));
        }

        public String toString() {
            return "NumberCodec";
        }
    };
    public static final JsonCodec<Long> longCodec = new JsonCodec<Long>(){

        @Override
        public Option<Json.JValue> toJson(Long value) {
            return Option.of((Object)Json.jNumber((Number)value));
        }

        @Override
        public DecodeResult<Long> fromJson(Json.JValue value) {
            return DecodeResult.fromOption(value.asJsonNumber().map(Json.JNumber::asLong));
        }

        public String toString() {
            return "LongCodec";
        }
    };
    public static final JsonCodec<Double> doubleCodec = new JsonCodec<Double>(){

        @Override
        public Option<Json.JValue> toJson(Double value) {
            return Option.of((Object)Json.jNumber((Number)value));
        }

        @Override
        public DecodeResult<Double> fromJson(Json.JValue value) {
            return DecodeResult.fromOption(value.asJsonNumber().map(Json.JNumber::asDouble));
        }

        public String toString() {
            return "DoubleCodec";
        }
    };
    public static final JsonCodec<Integer> intCodec = new JsonCodec<Integer>(){

        @Override
        public Option<Json.JValue> toJson(Integer value) {
            return Option.of((Object)Json.jNumber((Number)value));
        }

        @Override
        public DecodeResult<Integer> fromJson(Json.JValue value) {
            return DecodeResult.fromOption(value.asJsonNumber().map(Json.JNumber::asInt));
        }

        public String toString() {
            return "IntCodec";
        }
    };
    public static final JsonCodec<Boolean> booleanCodec = new JsonCodec<Boolean>(){

        @Override
        public Option<Json.JValue> toJson(Boolean value) {
            return Option.of((Object)Json.jBoolean((boolean)value));
        }

        @Override
        public DecodeResult<Boolean> fromJson(Json.JValue value) {
            return DecodeResult.fromOption(value.asBoolean());
        }

        public String toString() {
            return "BooleanCodec";
        }
    };

    private Codecs() {
    }

    public static <A> JsonCodec<A> nullCodec() {
        return new JsonCodec<A>(){

            @Override
            public Option<Json.JValue> toJson(A value) {
                return Option.of((Object)Json.jNull());
            }

            @Override
            public DecodeResult<A> fromJson(Json.JValue value) {
                return DecodeResult.ok(null);
            }

            public String toString() {
                return "NullCodec";
            }
        };
    }

    public static <A> JsonCodec<javaslang.collection.List<A>> listCodec(final JsonCodec<A> codec) {
        return new JsonCodec<javaslang.collection.List<A>>(){

            @Override
            public DecodeResult<javaslang.collection.List<A>> fromJson(Json.JValue value) {
                return DecodeResult.sequence(value.asJsonArrayOrEmpty().mapToList(codec::fromJson));
            }

            @Override
            public Option<Json.JValue> toJson(javaslang.collection.List<A> value) {
                return Option.of((Object)Json.jArray((Iterable)value.flatMap(a -> codec.toJson(a).toList())));
            }

            @Override
            public Option<javaslang.collection.List<A>> defaultValue() {
                return Option.some((Object)javaslang.collection.List.empty());
            }

            public String toString() {
                return "listCodec(" + codec.toString() + ")";
            }
        };
    }

    public static <A> JsonCodec<List<A>> javaListCodec(JsonCodec<A> codec) {
        JsonCodec<List> listCodec = Codecs.listCodec(codec).xmap(Value::toJavaList, javaslang.collection.List::ofAll);
        return JsonCodec.lift(listCodec.withDefaultValue(Collections.emptyList()), listCodec);
    }

    public static <A> JsonCodec<Option<A>> OptionCodec(JsonCodec<A> codec) {
        DecodeJson<Option> decoder = value -> value.isNull() ? DecodeResult.ok(Option.none()) : DecodeResult.ok(codec.fromJson(value).toOption());
        EncodeJson<Option> encoder = value -> value.flatMap(codec::toJson).orElse(Option.some((Object)Json.jNull()));
        return JsonCodec.lift(decoder.withDefaultValue(Option.none()), encoder);
    }

    public static <A> JsonCodec<Optional<A>> OptionalCodec(JsonCodec<A> underlying) {
        JsonCodec<Optional> codec = Codecs.OptionCodec(underlying).xmap(Value::toJavaOptional, Option::ofOptional);
        return JsonCodec.lift(codec.withDefaultValue(Optional.empty()), codec);
    }

    public static <A> JsonCodec<A> objectCodec(Function<Json.JObject, DecodeResult<A>> decoder, Function<A, Json.JObject> encoder) {
        return JsonCodec.lift(json -> (DecodeResult)decoder.apply(json.asJsonObjectOrEmpty()), a -> Option.some((Object)((Json.JObject)encoder.apply(a)).asJValue()));
    }

    @Deprecated
    public static <A> JsonCodec<A> makeCodec(DecodeJson<A> decoder, EncodeJson<A> encoder) {
        return JsonCodec.lift(decoder, encoder);
    }

    public static <TT, A> Function1<String, JsonCodec<TT>> codec1(final Iso<TT, Tuple1<A>> iso, final JsonCodec<A> c1) {
        return (Function1 & Serializable)n1 -> new JsonCodec<TT>((String)n1){
            final /* synthetic */ String val$n1;
            {
                this.val$n1 = string;
            }

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple1 tuple = (Tuple1)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> Option.of((Object)Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[0])));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, this.val$n1, c1);
                return oa.flatMap((A a) -> DecodeResult.ok(iso.reverseGet(new Tuple1(a))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.val$n1, c1.toString());
                return "codec1" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B> Function2<String, String, JsonCodec<TT>> codec2(final Iso<TT, Tuple2<A, B>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2) {
        return (Function2 & Serializable)(n1, n2) -> new JsonCodec<TT>((String)n1, (String)n2){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
            }

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple2 tuple = (Tuple2)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> Option.of((Object)Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2)}))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, this.val$n1, c1);
                DecodeResult ob = DecodeResult.decode(object, this.val$n2, c2);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> DecodeResult.ok(iso.reverseGet(new Tuple2(a, b)))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.val$n1, c1.toString());
                map.put(this.val$n2, c2.toString());
                return "codec2" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C> Function3<String, String, String, JsonCodec<TT>> codec3(final Iso<TT, Tuple3<A, B, C>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3) {
        return (Function3 & Serializable)(n1, n2, n3) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
            }

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple3 tuple = (Tuple3)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> Option.of((Object)Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3)})))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, this.val$n1, c1);
                DecodeResult ob = DecodeResult.decode(object, this.val$n2, c2);
                DecodeResult oc = DecodeResult.decode(object, this.val$n3, c3);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> DecodeResult.ok(iso.reverseGet(new Tuple3(a, b, c))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.val$n1, c1.toString());
                map.put(this.val$n2, c2.toString());
                map.put(this.val$n3, c3.toString());
                return "codec3" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C, D> Function4<String, String, String, String, JsonCodec<TT>> codec4(final Iso<TT, Tuple4<A, B, C, D>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4) {
        return (Function4 & Serializable)(n1, n2, n3, n4) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
            }

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple4 tuple = (Tuple4)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> Option.of((Object)Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4)}))))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, this.val$n1, c1);
                DecodeResult ob = DecodeResult.decode(object, this.val$n2, c2);
                DecodeResult oc = DecodeResult.decode(object, this.val$n3, c3);
                DecodeResult od = DecodeResult.decode(object, this.val$n4, c4);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> od.flatMap((A d) -> DecodeResult.ok(iso.reverseGet(new Tuple4(a, b, c, d)))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.val$n1, c1.toString());
                map.put(this.val$n2, c2.toString());
                map.put(this.val$n3, c3.toString());
                map.put(this.val$n4, c4.toString());
                return "codec4" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C, D, E> Function5<String, String, String, String, String, JsonCodec<TT>> codec5(final Iso<TT, Tuple5<A, B, C, D, E>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5) {
        return (Function5 & Serializable)(n1, n2, n3, n4, n5) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
            }

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple5 tuple = (Tuple5)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> Option.of((Object)Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5)})))))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, this.val$n1, c1);
                DecodeResult ob = DecodeResult.decode(object, this.val$n2, c2);
                DecodeResult oc = DecodeResult.decode(object, this.val$n3, c3);
                DecodeResult od = DecodeResult.decode(object, this.val$n4, c4);
                DecodeResult oe = DecodeResult.decode(object, this.val$n5, c5);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> od.flatMap((A d) -> oe.flatMap((A e) -> DecodeResult.ok(iso.reverseGet(new Tuple5(a, b, c, d, e))))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.val$n1, c1.toString());
                map.put(this.val$n2, c2.toString());
                map.put(this.val$n3, c3.toString());
                map.put(this.val$n4, c4.toString());
                map.put(this.val$n5, c5.toString());
                return "codec5" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C, D, E, F> Function6<String, String, String, String, String, String, JsonCodec<TT>> codec6(final Iso<TT, Tuple6<A, B, C, D, E, F>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6) {
        return (Function6 & Serializable)(n1, n2, n3, n4, n5, n6) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
            }

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple6 tuple = (Tuple6)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> Option.of((Object)Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6)}))))))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, this.val$n1, c1);
                DecodeResult ob = DecodeResult.decode(object, this.val$n2, c2);
                DecodeResult oc = DecodeResult.decode(object, this.val$n3, c3);
                DecodeResult od = DecodeResult.decode(object, this.val$n4, c4);
                DecodeResult oe = DecodeResult.decode(object, this.val$n5, c5);
                DecodeResult of = DecodeResult.decode(object, this.val$n6, c6);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> od.flatMap((A d) -> oe.flatMap((A e) -> of.flatMap((A f) -> DecodeResult.ok(iso.reverseGet(new Tuple6(a, b, c, d, e, f)))))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.val$n1, c1.toString());
                map.put(this.val$n2, c2.toString());
                map.put(this.val$n3, c3.toString());
                map.put(this.val$n4, c4.toString());
                map.put(this.val$n5, c5.toString());
                map.put(this.val$n6, c6.toString());
                return "codec6" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G> Function7<String, String, String, String, String, String, String, JsonCodec<TT>> codec7(final Iso<TT, Tuple7<A, B, C, D, E, F, G>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7) {
        return (Function7 & Serializable)(n1, n2, n3, n4, n5, n6, n7) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
            }

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple7 tuple = (Tuple7)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> Option.of((Object)Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7)})))))))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, this.val$n1, c1);
                DecodeResult ob = DecodeResult.decode(object, this.val$n2, c2);
                DecodeResult oc = DecodeResult.decode(object, this.val$n3, c3);
                DecodeResult od = DecodeResult.decode(object, this.val$n4, c4);
                DecodeResult oe = DecodeResult.decode(object, this.val$n5, c5);
                DecodeResult of = DecodeResult.decode(object, this.val$n6, c6);
                DecodeResult og = DecodeResult.decode(object, this.val$n7, c7);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> od.flatMap((A d) -> oe.flatMap((A e) -> of.flatMap((A f) -> og.flatMap((A g) -> DecodeResult.ok(iso.reverseGet(new Tuple7(a, b, c, d, e, f, g))))))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.val$n1, c1.toString());
                map.put(this.val$n2, c2.toString());
                map.put(this.val$n3, c3.toString());
                map.put(this.val$n4, c4.toString());
                map.put(this.val$n5, c5.toString());
                map.put(this.val$n6, c6.toString());
                map.put(this.val$n7, c7.toString());
                return "codec7" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H> Function8<String, String, String, String, String, String, String, String, JsonCodec<TT>> codec8(final Iso<TT, Tuple8<A, B, C, D, E, F, G, H>> iso, final JsonCodec<A> c1, final JsonCodec<B> c2, final JsonCodec<C> c3, final JsonCodec<D> c4, final JsonCodec<E> c5, final JsonCodec<F> c6, final JsonCodec<G> c7, final JsonCodec<H> c8) {
        return (Function8 & Serializable)(n1, n2, n3, n4, n5, n6, n7, n8) -> new JsonCodec<TT>((String)n1, (String)n2, (String)n3, (String)n4, (String)n5, (String)n6, (String)n7, (String)n8){
            final /* synthetic */ String val$n1;
            final /* synthetic */ String val$n2;
            final /* synthetic */ String val$n3;
            final /* synthetic */ String val$n4;
            final /* synthetic */ String val$n5;
            final /* synthetic */ String val$n6;
            final /* synthetic */ String val$n7;
            final /* synthetic */ String val$n8;
            {
                this.val$n1 = string;
                this.val$n2 = string2;
                this.val$n3 = string3;
                this.val$n4 = string4;
                this.val$n5 = string5;
                this.val$n6 = string6;
                this.val$n7 = string7;
                this.val$n8 = string8;
            }

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple8 tuple = (Tuple8)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> Option.of((Object)Json.jObject((Map.Entry)Json.entry((String)this.val$n1, (Json.JValue)j1), (Map.Entry[])new Map.Entry[]{Json.entry((String)this.val$n2, (Json.JValue)j2), Json.entry((String)this.val$n3, (Json.JValue)j3), Json.entry((String)this.val$n4, (Json.JValue)j4), Json.entry((String)this.val$n5, (Json.JValue)j5), Json.entry((String)this.val$n6, (Json.JValue)j6), Json.entry((String)this.val$n7, (Json.JValue)j7), Json.entry((String)this.val$n8, (Json.JValue)j8)}))))))))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, this.val$n1, c1);
                DecodeResult ob = DecodeResult.decode(object, this.val$n2, c2);
                DecodeResult oc = DecodeResult.decode(object, this.val$n3, c3);
                DecodeResult od = DecodeResult.decode(object, this.val$n4, c4);
                DecodeResult oe = DecodeResult.decode(object, this.val$n5, c5);
                DecodeResult of = DecodeResult.decode(object, this.val$n6, c6);
                DecodeResult og = DecodeResult.decode(object, this.val$n7, c7);
                DecodeResult oh = DecodeResult.decode(object, this.val$n8, c8);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> od.flatMap((A d) -> oe.flatMap((A e) -> of.flatMap((A f) -> og.flatMap((A g) -> oh.flatMap((A h) -> DecodeResult.ok(iso.reverseGet(new Tuple8(a, b, c, d, e, f, g, h)))))))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(this.val$n1, c1.toString());
                map.put(this.val$n2, c2.toString());
                map.put(this.val$n3, c3.toString());
                map.put(this.val$n4, c4.toString());
                map.put(this.val$n5, c5.toString());
                map.put(this.val$n6, c6.toString());
                map.put(this.val$n7, c7.toString());
                map.put(this.val$n8, c8.toString());
                return "codec8" + ((Object)map).toString();
            }
        };
    }
}

