/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javaslang.collection.List;
import javaslang.control.Option;
import net.hamnaberg.json.DecodeJson;
import net.hamnaberg.json.Json;

public abstract class DecodeResult<A> {
    private DecodeResult() {
    }

    public final <B> DecodeResult<B> map(Function<A, B> f) {
        return this.fold(okValue -> DecodeResult.ok(f.apply(okValue.value)), fail -> DecodeResult.fail(fail.message));
    }

    public final void forEach(Consumer<A> f) {
        this.foldUnit(okValue -> f.accept(okValue.value), ignore -> {});
    }

    public final <B> DecodeResult<B> flatMap(Function<A, DecodeResult<B>> f) {
        return this.fold(okValue -> (DecodeResult)f.apply(okValue.value), fail -> DecodeResult.fail(fail.message));
    }

    public final A getOrElse(Supplier<A> orElse) {
        return (A)this.fold(Ok::getValue, ignore -> orElse.get());
    }

    public final <X extends Throwable> A getOrElseThrow(Function<String, X> exProvider) throws X {
        if (this.isFailure()) {
            String msg = ((Failure)this).message;
            throw (Throwable)exProvider.apply(msg);
        }
        return ((Ok)this).value;
    }

    public final A unsafeGet() {
        return (A)this.fold(Ok::getValue, e -> {
            throw new NoSuchElementException(e.message);
        });
    }

    public final Option<A> toOption() {
        return this.fold(ok -> Option.of(ok.value), ignore -> Option.none());
    }

    public final Optional<A> toJavaOptional() {
        return this.toOption().toJavaOptional();
    }

    public abstract <B> B fold(Function<Ok<A>, B> var1, Function<Failure, B> var2);

    public abstract void foldUnit(Consumer<Ok<A>> var1, Consumer<Failure> var2);

    public boolean isOk() {
        return this.fold(a -> true, a -> false);
    }

    public boolean isFailure() {
        return this.fold(a -> false, a -> true);
    }

    public static <A> DecodeResult<List<A>> sequence(List<DecodeResult<A>> decodeResults) {
        if (decodeResults.isEmpty()) {
            return DecodeResult.ok(List.empty());
        }
        List list = List.empty();
        for (DecodeResult decodeResult : decodeResults) {
            if (decodeResult.isFailure()) {
                return DecodeResult.fail("One or more results failed");
            }
            list = list.prepend(decodeResult.unsafeGet());
        }
        return DecodeResult.ok(list.reverse());
    }

    public static <A> DecodeResult<A> ok(A value) {
        return new Ok<A>(value);
    }

    public static <A> DecodeResult<A> fromOption(Option<A> value) {
        return (DecodeResult)value.map(DecodeResult::ok).getOrElse(DecodeResult.fail("No value found"));
    }

    public static <A> DecodeResult<A> fail(String message) {
        return new Failure(message);
    }

    private static DecodeResult<Json.JValue> getValue(Json.JObject object, String name) {
        return (DecodeResult)object.get(name).map(DecodeResult::ok).getOrElse(DecodeResult.fail(String.format("%s not found in %s", name, object)));
    }

    public static <A> DecodeResult<A> decode(Json.JObject object, String name, DecodeJson<A> decoder) {
        Option<A> defaultValue;
        DecodeResult<Object> result = DecodeResult.getValue(object, name).flatMap(decoder::fromJson);
        if (result.isFailure() && (defaultValue = decoder.defaultValue()).isDefined()) {
            result = DecodeResult.ok(defaultValue.get());
        }
        return result;
    }

    public static final class Failure
    extends DecodeResult<Object> {
        public final String message;

        public Failure(String message) {
            this.message = message;
        }

        @Override
        public <B> B fold(Function<Ok<Object>, B> okFunction, Function<Failure, B> failFunction) {
            return failFunction.apply(this);
        }

        @Override
        public void foldUnit(Consumer<Ok<Object>> okFunction, Consumer<Failure> failFunction) {
            failFunction.accept(this);
        }

        public String toString() {
            return String.format("Failure(message='%s')", this.message);
        }
    }

    public static final class Ok<A>
    extends DecodeResult<A> {
        public final A value;

        public Ok(A value) {
            this.value = value;
        }

        @Override
        public <B> B fold(Function<Ok<A>, B> okFunction, Function<Failure, B> failFunction) {
            return okFunction.apply(this);
        }

        @Override
        public void foldUnit(Consumer<Ok<A>> okFunction, Consumer<Failure> failFunction) {
            okFunction.accept(this);
        }

        public A getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("Ok(value='%s')", this.value);
        }
    }
}

