/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javaslang.Tuple1;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.Tuple4;
import javaslang.Tuple5;
import javaslang.Tuple6;
import javaslang.Tuple7;
import javaslang.Tuple8;
import javaslang.Value;
import javaslang.control.Option;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.codec.DecodeJson;
import net.hamnaberg.json.codec.DecodeResult;
import net.hamnaberg.json.codec.DefaultJsonCodec;
import net.hamnaberg.json.codec.EncodeJson;
import net.hamnaberg.json.codec.Iso;
import net.hamnaberg.json.codec.JsonCodec;
import net.hamnaberg.json.codec.NamedJsonCodec;

public abstract class Codecs {
    public static final JsonCodec<String> StringCodec = new DefaultJsonCodec<String>(value -> DecodeResult.fromOption(value.asString()), value -> Option.some((Object)Json.jString((String)value)), "StringCodec");
    public static final JsonCodec<Number> numberCodec = new DefaultJsonCodec<Number>(value -> DecodeResult.fromOption(value.asBigDecimal().map(v -> v)), value -> Option.of((Object)Json.jNumber((Number)value)), "NumberCodec");
    public static final JsonCodec<Long> longCodec = new DefaultJsonCodec<Long>(value -> DecodeResult.fromOption(value.asJsonNumber().map(Json.JNumber::asLong)), value -> Option.of((Object)Json.jNumber((Number)value)), "LongCodec");
    public static final JsonCodec<Double> doubleCodec = new DefaultJsonCodec<Double>(value -> DecodeResult.fromOption(value.asJsonNumber().map(Json.JNumber::asDouble)), value -> Option.of((Object)Json.jNumber((Number)value)), "DoubleCodec");
    public static final JsonCodec<Integer> intCodec = new DefaultJsonCodec<Integer>(value -> DecodeResult.fromOption(value.asJsonNumber().map(Json.JNumber::asInt)), value -> Option.of((Object)Json.jNumber((Number)value)), "IntCodec");
    public static final JsonCodec<Boolean> booleanCodec = new DefaultJsonCodec<Boolean>(value -> DecodeResult.fromOption(value.asBoolean()), value -> Option.of((Object)Json.jBoolean((boolean)value)), "BooleanCodec");

    private Codecs() {
    }

    public static <A> JsonCodec<A> nullCodec() {
        return new DefaultJsonCodec<Object>(ignore -> DecodeResult.ok(null), ignore -> Option.of((Object)Json.jNull()), "NullCodec");
    }

    public static <A> JsonCodec<javaslang.collection.List<A>> listCodec(JsonCodec<A> codec) {
        DecodeJson<javaslang.collection.List> decodeJson = value -> DecodeResult.sequence(value.asJsonArrayOrEmpty().mapToList(codec::fromJson));
        return new DefaultJsonCodec<javaslang.collection.List<A>>(decodeJson.withDefaultValue(javaslang.collection.List.empty()), value -> Option.of((Object)Json.jArray((Iterable)value.flatMap(a -> codec.toJson(a).toList()))), String.format("ListCodec(%s)", codec.toString()));
    }

    public static <A> JsonCodec<List<A>> javaListCodec(JsonCodec<A> codec) {
        JsonCodec<List> listCodec = Codecs.listCodec(codec).xmap(Value::toJavaList, javaslang.collection.List::ofAll);
        return JsonCodec.lift(listCodec.withDefaultValue(Collections.emptyList()), listCodec);
    }

    public static <A> JsonCodec<Option<A>> OptionCodec(JsonCodec<A> codec) {
        DecodeJson<Option> decoder = value -> value.isNull() ? DecodeResult.ok(Option.none()) : DecodeResult.ok(codec.fromJson(value).toOption());
        EncodeJson<Option> encoder = value -> value.flatMap(codec::toJson).orElse(Option.some((Object)Json.jNull()));
        return JsonCodec.lift(decoder.withDefaultValue(Option.none()), encoder);
    }

    public static <A> JsonCodec<Optional<A>> OptionalCodec(JsonCodec<A> underlying) {
        JsonCodec<Optional> codec = Codecs.OptionCodec(underlying).xmap(Value::toJavaOptional, Option::ofOptional);
        return JsonCodec.lift(codec.withDefaultValue(Optional.empty()), codec);
    }

    public static <A> JsonCodec<A> objectCodec(Function<Json.JObject, DecodeResult<A>> decoder, Function<A, Json.JObject> encoder) {
        return JsonCodec.lift(json -> (DecodeResult)decoder.apply(json.asJsonObjectOrEmpty()), a -> Option.some((Object)((Json.JObject)encoder.apply(a)).asJValue()));
    }

    public static <TT, A> JsonCodec<TT> codec1(final Iso<TT, Tuple1<A>> iso, final NamedJsonCodec<A> c1) {
        return new JsonCodec<TT>(){

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple1 tuple = (Tuple1)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> Option.of((Object)Json.jObject((Tuple2)Json.tuple((String)c12.name, (Json.JValue)j1), (Tuple2[])new Tuple2[0])));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, c1.name, c1);
                return oa.flatMap((A a) -> DecodeResult.ok(iso.reverseGet(new Tuple1(a))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(c1.name, c1.toString());
                return "codec1" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B> JsonCodec<TT> codec2(final Iso<TT, Tuple2<A, B>> iso, final NamedJsonCodec<A> c1, final NamedJsonCodec<B> c2) {
        return new JsonCodec<TT>(){

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple2 tuple = (Tuple2)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> Option.of((Object)Json.jObject((Tuple2)Json.tuple((String)c12.name, (Json.JValue)j1), (Tuple2[])new Tuple2[]{Json.tuple((String)c22.name, (Json.JValue)j2)}))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, c1.name, c1);
                DecodeResult ob = DecodeResult.decode(object, c2.name, c2);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> DecodeResult.ok(iso.reverseGet(new Tuple2(a, b)))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(c1.name, c1.toString());
                map.put(c2.name, c2.toString());
                return "codec2" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C> JsonCodec<TT> codec3(final Iso<TT, Tuple3<A, B, C>> iso, final NamedJsonCodec<A> c1, final NamedJsonCodec<B> c2, final NamedJsonCodec<C> c3) {
        return new JsonCodec<TT>(){

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple3 tuple = (Tuple3)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> Option.of((Object)Json.jObject((Tuple2)Json.tuple((String)c12.name, (Json.JValue)j1), (Tuple2[])new Tuple2[]{Json.tuple((String)c22.name, (Json.JValue)j2), Json.tuple((String)c32.name, (Json.JValue)j3)})))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, c1.name, c1);
                DecodeResult ob = DecodeResult.decode(object, c2.name, c2);
                DecodeResult oc = DecodeResult.decode(object, c3.name, c3);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> DecodeResult.ok(iso.reverseGet(new Tuple3(a, b, c))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(c1.name, c1.toString());
                map.put(c2.name, c2.toString());
                map.put(c3.name, c3.toString());
                return "codec3" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C, D> JsonCodec<TT> codec4(final Iso<TT, Tuple4<A, B, C, D>> iso, final NamedJsonCodec<A> c1, final NamedJsonCodec<B> c2, final NamedJsonCodec<C> c3, final NamedJsonCodec<D> c4) {
        return new JsonCodec<TT>(){

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple4 tuple = (Tuple4)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> Option.of((Object)Json.jObject((Tuple2)Json.tuple((String)c12.name, (Json.JValue)j1), (Tuple2[])new Tuple2[]{Json.tuple((String)c12.name, (Json.JValue)j2), Json.tuple((String)c32.name, (Json.JValue)j3), Json.tuple((String)c42.name, (Json.JValue)j4)}))))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, c1.name, c1);
                DecodeResult ob = DecodeResult.decode(object, c2.name, c2);
                DecodeResult oc = DecodeResult.decode(object, c3.name, c3);
                DecodeResult od = DecodeResult.decode(object, c4.name, c4);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> od.flatMap((A d) -> DecodeResult.ok(iso.reverseGet(new Tuple4(a, b, c, d)))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(c1.name, c1.toString());
                map.put(c2.name, c2.toString());
                map.put(c3.name, c3.toString());
                map.put(c4.name, c4.toString());
                return "codec4" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C, D, E> JsonCodec<TT> codec5(final Iso<TT, Tuple5<A, B, C, D, E>> iso, final NamedJsonCodec<A> c1, final NamedJsonCodec<B> c2, final NamedJsonCodec<C> c3, final NamedJsonCodec<D> c4, final NamedJsonCodec<E> c5) {
        return new JsonCodec<TT>(){

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple5 tuple = (Tuple5)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> Option.of((Object)Json.jObject((Tuple2)Json.tuple((String)c12.name, (Json.JValue)j1), (Tuple2[])new Tuple2[]{Json.tuple((String)c12.name, (Json.JValue)j2), Json.tuple((String)c32.name, (Json.JValue)j3), Json.tuple((String)c42.name, (Json.JValue)j4), Json.tuple((String)c52.name, (Json.JValue)j5)})))))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, c1.name, c1);
                DecodeResult ob = DecodeResult.decode(object, c2.name, c2);
                DecodeResult oc = DecodeResult.decode(object, c3.name, c3);
                DecodeResult od = DecodeResult.decode(object, c4.name, c4);
                DecodeResult oe = DecodeResult.decode(object, c5.name, c5);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> od.flatMap((A d) -> oe.flatMap((A e) -> DecodeResult.ok(iso.reverseGet(new Tuple5(a, b, c, d, e))))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(c1.name, c1.toString());
                map.put(c2.name, c2.toString());
                map.put(c3.name, c3.toString());
                map.put(c4.name, c4.toString());
                map.put(c5.name, c5.toString());
                return "codec5" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C, D, E, F> JsonCodec<TT> codec6(final Iso<TT, Tuple6<A, B, C, D, E, F>> iso, final NamedJsonCodec<A> c1, final NamedJsonCodec<B> c2, final NamedJsonCodec<C> c3, final NamedJsonCodec<D> c4, final NamedJsonCodec<E> c5, final NamedJsonCodec<F> c6) {
        return new JsonCodec<TT>(){

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple6 tuple = (Tuple6)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> Option.of((Object)Json.jObject((Tuple2)Json.tuple((String)c12.name, (Json.JValue)j1), (Tuple2[])new Tuple2[]{Json.tuple((String)c22.name, (Json.JValue)j2), Json.tuple((String)c32.name, (Json.JValue)j3), Json.tuple((String)c42.name, (Json.JValue)j4), Json.tuple((String)c52.name, (Json.JValue)j5), Json.tuple((String)c62.name, (Json.JValue)j6)}))))))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, c1.name, c1);
                DecodeResult ob = DecodeResult.decode(object, c2.name, c2);
                DecodeResult oc = DecodeResult.decode(object, c3.name, c3);
                DecodeResult od = DecodeResult.decode(object, c4.name, c4);
                DecodeResult oe = DecodeResult.decode(object, c5.name, c5);
                DecodeResult of = DecodeResult.decode(object, c6.name, c6);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> od.flatMap((A d) -> oe.flatMap((A e) -> of.flatMap((A f) -> DecodeResult.ok(iso.reverseGet(new Tuple6(a, b, c, d, e, f)))))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(c1.name, c1.toString());
                map.put(c2.name, c2.toString());
                map.put(c3.name, c3.toString());
                map.put(c4.name, c4.toString());
                map.put(c5.name, c5.toString());
                map.put(c6.name, c6.toString());
                return "codec6" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G> JsonCodec<TT> codec7(final Iso<TT, Tuple7<A, B, C, D, E, F, G>> iso, final NamedJsonCodec<A> c1, final NamedJsonCodec<B> c2, final NamedJsonCodec<C> c3, final NamedJsonCodec<D> c4, final NamedJsonCodec<E> c5, final NamedJsonCodec<F> c6, final NamedJsonCodec<G> c7) {
        return new JsonCodec<TT>(){

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple7 tuple = (Tuple7)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).map(j7 -> Json.jObject((Tuple2)Json.tuple((String)c12.name, (Json.JValue)j1), (Tuple2[])new Tuple2[]{Json.tuple((String)c22.name, (Json.JValue)j2), Json.tuple((String)c32.name, (Json.JValue)j3), Json.tuple((String)c42.name, (Json.JValue)j4), Json.tuple((String)c52.name, (Json.JValue)j5), Json.tuple((String)c62.name, (Json.JValue)j6), Json.tuple((String)c72.name, (Json.JValue)j7)}))))))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, c1.name, c1);
                DecodeResult ob = DecodeResult.decode(object, c2.name, c2);
                DecodeResult oc = DecodeResult.decode(object, c3.name, c3);
                DecodeResult od = DecodeResult.decode(object, c4.name, c4);
                DecodeResult oe = DecodeResult.decode(object, c5.name, c5);
                DecodeResult of = DecodeResult.decode(object, c6.name, c6);
                DecodeResult og = DecodeResult.decode(object, c7.name, c7);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> od.flatMap((A d) -> oe.flatMap((A e) -> of.flatMap((A f) -> og.flatMap((A g) -> DecodeResult.ok(iso.reverseGet(new Tuple7(a, b, c, d, e, f, g))))))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(c1.name, c1.toString());
                map.put(c2.name, c2.toString());
                map.put(c3.name, c3.toString());
                map.put(c4.name, c4.toString());
                map.put(c5.name, c5.toString());
                map.put(c6.name, c6.toString());
                map.put(c7.name, c7.toString());
                return "codec7" + ((Object)map).toString();
            }
        };
    }

    public static <TT, A, B, C, D, E, F, G, H> JsonCodec<TT> codec8(final Iso<TT, Tuple8<A, B, C, D, E, F, G, H>> iso, final NamedJsonCodec<A> c1, final NamedJsonCodec<B> c2, final NamedJsonCodec<C> c3, final NamedJsonCodec<D> c4, final NamedJsonCodec<E> c5, final NamedJsonCodec<F> c6, final NamedJsonCodec<G> c7, final NamedJsonCodec<H> c8) {
        return new JsonCodec<TT>(){

            @Override
            public Option<Json.JValue> toJson(TT value) {
                Tuple8 tuple = (Tuple8)iso.get(value);
                return c1.toJson(tuple._1).flatMap(j1 -> c2.toJson(tuple._2).flatMap(j2 -> c3.toJson(tuple._3).flatMap(j3 -> c4.toJson(tuple._4).flatMap(j4 -> c5.toJson(tuple._5).flatMap(j5 -> c6.toJson(tuple._6).flatMap(j6 -> c7.toJson(tuple._7).flatMap(j7 -> c8.toJson(tuple._8).flatMap(j8 -> Option.of((Object)Json.jObject((Tuple2)Json.tuple((String)c12.name, (Json.JValue)j1), (Tuple2[])new Tuple2[]{Json.tuple((String)c22.name, (Json.JValue)j2), Json.tuple((String)c32.name, (Json.JValue)j3), Json.tuple((String)c42.name, (Json.JValue)j4), Json.tuple((String)c52.name, (Json.JValue)j5), Json.tuple((String)c62.name, (Json.JValue)j6), Json.tuple((String)c72.name, (Json.JValue)j7), Json.tuple((String)c82.name, (Json.JValue)j8)}))))))))));
            }

            @Override
            public DecodeResult<TT> fromJson(Json.JValue value) {
                Json.JObject object = value.asJsonObjectOrEmpty();
                DecodeResult<Object> oa = DecodeResult.decode(object, c1.name, c1);
                DecodeResult ob = DecodeResult.decode(object, c2.name, c2);
                DecodeResult oc = DecodeResult.decode(object, c3.name, c3);
                DecodeResult od = DecodeResult.decode(object, c4.name, c4);
                DecodeResult oe = DecodeResult.decode(object, c5.name, c5);
                DecodeResult of = DecodeResult.decode(object, c6.name, c6);
                DecodeResult og = DecodeResult.decode(object, c7.name, c7);
                DecodeResult oh = DecodeResult.decode(object, c8.name, c8);
                return oa.flatMap((A a) -> ob.flatMap((A b) -> oc.flatMap((A c) -> od.flatMap((A d) -> oe.flatMap((A e) -> of.flatMap((A f) -> og.flatMap((A g) -> oh.flatMap((A h) -> DecodeResult.ok(iso.reverseGet(new Tuple8(a, b, c, d, e, f, g, h)))))))))));
            }

            public String toString() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(c1.name, c1.toString());
                map.put(c2.name, c2.toString());
                map.put(c3.name, c3.toString());
                map.put(c4.name, c4.toString());
                map.put(c5.name, c5.toString());
                map.put(c6.name, c6.toString());
                map.put(c7.name, c7.toString());
                map.put(c8.name, c8.toString());
                return "codec8" + ((Object)map).toString();
            }
        };
    }
}

