/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec;

import java.util.function.Function;
import javaslang.control.Option;
import javaslang.control.Try;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.codec.DecodeResult;

public interface DecodeJson<A> {
    public DecodeResult<A> fromJson(Json.JValue var1);

    default public Option<A> defaultValue() {
        return Option.none();
    }

    default public A fromJsonUnsafe(Json.JValue value) {
        return (A)this.fromJson(value).toOption().getOrElse(null);
    }

    default public <B> DecodeJson<B> map(Function<A, B> f) {
        return json -> this.fromJson(json).map(f);
    }

    default public <B> DecodeJson<B> tryMap(Function<A, Try<B>> f) {
        return json -> this.fromJson(json).map(f).flatMap((A t) -> t.isSuccess() ? DecodeResult.ok(t.get()) : DecodeResult.fail(((Throwable)t.failed().get()).getMessage()));
    }

    default public <B> DecodeJson<B> flatMap(Function<A, DecodeJson<B>> f) {
        return value -> {
            DecodeResult<Object> result = this.fromJson(value);
            return result.flatMap((A a) -> ((DecodeJson)f.apply(a)).fromJson(value));
        };
    }

    default public DecodeJson<A> withDefaultValue(A defaultValue) {
        if (this instanceof DecodeJsonWithDefault) {
            return new DecodeJsonWithDefault(((DecodeJsonWithDefault)this).delegate, defaultValue);
        }
        return new DecodeJsonWithDefault<A>(this, defaultValue);
    }

    public static class DecodeJsonWithDefault<A>
    implements DecodeJson<A> {
        final DecodeJson<A> delegate;
        private final A defaultValue;

        public DecodeJsonWithDefault(DecodeJson<A> delegate, A defaultValue) {
            this.delegate = delegate;
            this.defaultValue = defaultValue;
        }

        @Override
        public DecodeResult<A> fromJson(Json.JValue value) {
            DecodeResult<A> res = this.delegate.fromJson(value);
            if (res.isFailure()) {
                return DecodeResult.ok(this.defaultValue);
            }
            return res;
        }

        @Override
        public Option<A> defaultValue() {
            return Option.some(this.defaultValue);
        }

        public String toString() {
            return this.getClass().getSimpleName() + String.format(" {delegate=%s, default=%s}", this.delegate, this.defaultValue);
        }
    }
}

