/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec;

import javaslang.control.Option;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.codec.DecodeJson;
import net.hamnaberg.json.codec.DecodeResult;
import net.hamnaberg.json.codec.EncodeJson;
import net.hamnaberg.json.codec.JsonCodec;

final class DefaultJsonCodec<A>
implements JsonCodec<A> {
    private final String toString;
    private final DecodeJson<A> decoder;
    private final EncodeJson<A> encoder;

    DefaultJsonCodec(DecodeJson<A> decoder, EncodeJson<A> encoder) {
        this(decoder, encoder, String.format("DefaultCodec(decoder=%s, encoder=%s)", decoder, encoder));
    }

    DefaultJsonCodec(DecodeJson<A> decoder, EncodeJson<A> encoder, String toString) {
        this.decoder = decoder;
        this.encoder = encoder;
        this.toString = toString;
    }

    @Override
    public DecodeResult<A> fromJson(Json.JValue value) {
        return this.decoder.fromJson(value);
    }

    @Override
    public Option<Json.JValue> toJson(A value) {
        return this.encoder.toJson(value);
    }

    @Override
    public Option<A> defaultValue() {
        return this.decoder.defaultValue();
    }

    public String toString() {
        return this.toString;
    }
}

