/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec;

import java.util.function.Function;
import net.hamnaberg.json.codec.IdIso;

public interface Iso<A, B> {
    public A reverseGet(B var1);

    public B get(A var1);

    default public Function<A, A> modify(Function<B, B> f) {
        return a -> this.reverseGet(f.apply(this.get(a)));
    }

    default public Iso<B, A> reverse() {
        final Iso that = this;
        return new Iso<B, A>(){

            @Override
            public B reverseGet(A a) {
                return that.get(a);
            }

            @Override
            public A get(B b) {
                return that.reverseGet(b);
            }
        };
    }

    default public <C> Iso<A, C> compose(final Iso<B, C> iso) {
        final Iso that = this;
        return new Iso<A, C>(){

            @Override
            public A reverseGet(C c) {
                return that.reverseGet(iso.reverseGet(c));
            }

            @Override
            public C get(A a) {
                return iso.get(that.get(a));
            }
        };
    }

    public static <A> Iso<A, A> identity() {
        return new IdIso();
    }
}

