/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.codec;

import java.util.function.Function;
import javaslang.control.Try;
import net.hamnaberg.json.codec.DecodeJson;
import net.hamnaberg.json.codec.DefaultJsonCodec;
import net.hamnaberg.json.codec.EncodeJson;
import net.hamnaberg.json.codec.NamedJsonCodec;

public interface JsonCodec<A>
extends EncodeJson<A>,
DecodeJson<A> {
    default public <B> JsonCodec<B> xmap(Function<A, B> f, Function<B, A> g) {
        return JsonCodec.lift(value -> this.fromJson(value).map(f), value -> this.toJson(g.apply(value)));
    }

    default public <B> JsonCodec<B> narrow(Function<A, Try<B>> f, Function<B, A> g) {
        return JsonCodec.lift(this.tryMap(f), value -> this.toJson(g.apply(value)));
    }

    default public <B> JsonCodec<B> narrowBoth(Function<A, Try<B>> f, Function<B, Try<A>> g) {
        return JsonCodec.lift(this.tryMap(f), value -> ((Try)g.apply(value)).toOption().flatMap(this::toJson));
    }

    default public <B> JsonCodec<B> tryNarrow(Function<A, B> f, Function<B, A> g) {
        return this.narrow(a -> Try.of(() -> f.apply(a)), g);
    }

    default public <B> JsonCodec<B> tryNarrowBoth(Function<A, B> f, Function<B, A> g) {
        return this.narrowBoth(a -> Try.of(() -> f.apply(a)), b -> Try.of(() -> g.apply(b)));
    }

    default public NamedJsonCodec<A> named(String name) {
        return NamedJsonCodec.of(name, this);
    }

    public static <A> JsonCodec<A> lift(DecodeJson<A> decoder, EncodeJson<A> encoder) {
        return new DefaultJsonCodec<A>(decoder, encoder);
    }
}

