/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.extract;

import java.util.function.Function;
import javaslang.Value;
import javaslang.collection.List;
import javaslang.control.Option;
import javaslang.control.Try;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.codec.Codecs;
import net.hamnaberg.json.codec.DecodeJson;
import net.hamnaberg.json.codec.DecodeResult;
import net.hamnaberg.json.extract.Extractor;

public abstract class TypedField<A> {
    public final String name;
    public final DecodeJson<A> decoder;

    private TypedField(String name, DecodeJson<A> decoder) {
        this.name = name;
        this.decoder = decoder;
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.name);
    }

    public <B> TypedField<B> map(Function<A, B> f) {
        return TypedField.typedFieldOf(this.name, this.decoder.map(f), Option.none());
    }

    public <B> TypedField<B> flatMap(Function<A, TypedField<B>> f) {
        DecodeJson bdecoder = json -> this.decoder.flatMap((A a) -> ((TypedField)f.apply(a)).decoder).fromJson(json);
        return TypedField.typedFieldOf(this.name, bdecoder, Option.none());
    }

    public <B> TypedField<B> narrow(Function<A, Try<B>> f) {
        return TypedField.typedFieldOf(this.name, json -> this.decoder.fromJson(json).flatMap((A a) -> DecodeResult.fromOption(((Try)f.apply(a)).toOption())), Option.none());
    }

    public <B> TypedField<B> tryNarrow(Function<A, B> f) {
        return this.narrow(a -> Try.of(() -> f.apply(a)));
    }

    public TypedField<A> withDefaultValue(A defaultValue) {
        return TypedField.typedFieldOf(this.name, this.decoder, Option.some(defaultValue));
    }

    public static TypedField<String> TString(String name) {
        return TypedField.typedFieldOf(name, Codecs.StringCodec, Option.none());
    }

    public static TypedField<Integer> TInt(String name) {
        return TypedField.typedFieldOf(name, Codecs.intCodec, Option.none());
    }

    public static TypedField<Double> TDouble(String name) {
        return TypedField.typedFieldOf(name, Codecs.doubleCodec, Option.none());
    }

    public static TypedField<Long> TLong(String name) {
        return TypedField.typedFieldOf(name, Codecs.longCodec, Option.none());
    }

    public static TypedField<Boolean> TBoolean(String name) {
        return TypedField.typedFieldOf(name, Codecs.booleanCodec, Option.none());
    }

    public static TJArrayField TJArray(String name) {
        return new TJArrayField(name);
    }

    public static TJObjectField TJObject(String name) {
        return new TJObjectField(name);
    }

    public static <B> TypedField<Option<B>> TOptional(String name, Extractor<B> extractor) {
        return TypedField.TOptional(name, extractor.decoder());
    }

    public static <B> TypedField<Option<B>> TOptional(String name, DecodeJson<B> decoder) {
        return TypedField.typedFieldOf(name, json -> DecodeResult.ok(decoder.fromJson(json).toOption()), Option.some((Object)Option.none()));
    }

    public static <B> TypedField<B> typedFieldOf(String name, DecodeJson<B> decoder, Option<B> defaultValue) {
        return new TypedField<B>(name, (DecodeJson)defaultValue.map(decoder::withDefaultValue).getOrElse(decoder)){};
    }

    public static class TJObjectField
    extends TypedField<Json.JObject> {
        public TJObjectField(String name) {
            super(name, v -> DecodeResult.fromOption(v.asJsonObject()));
        }

        public <B> TypedField<B> extractTo(Extractor<B> mapper) {
            return TJObjectField.typedFieldOf(this.name, json -> (DecodeResult)mapper.apply(json.asJsonObjectOrEmpty()), Option.none());
        }
    }

    public static class TJArrayField
    extends TypedField<Json.JArray> {
        public TJArrayField(String name) {
            super(name, v -> DecodeResult.fromOption(v.asJsonArray()));
        }

        public <B> TypedField<List<B>> mapToList(Function<Json.JValue, B> f) {
            return TJArrayField.typedFieldOf(this.name, this.decoder.map(ja -> ja.mapToList(f)), Option.none());
        }

        public <B> TypedField<List<B>> mapToOptionalList(Function<Json.JValue, Option<B>> f) {
            return TJArrayField.typedFieldOf(this.name, this.decoder.map(ja -> ja.flatMapToList(f.andThen(Value::toList))), Option.none());
        }
    }
}

