/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.io;

import java.io.InputStream;
import java.util.Optional;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.io.JsonParser;
import net.hamnaberg.json.pointer.JsonPointer;
import org.junit.Assert;
import org.junit.Test;

public abstract class JsonParserAbstractTest {
    @Test
    public void parseItemsJson() throws Exception {
        InputStream stream = this.getClass().getResourceAsStream("/items.json");
        Assert.assertNotNull((String)"Stream was null", (Object)stream);
        Json.JValue parsed = this.getParser().parse(stream);
        Optional firstLink = parsed.asJsonObjectOrEmpty().getOrDefault("collection", (Json.JValue)Json.jEmptyObject()).asJsonObjectOrEmpty().get("links").flatMap(j2 -> j2.asJsonArrayOrEmpty().headOption());
        Optional relValue = firstLink.flatMap(j -> j.asJsonObjectOrEmpty().get("rel"));
        Assert.assertTrue((boolean)relValue.isPresent());
        relValue.ifPresent(v -> Assert.assertEquals((Object)Json.jString((String)"feed"), (Object)v));
        Optional value = JsonPointer.compile((String)"/collection/links/0/rel").select(parsed);
        Assert.assertTrue((boolean)value.isPresent());
        value.ifPresent(v -> Assert.assertEquals((Object)Json.jString((String)"feed"), (Object)v));
        value = JsonPointer.compile((String)"/collection/href").select(parsed);
        Assert.assertTrue((boolean)value.isPresent());
        Assert.assertEquals((Object)Json.jString((String)"http://example.org/friends/"), value.get());
    }

    protected abstract JsonParser getParser();
}

