/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javaslang.control.Option;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.io.JsonParseException;

public abstract class JsonParser {
    public final Json.JValue parse(InputStream is) {
        return this.parse(new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)));
    }

    public final Json.JValue parse(String string) {
        return this.parse(new StringReader(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Json.JValue parse(Reader reader) {
        BufferedReader buf = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try (BufferedReader r = buf;){
            Json.JValue jValue = this.parseImpl(r);
            return jValue;
        }
        catch (Exception e) {
            throw new JsonParseException(e);
        }
    }

    public Option<Json.JValue> parseOpt(InputStream is) {
        return this.parseOpt(is, this::parse);
    }

    public Option<Json.JValue> parseOpt(String string) {
        return this.parseOpt(string, this::parse);
    }

    public Option<Json.JValue> parseOpt(Reader reader) {
        return this.parseOpt(reader, this::parse);
    }

    private <A> Option<Json.JValue> parseOpt(A input, Function<A, Json.JValue> f) {
        try {
            return Option.of((Object)f.apply(input));
        }
        catch (JsonParseException e) {
            return Option.none();
        }
    }

    protected abstract Json.JValue parseImpl(Reader var1) throws Exception;
}

