/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.PrettyPrinter;
import net.hamnaberg.json.io.JsonWriteException;

public enum JsonSerializer {


    public static void write(Json.JValue value, OutputStream stream) {
        JsonSerializer.write(value, new OutputStreamWriter(stream, StandardCharsets.UTF_8));
    }

    public static String writeToString(Json.JValue value, PrettyPrinter pretty) {
        return value.pretty(pretty);
    }

    public static String writeToString(Json.JValue value) {
        return JsonSerializer.writeToString(value, PrettyPrinter.nospaces());
    }

    public static void write(Json.JValue value, Writer writer) {
        JsonSerializer.write(value, writer, PrettyPrinter.nospaces());
    }

    public static void write(Json.JValue value, Writer writer, PrettyPrinter printer) {
        BufferedWriter buffer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        try {
            buffer.write(value.pretty(printer));
            buffer.flush();
        }
        catch (IOException e) {
            throw new JsonWriteException(e);
        }
    }
}

