/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.Callable;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.codec.DecodeJson;
import net.hamnaberg.json.codec.DecodeResult;

public abstract class JsonParser {
    public final Json.JValue parseUnsafe(ReadableByteChannel channel) {
        return this.parseUnsafe(Channels.newInputStream(channel));
    }

    public final Json.JValue parseUnsafe(InputStream is) {
        return this.parseUnsafe(new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)));
    }

    public final Json.JValue parseUnsafe(byte[] bytes) {
        return this.parseUnsafe(new ByteArrayInputStream(bytes));
    }

    public final Json.JValue parseUnsafe(String string) {
        return this.parseUnsafe(new StringReader(string));
    }

    public final Json.JValue parseUnsafe(Reader reader) {
        return this.parseImpl(reader);
    }

    public final Optional<Json.JValue> parseOpt(ReadableByteChannel channel) {
        return this.parseOpt(Channels.newInputStream(channel));
    }

    public final Optional<Json.JValue> parseOpt(byte[] bytes) {
        return this.parseOpt(new ByteArrayInputStream(bytes));
    }

    public final Optional<Json.JValue> parseOpt(InputStream is) {
        return this.parseOpt(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public final Optional<Json.JValue> parseOpt(String string) {
        return this.parseOpt(new StringReader(string));
    }

    public final Optional<Json.JValue> parseOpt(Reader reader) {
        return DecodeResult.fromCallable(() -> this.parseImpl(reader)).toOption();
    }

    public final <A> DecodeResult<A> decode(ReadableByteChannel is, DecodeJson<A> decoder) {
        return this.decode(() -> this.parseUnsafe(is), decoder);
    }

    public final <A> DecodeResult<A> decode(byte[] bytes, DecodeJson<A> decoder) {
        return this.decode(() -> this.parseUnsafe(bytes), decoder);
    }

    public final <A> DecodeResult<A> decode(InputStream is, DecodeJson<A> decoder) {
        return this.decode(() -> this.parseUnsafe(is), decoder);
    }

    public final <A> DecodeResult<A> decode(String string, DecodeJson<A> decoder) {
        return this.decode(() -> this.parseUnsafe(string), decoder);
    }

    public final <A> DecodeResult<A> decode(Reader reader, DecodeJson<A> decoder) {
        return this.decode(() -> this.parseUnsafe(reader), decoder);
    }

    public final <A> DecodeResult<A> decode(Callable<Json.JValue> parsed, DecodeJson<A> decoder) {
        return DecodeResult.fromCallable(parsed).flatMap(arg_0 -> decoder.fromJson(arg_0));
    }

    protected abstract Json.JValue parseImpl(Reader var1);
}

