/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.io.JsonParseException;

public final class JacksonStreamingParser
extends net.hamnaberg.json.io.JsonParser {
    private final JsonFactory factory = new JsonFactory();

    protected Try<Json.JValue> parseImpl(Reader reader) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            JsonToken token;
            JsonParser parser = this.factory.createParser(reader);
            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.START_OBJECT) {
                    return this.handleObject(parser);
                }
                if (token == JsonToken.START_ARRAY) {
                    return this.handleArray(parser);
                }
                if (!token.isScalarValue()) continue;
                return this.handleScalarValue(parser);
            }
            throw new JsonParseException("Nothing parsed");
        });
    }

    private Json.JObject handleObject(JsonParser parser) throws Exception {
        String fieldName;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        while ((fieldName = parser.nextFieldName()) != null) {
            JsonToken token = parser.nextValue();
            if (token.isScalarValue()) {
                map.put(fieldName, this.handleScalarValue(parser));
                continue;
            }
            if (token == JsonToken.START_ARRAY) {
                map.put(fieldName, this.handleArray(parser));
                continue;
            }
            if (token != JsonToken.START_OBJECT) continue;
            map.put(fieldName, this.handleObject(parser));
        }
        return Json.jObject(map);
    }

    private Json.JValue handleArray(JsonParser parser) throws Exception {
        JsonToken token;
        ArrayList<Object> values = new ArrayList<Object>();
        while ((token = parser.nextToken()) != JsonToken.END_ARRAY) {
            if (token.isScalarValue()) {
                values.add(this.handleScalarValue(parser));
                continue;
            }
            if (token == JsonToken.START_ARRAY) {
                values.add(this.handleArray(parser));
                continue;
            }
            if (token != JsonToken.START_OBJECT) continue;
            values.add(this.handleObject(parser));
        }
        return Json.jArray(values);
    }

    private Json.JValue handleScalarValue(JsonParser parser) throws Exception {
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.VALUE_STRING) {
            return Json.jString((String)parser.getValueAsString());
        }
        if (token.isNumeric()) {
            return Json.jNumber((BigDecimal)parser.getDecimalValue());
        }
        if (token.isBoolean()) {
            return Json.jBoolean((boolean)parser.getBooleanValue());
        }
        return Json.jNull();
    }
}

