/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.javax;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import javax.json.stream.JsonParser;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.io.JsonParseException;

public final class JavaxJsonParser
extends net.hamnaberg.json.io.JsonParser {
    private final EnumSet<JsonParser.Event> scalarSet = EnumSet.of(JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_NULL);

    protected Json.JValue parseImpl(Reader reader) {
        JsonParser parser = javax.json.Json.createParser((Reader)reader);
        try {
            JsonParser.Event event;
            while ((event = parser.next()) != null) {
                if (event == JsonParser.Event.START_OBJECT) {
                    return this.handleObject(parser);
                }
                if (event == JsonParser.Event.START_ARRAY) {
                    return this.handleArray(parser);
                }
                if (!this.isScalar(event)) continue;
                return this.handleScalarValue(event, parser);
            }
        }
        catch (Exception e) {
            throw new JsonParseException((Throwable)e);
        }
        throw new JsonParseException("Nothing parsed");
    }

    private Json.JValue handleScalarValue(JsonParser.Event event, JsonParser parser) {
        switch (event) {
            case VALUE_STRING: {
                return Json.jString((String)parser.getString());
            }
            case VALUE_NUMBER: {
                return Json.jNumber((BigDecimal)parser.getBigDecimal());
            }
            case VALUE_TRUE: {
                return Json.jBoolean((boolean)true);
            }
            case VALUE_FALSE: {
                return Json.jBoolean((boolean)false);
            }
            case VALUE_NULL: {
                return Json.jNull();
            }
        }
        throw new IllegalArgumentException("Not a scalar value " + event);
    }

    private boolean isScalar(JsonParser.Event event) {
        return this.scalarSet.contains(event);
    }

    private Json.JArray handleArray(JsonParser parser) {
        JsonParser.Event event;
        ArrayList<Object> list = new ArrayList<Object>();
        while ((event = parser.next()) != JsonParser.Event.END_ARRAY) {
            if (this.isScalar(event)) {
                list.add(this.handleScalarValue(event, parser));
                continue;
            }
            if (event == JsonParser.Event.START_OBJECT) {
                list.add(this.handleObject(parser));
                continue;
            }
            if (event != JsonParser.Event.START_ARRAY) continue;
            list.add(this.handleArray(parser));
        }
        return Json.jArray(list);
    }

    private Json.JObject handleObject(JsonParser parser) {
        JsonParser.Event event;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        String name = null;
        while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
            if (event == JsonParser.Event.KEY_NAME) {
                name = parser.getString();
            }
            if (name == null) continue;
            if (this.isScalar(event)) {
                map.put(name, this.handleScalarValue(event, parser));
                continue;
            }
            if (event == JsonParser.Event.START_OBJECT) {
                map.put(name, this.handleObject(parser));
                continue;
            }
            if (event != JsonParser.Event.START_ARRAY) continue;
            map.put(name, this.handleArray(parser));
        }
        return Json.jObject(map);
    }
}

