/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.pointer;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javaslang.control.Option;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.pointer.JsonPointerParser;
import net.hamnaberg.json.pointer.Ref;

public final class JsonPointer {
    private final List<Ref> path;

    public static JsonPointer compile(String pattern) {
        if (pattern == null || pattern.trim().isEmpty()) {
            return new JsonPointer(Collections.emptyList());
        }
        return new JsonPointer(new JsonPointerParser().parse(pattern));
    }

    private JsonPointer(List<Ref> path) {
        this.path = Collections.unmodifiableList(path);
    }

    public String toString() {
        if (this.path.isEmpty()) {
            return "";
        }
        return this.path.stream().map(ref -> ref.fold(r -> String.valueOf(r.index), r -> this.escape(r.name), () -> "-")).collect(Collectors.joining("/", "/", ""));
    }

    private String escape(String str) {
        return str.replace("~", "~0").replace("/", "~1");
    }

    public Option<Json.JValue> select(Json.JValue value) {
        if (this.path.isEmpty()) {
            return Option.of((Object)value);
        }
        Iterator<Ref> iterator = this.path.iterator();
        Json.JValue current = value;
        while (iterator.hasNext()) {
            Ref ref = iterator.next();
            Json.JValue c = current;
            current = ref.fold(arrayRef -> this.foldToJson(c, obj -> (Json.JValue)obj.get(String.valueOf(arrayRef.index)).getOrElse(obj), arr -> (Json.JValue)arr.get(arrayRef.index).getOrElse(arr)), propertyRef -> this.foldToJson(c, obj -> (Json.JValue)obj.get(String.valueOf(propertyRef.name)).getOrElse(obj), Json.JValue::asJValue), () -> {
                throw new IllegalStateException("List index is out-of-bounds");
            });
            if (iterator.hasNext() || current == value) continue;
            return Option.of((Object)current);
        }
        return Option.none();
    }

    public Json.JValue add(Json.JValue json, Json.JValue value) {
        if (this.path.isEmpty()) {
            return value;
        }
        Iterator<Ref> iterator = this.path.iterator();
        return this.addImpl(iterator, iterator.next(), json, value);
    }

    public Json.JValue remove(Json.JValue json) {
        if (this.path.isEmpty()) {
            return json;
        }
        Iterator<Ref> iterator = this.path.iterator();
        return this.updateImpl(iterator, iterator.next(), json, (Option<Json.JValue>)Option.none());
    }

    public Json.JValue replace(Json.JValue json, Json.JValue value) {
        if (this.path.isEmpty()) {
            return value;
        }
        Iterator<Ref> iterator = this.path.iterator();
        return this.updateImpl(iterator, iterator.next(), json, (Option<Json.JValue>)Option.of((Object)value));
    }

    public Json.JValue copy(Json.JValue json, JsonPointer from) {
        Option<Json.JValue> selected = from.select(json);
        return (Json.JValue)selected.map(v -> this.add(json, (Json.JValue)v)).getOrElse((Object)json);
    }

    public Json.JValue move(Json.JValue json, JsonPointer from) {
        Option<Json.JValue> selected = from.select(json);
        return (Json.JValue)selected.map(v -> this.add(from.remove(json), (Json.JValue)v)).getOrElse((Object)json);
    }

    public boolean test(Json.JValue json, Json.JValue value) {
        return (Boolean)this.select(json).map(arg_0 -> ((Json.JValue)value).equals(arg_0)).getOrElse((Object)false);
    }

    private Json.JValue foldToJson(Json.JValue value, Function<Json.JObject, Json.JValue> fObject, Function<Json.JArray, Json.JValue> fArray) {
        return (Json.JValue)value.fold(Json.JValue::asJValue, Json.JValue::asJValue, Json.JValue::asJValue, fObject, fArray, Json::jNull);
    }

    private Json.JValue updateImpl(Iterator<Ref> path, Ref ref, Json.JValue context, Option<Json.JValue> updateValue) {
        return ref.fold(arrayRef -> this.foldToJson(context, obj -> this.replaceObject(path, context, updateValue, String.valueOf(arrayRef.index)), arr -> {
            int index = arrayRef.index;
            Json.JArray array = context.asJsonArrayOrEmpty();
            if (!path.hasNext()) {
                if (updateValue.isDefined()) {
                    array.get(index).getOrElseThrow(() -> new IllegalStateException("No value at index: " + index));
                    return array.replace(index, (Json.JValue)updateValue.get());
                }
                return array.remove(index);
            }
            Json.JValue value = (Json.JValue)array.get(index).getOrElseThrow(() -> new IllegalStateException("No value at index: " + index));
            return array.replace(index, this.updateImpl(path, (Ref)path.next(), value, updateValue));
        }), propertyRef -> this.foldToJson(context, obj -> this.replaceObject(path, context, updateValue, propertyRef.name), Json.JValue::asJValue), () -> {
            throw new IllegalStateException("List index is out-of-bounds");
        });
    }

    private Json.JValue replaceObject(Iterator<Ref> path, Json.JValue context, Option<Json.JValue> updateValue, String name) {
        Json.JObject object = context.asJsonObjectOrEmpty();
        if (!path.hasNext()) {
            if (updateValue.isDefined()) {
                return object.put(name, (Json.JValue)updateValue.get());
            }
            return object.remove(name);
        }
        Json.JValue value = (Json.JValue)object.get(name).getOrElseThrow(() -> new IllegalStateException("No value with name: " + name));
        return object.put(name, this.updateImpl(path, path.next(), value, updateValue));
    }

    private Json.JValue addImpl(Iterator<Ref> path, Ref ref, Json.JValue context, Json.JValue valueToInsert) {
        return ref.fold(arrayRef -> this.foldToJson(context, obj -> {
            String name = String.valueOf(arrayRef.index);
            return this.addObject(path, (Json.JValue)obj, valueToInsert, name);
        }, arr -> {
            int index = arrayRef.index;
            if (!path.hasNext()) {
                if (arr.size() >= index) {
                    return arr.insert(index, valueToInsert);
                }
                throw new IllegalStateException(String.format("List index %s is out-of-bounds", index));
            }
            Json.JValue value = (Json.JValue)arr.get(index).getOrElseThrow(() -> new IllegalStateException(String.format("List index %s is out-of-bounds", index)));
            return arr.replace(index, this.addImpl(path, (Ref)path.next(), value, valueToInsert));
        }), propertyRef -> this.foldToJson(context, obj -> this.addObject(path, (Json.JValue)obj, valueToInsert, propertyRef.name), Json.JValue::asJValue), () -> this.foldToJson(context, j -> j, arr -> {
            if (path.hasNext()) {
                throw new IllegalStateException("Nonsense to have more values after a end-of-array");
            }
            return arr.append(valueToInsert);
        }));
    }

    private Json.JValue addObject(Iterator<Ref> path, Json.JValue context, Json.JValue valueToInsert, String name) {
        Json.JObject object = context.asJsonObjectOrEmpty();
        if (!path.hasNext()) {
            return object.put(name, valueToInsert);
        }
        Json.JValue value = (Json.JValue)object.get(name).getOrElseThrow(() -> new IllegalStateException("No value with name: " + name));
        return object.put(name, this.addImpl(path, path.next(), value, valueToInsert));
    }
}

