/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.pointer;

import java.util.ArrayList;
import java.util.List;
import net.hamnaberg.json.pointer.ArrayRef;
import net.hamnaberg.json.pointer.EndOfArray;
import net.hamnaberg.json.pointer.PropertyRef;
import net.hamnaberg.json.pointer.Ref;

class JsonPointerParser {
    JsonPointerParser() {
    }

    List<Ref> parse(String s) {
        List<String> list = this.clean((s.startsWith("/") ? s.substring(1) : s).split("/"));
        return this.parse(list);
    }

    List<Ref> parse(List<String> parts) {
        ArrayList<Ref> path = new ArrayList<Ref>(parts.size());
        for (String p : parts) {
            if (p.equals("-")) {
                path.add(EndOfArray.INSTANCE);
                continue;
            }
            if (ArrayRef.pattern.matcher(p).matches()) {
                path.add(new ArrayRef(Integer.parseInt(p)));
                continue;
            }
            path.add(new PropertyRef(p));
        }
        return path;
    }

    private List<String> clean(String[] split) {
        ArrayList<String> list = new ArrayList<String>(split.length);
        for (String s : split) {
            list.add(this.unescape(s));
        }
        return list;
    }

    private String unescape(String str) {
        return str.replace("~1", "/").replace("~0", "~");
    }
}

