/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.json.pointer;

import java.util.Iterator;
import javaslang.collection.List;
import javaslang.collection.Seq;
import javaslang.control.Option;
import net.hamnaberg.json.Json;
import net.hamnaberg.json.pointer.ArrayRef;
import net.hamnaberg.json.pointer.EndOfArray;
import net.hamnaberg.json.pointer.JsonPointerParser;
import net.hamnaberg.json.pointer.PropertyRef;
import net.hamnaberg.json.pointer.Ref;

public final class JsonPointer {
    private final Seq<Ref> path;

    public static JsonPointer compile(String pattern) {
        if (pattern == null || pattern.trim().isEmpty()) {
            return new JsonPointer((Seq<Ref>)List.nil());
        }
        return new JsonPointer((Seq<Ref>)new JsonPointerParser().parse(pattern));
    }

    private JsonPointer(Seq<Ref> path) {
        this.path = path;
    }

    public Option<Json.JValue> select(Json.JValue value) {
        if (this.path.isEmpty()) {
            return Option.of((Object)value);
        }
        Iterator iterator = this.path.iterator();
        Json.JValue current = value;
        while (iterator.hasNext()) {
            Ref ref = (Ref)iterator.next();
            if (ref instanceof ArrayRef && current instanceof Json.JArray) {
                int idx = ((ArrayRef)ref).index;
                Seq list = current.asJsonArrayOrEmpty().getValue();
                if (idx < list.length()) {
                    current = (Json.JValue)list.get(idx);
                }
            } else if (ref instanceof PropertyRef && current instanceof Json.JObject) {
                String name = ((PropertyRef)ref).name;
                Json.JObject object = current.asJsonObjectOrEmpty();
                Option maybeValue = object.get(name);
                if (maybeValue.isDefined()) {
                    current = (Json.JValue)maybeValue.get();
                }
            } else if (ref instanceof EndOfArray) {
                throw new IllegalStateException("List index is out-of-bounds");
            }
            if (iterator.hasNext() || current == value) continue;
            return Option.of((Object)current);
        }
        return Option.none();
    }
}

