/*
 * Decompiled with CFR 0.152.
 */
package net.jakubholy.jeeutils.jsfelcheck.beanfinder.jsf12;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ResourceBundle;
import javax.faces.context.ExternalContext;
import net.jakubholy.jeeutils.jsfelcheck.beanfinder.AbstractFacesConfigXmlBeanFinder;
import net.jakubholy.jeeutils.jsfelcheck.beanfinder.InputResource;
import net.jakubholy.jeeutils.jsfelcheck.beanfinder.ManagedBeanFinder;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.config.impl.digester.elements.Application;
import org.apache.myfaces.config.impl.digester.elements.FacesConfig;
import org.apache.myfaces.config.impl.digester.elements.ManagedBean;
import org.mockito.Mockito;
import org.xml.sax.SAXException;

public class Jsf12FacesConfigXmlBeanFinder
extends AbstractFacesConfigXmlBeanFinder {
    private final ExternalContext externalContext = (ExternalContext)Mockito.mock(ExternalContext.class);

    public static ManagedBeanFinder forResources(Collection<InputResource> facesConfigResources) {
        return new Jsf12FacesConfigXmlBeanFinder().setFacesConfigResources(facesConfigResources);
    }

    Jsf12FacesConfigXmlBeanFinder() {
    }

    protected Collection<ManagedBeanFinder.ManagedBeanDescriptor> parseFacesConfig(InputStream stream) {
        try {
            FacesConfig facesConfig = (FacesConfig)this.getUnmarshaller().getFacesConfig(stream, stream.toString());
            stream.close();
            Collection<ManagedBeanFinder.ManagedBeanDescriptor> managedBeans = this.toManagedBeanDescriptors(facesConfig.getManagedBeans());
            this.extractResourceBundleVarsInto(managedBeans, facesConfig);
            return managedBeans;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to access the faces-config xml from " + stream, e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to parse the faces-config xml from " + stream, e);
        }
    }

    private void extractResourceBundleVarsInto(Collection<ManagedBeanFinder.ManagedBeanDescriptor> managedBeans, FacesConfig facesConfig) {
        for (Application application : facesConfig.getApplications()) {
            for (org.apache.myfaces.config.impl.digester.elements.ResourceBundle resourceBundle : application.getResourceBundle()) {
                managedBeans.add(new ManagedBeanFinder.ManagedBeanDescriptor(resourceBundle.getVar(), ResourceBundle.class));
            }
        }
    }

    private Collection<ManagedBeanFinder.ManagedBeanDescriptor> toManagedBeanDescriptors(Collection<ManagedBean> managedBeans) {
        LinkedList<ManagedBeanFinder.ManagedBeanDescriptor> descriptors = new LinkedList<ManagedBeanFinder.ManagedBeanDescriptor>();
        for (ManagedBean managedBean : managedBeans) {
            descriptors.add(new ManagedBeanFinder.ManagedBeanDescriptor(managedBean.getManagedBeanName(), managedBean.getManagedBeanClass()));
        }
        return descriptors;
    }

    private FacesConfigUnmarshaller<FacesConfig> getUnmarshaller() {
        return new DigesterFacesConfigUnmarshallerImpl(this.externalContext);
    }
}

