/*
 * Decompiled with CFR 0.152.
 */
package net.jakubholy.jeeutils.jsfelcheck.validator.jsf12;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import net.jakubholy.jeeutils.jsfelcheck.validator.AttributeInfo;
import net.jakubholy.jeeutils.jsfelcheck.validator.ElExpressionFilter;
import net.jakubholy.jeeutils.jsfelcheck.validator.ElVariableResolver;
import net.jakubholy.jeeutils.jsfelcheck.validator.JsfElValidator;
import net.jakubholy.jeeutils.jsfelcheck.validator.ValidatingElResolver;
import net.jakubholy.jeeutils.jsfelcheck.validator.ValidationResultHelper;
import net.jakubholy.jeeutils.jsfelcheck.validator.exception.BaseEvaluationException;
import net.jakubholy.jeeutils.jsfelcheck.validator.exception.InvalidExpressionException;
import net.jakubholy.jeeutils.jsfelcheck.validator.jsf12.MethodFakingFunctionMapper;
import net.jakubholy.jeeutils.jsfelcheck.validator.jsf12.ValidatingFakeValueResolver;
import net.jakubholy.jeeutils.jsfelcheck.validator.results.FailedValidationResult;
import net.jakubholy.jeeutils.jsfelcheck.validator.results.SuccessfulValidationResult;
import net.jakubholy.jeeutils.jsfelcheck.validator.results.ValidationResult;
import org.apache.el.ExpressionFactoryImpl;
import org.apache.myfaces.el.unified.FacesELContext;
import org.mockito.Mockito;

public class Jsf12ValidatingElResolver
implements ValidatingElResolver {
    private static final Logger LOG = Logger.getLogger(Jsf12ValidatingElResolver.class.getName());
    private static final Class<?>[] NO_PARAMS = new Class[0];
    public static final Pattern RE_LAST_EL_PROPERTY = Pattern.compile("\\.(?!\\d)((?:\\p{L}|[0-9_$])+)\\s*\\}");
    private final MethodFakingFunctionMapper functionMapper = new MethodFakingFunctionMapper();
    private ValidatingFakeValueResolver validatingResolver;
    private ExpressionFactory expressionFactory = new ExpressionFactoryImpl();
    private FacesContext context;
    private ELContext elContext;

    public Jsf12ValidatingElResolver() {
        Map emptyMap = Collections.emptyMap();
        ExternalContext externalContextMock = (ExternalContext)Mockito.mock(ExternalContext.class);
        Mockito.when((Object)externalContextMock.getApplicationMap()).thenReturn(emptyMap);
        Mockito.when((Object)externalContextMock.getRequestMap()).thenReturn(emptyMap);
        Mockito.when((Object)externalContextMock.getSessionMap()).thenReturn(emptyMap);
        this.context = (FacesContext)Mockito.mock(FacesContext.class);
        Mockito.when((Object)this.context.getExternalContext()).thenReturn((Object)externalContextMock);
        FacesELContext facesELContext = new FacesELContext(this.buildElResolver(), this.context);
        facesELContext.setFunctionMapper((FunctionMapper)this.functionMapper);
        this.elContext = facesELContext;
    }

    private ELResolver buildElResolver() {
        CompositeELResolver elResolver = new CompositeELResolver();
        this.validatingResolver = new ValidatingFakeValueResolver(elResolver);
        elResolver.add((ELResolver)this.validatingResolver);
        elResolver.add((ELResolver)new ResourceBundleELResolver());
        elResolver.add((ELResolver)new MapELResolver());
        elResolver.add((ELResolver)new ListELResolver());
        elResolver.add((ELResolver)new ArrayELResolver());
        elResolver.add((ELResolver)new BeanELResolver());
        return elResolver;
    }

    public ValidationResult validateElExpression(String elExpression, AttributeInfo attributeInfo) {
        boolean attributeTypedAsMethod = MethodExpression.class.isAssignableFrom(attributeInfo.getAttributeType());
        boolean attributeTypedAsValue = ValueExpression.class.isAssignableFrom(attributeInfo.getAttributeType());
        if (attributeTypedAsMethod) {
            return this.validateMethodElExpression(elExpression, true);
        }
        if (attributeTypedAsValue) {
            return this.validateValueElExpression(elExpression);
        }
        ValidationResult validationResult = this.validateValueElExpression(elExpression);
        if (this.isPropertyNotFoundFailure(validationResult)) {
            return this.tryValidateAsMethodAfterValueFailed(elExpression, validationResult);
        }
        return validationResult;
    }

    private boolean isPropertyNotFoundFailure(ValidationResult validationResult) {
        if (validationResult instanceof FailedValidationResult) {
            InvalidExpressionException failure = ((FailedValidationResult)validationResult).getFailure();
            return failure.getCause() != null && failure.getCause() instanceof net.jakubholy.jeeutils.jsfelcheck.validator.exception.PropertyNotFoundException;
        }
        return false;
    }

    private ValidationResult tryValidateAsMethodAfterValueFailed(String elExpression, ValidationResult validationResult) {
        String methodValidationFailure = null;
        try {
            ValidationResult methodResult = this.validateMethodElExpression(elExpression, false);
            if (!methodResult.hasErrors()) {
                return methodResult;
            }
            methodValidationFailure = methodResult.toString();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        LOG.info("tryValidateAsMethodAfterValueFailed: '" + elExpression + "' is neither valid ValueExpression nor " + "MethodExpression. Method validation failure: " + methodValidationFailure);
        return validationResult;
    }

    private ValidationResult validateValueElExpression(String elExpression) {
        this.functionMapper.setCurrentExpression(elExpression);
        ValueExpression valueExpression = this.expressionFactory.createValueExpression(this.elContext, elExpression, Object.class);
        try {
            Object resolvedMockedValue = valueExpression.getValue(this.elContext);
            return new SuccessfulValidationResult(elExpression, resolvedMockedValue).withFunctionsInExpression(this.functionMapper.getLastExpressionsFunctionQNames());
        }
        catch (ELException e) {
            return ValidationResultHelper.produceFailureResult((String)elExpression, (Exception)((Object)e));
        }
        catch (BaseEvaluationException e) {
            return ValidationResultHelper.produceFailureResult((String)elExpression, (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            throw ValidationResultHelper.wrapIfNeededAndAddContext((String)elExpression, (RuntimeException)e);
        }
    }

    private ValidationResult validateMethodElExpression(String elExpression, boolean ignoreAssertFailure) {
        this.functionMapper.setCurrentExpression(elExpression);
        try {
            MethodExpression methodExpression = this.expressionFactory.createMethodExpression(this.elContext, elExpression, Object.class, (Class[])NO_PARAMS);
            this.assertMethodExists(elExpression, ignoreAssertFailure);
            return new SuccessfulValidationResult(elExpression, (Object)methodExpression).withFunctionsInExpression(this.functionMapper.getLastExpressionsFunctionQNames());
        }
        catch (ELException e) {
            return ValidationResultHelper.produceFailureResult((String)elExpression, (Exception)((Object)e));
        }
        catch (BaseEvaluationException e) {
            return ValidationResultHelper.produceFailureResult((String)elExpression, (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            throw ValidationResultHelper.wrapIfNeededAndAddContext((String)elExpression, (RuntimeException)e);
        }
    }

    private void assertMethodExists(String methodExpression, boolean ignoreAssertFailure) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        try {
            this.tryAssertMethodExists(methodExpression);
        }
        catch (net.jakubholy.jeeutils.jsfelcheck.validator.exception.MethodNotFoundException e) {
            throw new net.jakubholy.jeeutils.jsfelcheck.validator.exception.MethodNotFoundException((Throwable)e);
        }
        catch (RuntimeException e) {
            if (ignoreAssertFailure) {
                LOG.log(Level.WARNING, "assertMethodExists: Method validation for " + methodExpression + " failed but we assume that it is rather due to a bug in our experimental, hacked verification " + " code. Please open an issue at " + "https://github.com/jakubholynet/static-jsfexpression-validator/issues Failure: " + e);
            }
            throw new net.jakubholy.jeeutils.jsfelcheck.validator.exception.MethodNotFoundException((Throwable)e);
        }
    }

    void tryAssertMethodExists(String elExpression) {
        Method[] methods;
        String[] targetObjectElAndMethod = Jsf12ValidatingElResolver.splitAtLastProperty(elExpression);
        String targetObjectEl = targetObjectElAndMethod[0];
        String methodName = targetObjectElAndMethod[1];
        ValueExpression targetObjectValueExpr = this.expressionFactory.createValueExpression(this.elContext, targetObjectEl, Object.class);
        Class<?> targetClass = targetObjectValueExpr.getValue(this.elContext).getClass();
        for (Method method : methods = targetClass.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return;
        }
        throw new net.jakubholy.jeeutils.jsfelcheck.validator.exception.MethodNotFoundException("No method '" + methodName + "' found in the target object's " + targetClass);
    }

    protected static String[] splitAtLastProperty(String elExpression) {
        Matcher matcher = RE_LAST_EL_PROPERTY.matcher(elExpression);
        if (matcher.find()) {
            boolean matchGroup = true;
            int propertyNameWithDotStart = matcher.start(1) - 1;
            String lastProperty = matcher.group(1);
            String elWithoutLastProperty = elExpression.substring(0, propertyNameWithDotStart) + "}";
            return new String[]{elWithoutLastProperty, lastProperty};
        }
        throw new IllegalArgumentException("Couldn't find a trailing property name in the EL '" + elExpression + "' using " + matcher);
    }

    public JsfElValidator declareVariable(String name, Object value) {
        this.validatingResolver.getVariableResolver().declareVariable(name, value);
        return this;
    }

    public JsfElValidator definePropertyTypeOverride(String mapJsfExpression, Class<?> newType) {
        this.validatingResolver.getPropertyResolver().definePropertyTypeOverride(mapJsfExpression, newType);
        return this;
    }

    public void setUnknownVariableResolver(ElVariableResolver unknownVariableResolver) {
        this.validatingResolver.getVariableResolver().setUnknownVariableResolver(unknownVariableResolver);
    }

    public void setIncludeKnownVariablesInException(boolean includeKnownVariablesInException) {
        this.validatingResolver.getVariableResolver().setIncludeKnownVariablesInException(includeKnownVariablesInException);
    }

    public void addElExpressionFilter(ElExpressionFilter elExpressionFilter) {
        this.validatingResolver.getPropertyResolver().addElExpressionFilter(elExpressionFilter);
    }
}

