/*
 * Decompiled with CFR 0.152.
 */
package net.jakubholy.jeeutils.jsfelcheck.validator.jsf12;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.el.FunctionMapper;
import org.apache.el.parser.AstFunction;
import org.apache.el.parser.ELParser;
import org.apache.el.parser.Node;
import org.apache.el.parser.NodeVisitor;

public class MethodFakingFunctionMapper
extends FunctionMapper {
    private static final String DEFAULT_RESULT = "";
    static final Method[] FAKE_METHODS = new Method[]{MethodFakingFunctionMapper.createFakeMethod(0), MethodFakingFunctionMapper.createFakeMethod(1), MethodFakingFunctionMapper.createFakeMethod(2), MethodFakingFunctionMapper.createFakeMethod(3), MethodFakingFunctionMapper.createFakeMethod(4), MethodFakingFunctionMapper.createFakeMethod(5)};
    private final Map<String, Integer> functionToAritiesCache = new HashMap<String, Integer>();
    private final Set<String> currentExpressionsFunctions = new TreeSet<String>();
    private String currentExpression;

    private static Method createFakeMethod(int arity) {
        Object[] argumentTypes = new Class[arity];
        Arrays.fill(argumentTypes, Object.class);
        try {
            return MethodFakingFunctionMapper.class.getDeclaredMethod("fakeMethod" + arity, (Class<?>[])argumentTypes);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String fakeMethod0() {
        return DEFAULT_RESULT;
    }

    public static String fakeMethod1(Object p1) {
        return DEFAULT_RESULT;
    }

    public static String fakeMethod2(Object p1, Object p2) {
        return DEFAULT_RESULT;
    }

    public static String fakeMethod3(Object p1, Object p2, Object p3) {
        return DEFAULT_RESULT;
    }

    public static String fakeMethod4(Object p1, Object p2, Object p3, Object p4) {
        return DEFAULT_RESULT;
    }

    public static String fakeMethod5(Object p1, Object p2, Object p3, Object p4, Object p5) {
        return DEFAULT_RESULT;
    }

    public Collection<String> getLastExpressionsFunctionQNames() {
        return this.currentExpressionsFunctions;
    }

    public Method resolveFunction(String prefix, String name) {
        String resolvedFunctionQName = prefix + ":" + name;
        Integer arity = this.functionToAritiesCache.get(resolvedFunctionQName);
        if (arity == null) {
            Map<String, Integer> functionsAndAritiesInCurrentEL = this.extractFunctionArities();
            arity = functionsAndAritiesInCurrentEL.get(resolvedFunctionQName);
            this.functionToAritiesCache.putAll(functionsAndAritiesInCurrentEL);
        }
        if (arity == null) {
            throw new IllegalStateException("Couldn't determine the arity of the function " + resolvedFunctionQName + " from the EL '" + this.getCurrentExpressionOrFail() + "' - not found in it.");
        }
        if (arity >= FAKE_METHODS.length) {
            throw new IllegalArgumentException("Currently we only can fake methods with up to 5 parameters but " + resolvedFunctionQName + " has " + arity + ". This is really a bad practice anyway.");
        }
        this.currentExpressionsFunctions.add(resolvedFunctionQName);
        return FAKE_METHODS[arity];
    }

    private Map<String, Integer> extractFunctionArities() {
        Node parsedEl = ELParser.parse((String)this.getCurrentExpressionOrFail());
        try {
            FunctionArityExtractingVisitor arityExtractingVisitor = new FunctionArityExtractingVisitor();
            parsedEl.accept((NodeVisitor)arityExtractingVisitor);
            return arityExtractingVisitor.getFunctionArities();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected failure parsing the EL " + this.getCurrentExpressionOrFail(), e);
        }
    }

    public void setCurrentExpression(String currentExpression) {
        this.currentExpression = currentExpression;
        this.currentExpressionsFunctions.clear();
    }

    private String getCurrentExpressionOrFail() {
        if (this.currentExpression == null) {
            throw new IllegalStateException("Current EL expression not set!");
        }
        return this.currentExpression;
    }

    private final class FunctionArityExtractingVisitor
    implements NodeVisitor {
        private final Map<String, Integer> functionArity = new HashMap<String, Integer>();

        private FunctionArityExtractingVisitor() {
        }

        public void visit(Node n) throws Exception {
            if (n instanceof AstFunction) {
                this.visitFunction((AstFunction)n);
            }
        }

        private void visitFunction(AstFunction function) throws Exception {
            String nodeFunctionQName = function.getPrefix() + ":" + function.getLocalName();
            this.functionArity.put(nodeFunctionQName, function.jjtGetNumChildren());
        }

        public Map<String, Integer> getFunctionArities() {
            return this.functionArity;
        }
    }
}

