/*
 * Decompiled with CFR 0.152.
 */
package net.jakubholy.jeeutils.jsfelcheck.validator.jsf12;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import net.jakubholy.jeeutils.jsfelcheck.validator.MockingPropertyResolver;
import net.jakubholy.jeeutils.jsfelcheck.validator.PredefinedVariableResolver;
import net.jakubholy.jeeutils.jsfelcheck.validator.exception.GenericElEvaluationException;

public class ValidatingFakeValueResolver
extends ELResolver
implements MockingPropertyResolver.PropertyTypeResolver {
    private final CompositeELResolver allResolver;
    private ELContext currentContext;
    private MockingPropertyResolver propertyResolver;
    private PredefinedVariableResolver variableResolver;

    ValidatingFakeValueResolver(CompositeELResolver allResolver) {
        this.allResolver = allResolver;
        this.propertyResolver = new MockingPropertyResolver();
        this.propertyResolver.setTypeResolver((MockingPropertyResolver.PropertyTypeResolver)this);
        this.variableResolver = new PredefinedVariableResolver((PredefinedVariableResolver.NewVariableEncounteredListener)this.propertyResolver);
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        return false;
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        Object result;
        this.currentContext = context;
        if (base == null) {
            if (!(property instanceof String)) {
                return null;
            }
            result = this.resolveVariable((String)property);
        } else {
            result = this.resolveProperty(base, property);
        }
        if (result != null) {
            context.setPropertyResolved(true);
        }
        return result;
    }

    private Object resolveProperty(Object base, Object property) {
        return this.propertyResolver.getValue(base, property);
    }

    private Object resolveVariable(String variable) {
        return this.variableResolver.resolveVariable(variable);
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>();
        Map declaredVariables = this.variableResolver.getDeclaredVariables();
        for (Map.Entry variable : declaredVariables.entrySet()) {
            descriptors.add(this.makeDescriptor((String)variable.getKey(), variable.getValue().getClass()));
        }
        return descriptors.iterator();
    }

    private FeatureDescriptor makeDescriptor(String beanName, Class<?> managedBeanType) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setValue("resolvableAtDesignTime", Boolean.TRUE);
        fd.setValue("type", managedBeanType);
        fd.setName(beanName);
        fd.setDisplayName(beanName);
        fd.setExpert(false);
        fd.setHidden(false);
        fd.setPreferred(true);
        return fd;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        return Object.class;
    }

    public Class<?> getType(Object target, Object property) {
        try {
            return this.allResolver.getType(this.currentContext, target, property);
        }
        catch (PropertyNotFoundException e) {
            throw new net.jakubholy.jeeutils.jsfelcheck.validator.exception.PropertyNotFoundException((Throwable)e);
        }
        catch (ELException e) {
            throw new GenericElEvaluationException(e.getMessage(), (Throwable)e);
        }
    }

    MockingPropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    PredefinedVariableResolver getVariableResolver() {
        return this.variableResolver;
    }
}

