/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import net.java.ao.DelegateStatement;
import net.java.ao.sql.LoggingInterceptor;

class DelegateLoggingStatement
extends DelegateStatement {
    protected final LoggingInterceptor logger;
    protected final Map<Integer, String> params = new HashMap<Integer, String>();
    protected final StringBuilder batchQueryBuffer = new StringBuilder();

    DelegateLoggingStatement(Statement statement, LoggingInterceptor logger) {
        super(statement);
        this.logger = logger;
    }

    <T> T delegateExecute(String sql, DelegateBlock<T> block) throws SQLException {
        this.logger.beforeExecution();
        try {
            T result = block.invoke();
            this.logger.afterSuccessfulExecution(sql, this.params);
            return result;
        }
        catch (SQLException e) {
            this.logger.onException(sql, this.params, e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.execute(sql));
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.statement.addBatch(sql);
        if (this.batchQueryBuffer.length() > 0) {
            this.batchQueryBuffer.append("\n");
        }
        this.batchQueryBuffer.append(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
        this.batchQueryBuffer.setLength(0);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.logger.beforeExecution();
        try {
            int[] result = this.statement.executeBatch();
            this.logger.afterSuccessfulExecution(this.batchQueryBuffer.toString());
            return result;
        }
        catch (SQLException e) {
            this.logger.onException(this.batchQueryBuffer.toString(), e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.execute(sql, autoGeneratedKeys));
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.execute(sql, columnIndexes));
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.execute(sql, columnNames));
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.executeLargeUpdate(sql));
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.executeLargeUpdate(sql, autoGeneratedKeys));
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.executeLargeUpdate(sql, columnIndexes));
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.executeLargeUpdate(sql, columnNames));
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.executeQuery(sql));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.executeUpdate(sql));
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.executeUpdate(sql, autoGeneratedKeys));
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.executeUpdate(sql, columnIndexes));
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.delegateExecute(sql, () -> this.statement.executeUpdate(sql, columnNames));
    }

    @FunctionalInterface
    protected static interface DelegateBlock<T> {
        public T invoke() throws SQLException;
    }
}

