/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema;

import com.google.common.base.Preconditions;
import java.util.List;
import net.java.ao.Common;
import net.java.ao.schema.CanonicalClassNameTableNameConverter;

abstract class TransformsTableNameConverter
extends CanonicalClassNameTableNameConverter {
    private List<Transform> transforms;
    private CanonicalClassNameTableNameConverter delegateTableNameConverter;

    TransformsTableNameConverter(List<Transform> transforms, CanonicalClassNameTableNameConverter delegateTableNameConverter) {
        this.transforms = (List)Preconditions.checkNotNull(transforms);
        this.delegateTableNameConverter = (CanonicalClassNameTableNameConverter)Preconditions.checkNotNull((Object)delegateTableNameConverter);
    }

    @Override
    protected final String getName(String entityClassCanonicalName) {
        return this.delegateTableNameConverter.getName(this.transform(entityClassCanonicalName));
    }

    private String transform(String entityClassCanonicalName) {
        for (Transform transform : this.transforms) {
            if (!transform.accept(entityClassCanonicalName)) continue;
            return transform.apply(entityClassCanonicalName);
        }
        return entityClassCanonicalName;
    }

    static final class ClassNameTableNameConverter
    extends CanonicalClassNameTableNameConverter {
        ClassNameTableNameConverter() {
        }

        @Override
        protected String getName(String entityClassCanonicalName) {
            return Common.convertSimpleClassName(entityClassCanonicalName);
        }
    }

    static interface Transform {
        public boolean accept(String var1);

        public String apply(String var1);
    }
}

