/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.it;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.SQLException;
import net.java.ao.DBParam;
import net.java.ao.EntityManager;
import net.java.ao.it.model.Address;
import net.java.ao.it.model.Author;
import net.java.ao.it.model.Authorship;
import net.java.ao.it.model.Book;
import net.java.ao.it.model.Chair;
import net.java.ao.it.model.Comment;
import net.java.ao.it.model.Commentable;
import net.java.ao.it.model.Company;
import net.java.ao.it.model.CompanyAddressInfo;
import net.java.ao.it.model.Distribution;
import net.java.ao.it.model.EmailAddress;
import net.java.ao.it.model.Magazine;
import net.java.ao.it.model.Message;
import net.java.ao.it.model.Nose;
import net.java.ao.it.model.OnlineDistribution;
import net.java.ao.it.model.Pen;
import net.java.ao.it.model.Person;
import net.java.ao.it.model.PersonChair;
import net.java.ao.it.model.PersonLegalDefence;
import net.java.ao.it.model.PersonSuit;
import net.java.ao.it.model.Photo;
import net.java.ao.it.model.Post;
import net.java.ao.it.model.PostalAddress;
import net.java.ao.it.model.PrintDistribution;
import net.java.ao.it.model.Profession;
import net.java.ao.it.model.Publication;
import net.java.ao.it.model.PublicationToDistribution;
import net.java.ao.it.model.Select;
import net.java.ao.it.model.UserBase;
import net.java.ao.test.EntityUtils;
import net.java.ao.test.jdbc.DatabaseUpdater;

public final class DatabaseProcessor
implements DatabaseUpdater {
    public static final Class[] EXPLICITLY_MIGRATED_CLASSES = new Class[]{PersonSuit.class, PersonChair.class, Pen.class, Comment.class, Photo.class, Post.class, Nose.class, Authorship.class, Book.class, Magazine.class, PublicationToDistribution.class, PrintDistribution.class, OnlineDistribution.class, Message.class, EmailAddress.class, PostalAddress.class, Select.class, UserBase.class};
    public static final Class[] IMPLICITLY_MIGRATED_CLASSES = new Class[]{Author.class, Person.class, PersonLegalDefence.class, Company.class, CompanyAddressInfo.class, Chair.class};

    public void update(EntityManager entityManager) throws Exception {
        entityManager.migrate(EXPLICITLY_MIGRATED_CLASSES);
        this.addData(entityManager);
        entityManager.flushAll();
    }

    private void addData(EntityManager entityManager) throws Exception {
        Company[] companies = this.addCompanies(entityManager);
        Person person = this.addPerson(entityManager, companies[0]);
        this.addNose(entityManager, person);
        this.addPens(entityManager, person);
        this.addChairs(entityManager, person);
        this.addPersonLegalDefences(entityManager, person);
        Post post = this.addPost(entityManager);
        this.addPostComments(entityManager, post);
        Photo photo = this.addPhoto(entityManager);
        this.addPhotoComments(entityManager, photo);
        Address[] addresses = this.addAddresses(entityManager);
        this.addMessages(entityManager, addresses[0], addresses[1]);
        this.addBooks(entityManager);
        this.addMagazines(entityManager);
    }

    private Company[] addCompanies(EntityManager entityManager) throws Exception {
        Company[] companies = new Company[CompanyData.ids.length];
        for (int i = 0; i < companies.length; ++i) {
            ByteArrayInputStream is = new ByteArrayInputStream(CompanyData.IMAGES[i]);
            Company company = (Company)entityManager.create(Company.class, new DBParam[0]);
            company.setName(CompanyData.NAMES[i]);
            company.setCool(CompanyData.COOLS[i]);
            company.setImage(is);
            company.save();
            ((InputStream)is).close();
            CompanyData.ids[i] = company.getCompanyID();
            companies[i] = company;
        }
        return companies;
    }

    public Nose addNose(EntityManager entityManager, Person person) throws SQLException {
        Nose nose = (Nose)entityManager.create(Nose.class, new DBParam[0]);
        nose.setPerson(person);
        nose.setLength(123);
        nose.save();
        NoseData.id = nose.getID();
        return nose;
    }

    public Person addPerson(EntityManager entityManager, Company company) throws Exception {
        Person person = (Person)entityManager.create(Person.class, new DBParam[0]);
        person.setFirstName("Daniel");
        person.setLastName("Spiewak");
        person.setCompany(company);
        person.setProfession(PersonData.PROFESSION);
        person.setImage(PersonData.IMAGE);
        person.save();
        PersonData.id = person.getID();
        return person;
    }

    private Pen[] addPens(EntityManager entityManager, Person person) throws Exception {
        Pen[] pens = new Pen[PenData.ids.length];
        for (int i = 0; i < PenData.ids.length; ++i) {
            Pen pen = (Pen)entityManager.create(Pen.class, new DBParam[0]);
            pen.setPerson(person);
            pen.setWidth(PenData.WIDTHS[i]);
            pen.save();
            PenData.ids[i] = pen.getID();
        }
        return pens;
    }

    private Chair[] addChairs(EntityManager entityManager, Person person) throws Exception {
        Chair[] chairs = new Chair[ChairData.ids.length];
        for (int i = 0; i < ChairData.ids.length; ++i) {
            Chair chair = (Chair)entityManager.create(Chair.class, new DBParam[0]);
            chair.setColour(ChairData.COLOURS[i]);
            chair.save();
            ChairData.ids[i] = chair.getID();
            PersonChair personChair = (PersonChair)entityManager.create(PersonChair.class, new DBParam[0]);
            personChair.setPerson(person);
            personChair.setChair(chair);
            personChair.save();
            PersonChairData.ids[i] = personChair.getID();
            chairs[i] = chair;
        }
        return chairs;
    }

    private PersonLegalDefence[] addPersonLegalDefences(EntityManager entityManager, Person person) throws Exception {
        PersonLegalDefence[] personLegalDefences = new PersonLegalDefence[PersonLegalDefenceData.ids.length];
        for (int i = 0; i < PersonLegalDefenceData.ids.length; ++i) {
            PersonLegalDefence personLegalDefence = (PersonLegalDefence)entityManager.create(PersonLegalDefence.class, new DBParam[0]);
            personLegalDefence.setSeverity(PersonLegalDefenceData.SEVERITIES[i]);
            personLegalDefence.save();
            PersonLegalDefenceData.ids[i] = personLegalDefence.getID();
            PersonSuit personSuit = (PersonSuit)entityManager.create(PersonSuit.class, new DBParam[0]);
            personSuit.setPerson(person);
            personSuit.setPersonLegalDefence(personLegalDefence);
            personSuit.save();
            PersonSuitData.ids[i] = personSuit.getID();
        }
        return personLegalDefences;
    }

    private Post addPost(EntityManager entityManager) throws Exception {
        Post post = (Post)entityManager.create(Post.class, new DBParam[0]);
        post.setTitle("Test Post");
        post.save();
        PostData.id = post.getID();
        return post;
    }

    private Comment[] addPostComments(EntityManager entityManager, Post post) throws Exception {
        Comment[] comments = new Comment[PostCommentData.ids.length];
        for (int i = 0; i < PostCommentData.ids.length; ++i) {
            Comment comment = this.createComment(entityManager, post, PostCommentData.TITLES[i], PostCommentData.TEXTS[i]);
            PostCommentData.ids[i] = comment.getID();
            comments[i] = comment;
        }
        return comments;
    }

    private Photo addPhoto(EntityManager entityManager) throws Exception {
        Photo photo = (Photo)entityManager.create(Photo.class, new DBParam[0]);
        photo.save();
        PhotoData.id = photo.getID();
        return photo;
    }

    private Comment[] addPhotoComments(EntityManager entityManager, Photo photo) throws Exception {
        Comment[] comments = new Comment[PhotoCommentData.ids.length];
        for (int i = 0; i < PhotoCommentData.ids.length; ++i) {
            Comment comment = this.createComment(entityManager, photo, PhotoCommentData.TITLES[i], PhotoCommentData.TEXTS[i]);
            PhotoCommentData.ids[i] = comment.getID();
            comments[i] = comment;
        }
        return comments;
    }

    private Address[] addAddresses(EntityManager entityManager) throws Exception {
        Address[] addresses = new Address[AddressData.getIds().length];
        for (int i = 0; i < addresses.length; ++i) {
            EmailAddress address = (EmailAddress)entityManager.create(EmailAddress.class, new DBParam[0]);
            address.setEmail(AddressData.EMAILS[i]);
            address.save();
            AddressData.ids[i] = address.getID();
            addresses[i] = address;
        }
        return addresses;
    }

    private void addMessages(EntityManager entityManager, Address address1, Address address2) throws Exception {
        Message message1 = this.addMessage(entityManager, address1, address2, MessageData.CONTENTS[0]);
        MessageData.ids[0] = message1.getID();
        Message message2 = this.addMessage(entityManager, address2, address1, MessageData.CONTENTS[1]);
        MessageData.ids[1] = message2.getID();
    }

    private Message addMessage(EntityManager entityManager, Address to, Address from, String content) throws Exception {
        String contents = EntityUtils.getFieldName((EntityManager)entityManager, Message.class, (String)"getContents");
        Message message = (Message)entityManager.create(Message.class, new DBParam[]{new DBParam(contents, (Object)content)});
        message.setTo(to);
        message.setFrom(from);
        message.save();
        return message;
    }

    private Book[] addBooks(EntityManager entityManager) throws Exception {
        Book[] books = new Book[BookData.ids.length];
        for (int i = 0; i < BookData.ids.length; ++i) {
            Book book = (Book)entityManager.create(Book.class, new DBParam[0]);
            book.setTitle(BookData.TITLES[i]);
            book.setHardcover(BookData.COVERS[i]);
            book.save();
            BookData.ids[i] = book.getID();
            for (int j = 0; j < BookData.AUTHOR_IDS[i].length; ++j) {
                Author author = this.addAuthor(entityManager, book, "Book author", j);
                BookData.AUTHOR_IDS[i][j] = author.getID();
            }
            Distribution print = this.addPrintDistribution(entityManager, book, 10003);
            Distribution online = this.addOnlineDistribution(entityManager, book, "http://amazon.example.com");
            BookData.DISTRIBUTION_IDS[i][0] = print.getID();
            BookData.DISTRIBUTION_TYPES[i][0] = print.getEntityType();
            BookData.DISTRIBUTION_IDS[i][1] = online.getID();
            BookData.DISTRIBUTION_TYPES[i][1] = online.getEntityType();
            books[i] = book;
        }
        return books;
    }

    private Magazine[] addMagazines(EntityManager entityManager) throws Exception {
        Magazine[] magazines = new Magazine[MagazineData.ids.length];
        for (int i = 0; i < MagazineData.ids.length; ++i) {
            Magazine magazine = (Magazine)entityManager.create(Magazine.class, new DBParam[0]);
            magazine.setTitle(MagazineData.TITLES[i]);
            magazine.save();
            MagazineData.ids[i] = magazine.getID();
            for (int j = 0; j < MagazineData.AUTHOR_IDS[i].length; ++j) {
                Author author = this.addAuthor(entityManager, magazine, "Magazine author", j);
                MagazineData.AUTHOR_IDS[i][j] = author.getID();
            }
            Distribution print = this.addPrintDistribution(entityManager, magazine, 9007);
            Distribution online = this.addOnlineDistribution(entityManager, magazine, "http://amazon.example.com");
            MagazineData.DISTRIBUTION_IDS[i][0] = print.getID();
            MagazineData.DISTRIBUTION_TYPES[i][0] = print.getEntityType();
            MagazineData.DISTRIBUTION_IDS[i][1] = online.getID();
            MagazineData.DISTRIBUTION_TYPES[i][1] = online.getEntityType();
            magazines[i] = magazine;
        }
        return magazines;
    }

    private Distribution addPrintDistribution(EntityManager entityManager, Publication publication, int copies) throws Exception {
        PrintDistribution distribution = (PrintDistribution)entityManager.create(PrintDistribution.class, new DBParam[0]);
        distribution.setCopies(copies);
        distribution.save();
        PublicationToDistribution ptd = (PublicationToDistribution)entityManager.create(PublicationToDistribution.class, new DBParam[0]);
        ptd.setDistribution(distribution);
        ptd.setPublication(publication);
        ptd.save();
        return distribution;
    }

    private Distribution addOnlineDistribution(EntityManager entityManager, Publication publication, String url) throws Exception {
        OnlineDistribution distribution = (OnlineDistribution)entityManager.create(OnlineDistribution.class, new DBParam[0]);
        distribution.setURL(new URL(url));
        distribution.save();
        PublicationToDistribution ptd = (PublicationToDistribution)entityManager.create(PublicationToDistribution.class, new DBParam[0]);
        ptd.setDistribution(distribution);
        ptd.setPublication(publication);
        ptd.save();
        return distribution;
    }

    private Author addAuthor(EntityManager entityManager, Publication publication, String title, int index) throws Exception {
        Author author = (Author)entityManager.create(Author.class, new DBParam[0]);
        author.setName(title + " " + publication.getID() + ":" + index);
        author.save();
        Authorship authorship = (Authorship)entityManager.create(Authorship.class, new DBParam[0]);
        authorship.setPublication(publication);
        authorship.setAuthor(author);
        authorship.save();
        return author;
    }

    private Comment createComment(EntityManager entityManager, Commentable commentable, String title, String text) throws Exception {
        Comment comment = (Comment)entityManager.create(Comment.class, new DBParam[0]);
        comment.setTitle(title);
        comment.setText(text);
        comment.setCommentable(commentable);
        comment.save();
        return comment;
    }

    private static byte[] getImage(String fakeImage) {
        byte[] img;
        try {
            img = fakeImage.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return img;
    }

    static /* synthetic */ byte[] access$000(String x0) {
        return DatabaseProcessor.getImage(x0);
    }

    public static final class PersonSuitData {
        static int[] ids = new int[PersonLegalDefenceData.ids.length];

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class PersonChairData {
        static int[] ids = new int[ChairData.ids.length];

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class AuthorData {
        static int[] ids = new int[]{-1, -1, -1, -1};

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class MagazineData {
        static int[] ids = new int[]{-1, -1};
        public static final int[][] AUTHOR_IDS = new int[][]{{-1, -1, -1}, {-1, -1}};
        public static int[][] DISTRIBUTION_IDS = new int[][]{{-1, -1}, {-1, -1}};
        public static Class[][] DISTRIBUTION_TYPES = new Class[2][2];
        public static final String[] TITLES = new String[]{"Magazine title 0", "Magazine title 1"};

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class BookData {
        static int[] ids = new int[]{-1, -1};
        public static int[][] AUTHOR_IDS = new int[][]{{-1, -1}, {-1, -1, -1}};
        public static int[][] DISTRIBUTION_IDS = new int[][]{{-1, -1}, {-1, -1}};
        public static Class[][] DISTRIBUTION_TYPES = new Class[2][2];
        public static final String[] TITLES = new String[]{"Book title 0", "Book title 1"};
        public static final boolean[] COVERS = new boolean[]{true, false};

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class MessageData {
        static int[] ids = new int[]{-1, -1};
        public static final String[] CONTENTS = new String[]{"Some message content 0", "Some message content 1"};

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class PhotoCommentData {
        static int[] ids = new int[]{-1, -1};
        public static final String[] TITLES = new String[]{"Photo comment title 0", "Photo comment title 1"};
        public static final String[] TEXTS = new String[]{"Commenting on a photo 0", "Commenting on a photo 1"};

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class PhotoData {
        static int id = -1;

        public static int getId() {
            return id;
        }
    }

    public static final class PostCommentData {
        static int[] ids = new int[]{-1, -1, -1, -1};
        public static final String[] TITLES = new String[]{"Post comment title 0", "Post comment title 1", "Post comment title 2", "Post comment title 3"};
        public static final String[] TEXTS = new String[]{"Commenting on a post 0", "Commenting on a post 1", "Commenting on a post 2", "Commenting on a post 3"};

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class PostData {
        static int id = -1;
        public static final String TITLE = "Test Post";

        public static int getId() {
            return id;
        }
    }

    public static final class PersonLegalDefenceData {
        static int[] ids = new int[]{-1, -1, -1};
        public static final int[] SEVERITIES = new int[]{2, 5, 7};

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class ChairData {
        static int[] ids = new int[]{-1, -1, -1};
        public static final String[] COLOURS = new String[]{"black", "white", "red"};

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class PenData {
        static int[] ids = new int[]{-1, -1, -1};
        public static final double[] WIDTHS = new double[]{0.3, 0.5, 0.7};

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class AddressData {
        static int[] ids = new int[]{-1, -1};
        public static final String[] EMAILS = new String[]{"email1@example.com", "email2@example.com"};

        public static int[] getIds() {
            return ids;
        }
    }

    public static final class PersonData {
        static int id = -1;
        public static final String FIRST_NAME = "Daniel";
        public static final String LAST_NAME = "Spiewak";
        public static final Profession PROFESSION = Profession.DEVELOPER;
        public static final byte[] IMAGE = DatabaseProcessor.access$000("person image");

        public static int getId() {
            return id;
        }
    }

    public static final class NoseData {
        static int id = -1;
        public static final int LENGTH = 123;

        public static int getId() {
            return id;
        }
    }

    public static final class CompanyData {
        static long[] ids = new long[]{-1L, -1L};
        public static final String[] NAMES = new String[]{"My Company 0", "My Company 1"};
        public static final boolean[] COOLS = new boolean[]{false, true};
        public static final byte[][] IMAGES = new byte[][]{DatabaseProcessor.access$000("company image 0"), DatabaseProcessor.access$000("company image 1")};

        public static long[] getIds() {
            return ids;
        }
    }
}

