/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.junit;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.IndexNameConverter;
import net.java.ao.schema.SequenceNameConverter;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.schema.TriggerNameConverter;
import net.java.ao.test.converters.NameConverters;
import net.java.ao.test.jdbc.Jdbc;
import net.java.ao.test.jdbc.JdbcConfiguration;
import net.java.ao.test.junit.ActiveObjectTransactionMethodRule;
import net.java.ao.test.lucene.WithIndex;
import org.junit.rules.MethodRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public final class ActiveObjectsJUnitRunner
extends BlockJUnit4ClassRunner {
    private final JdbcConfiguration jdbcConfiguration;
    private final boolean withIndex;
    private final TableNameConverter tableNameConverter;
    private final FieldNameConverter fieldNameConverter;
    private final SequenceNameConverter sequenceNameConverter;
    private final TriggerNameConverter triggerNameConverter;
    private final IndexNameConverter indexNameConverter;

    public ActiveObjectsJUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.jdbcConfiguration = this.jdbcConfiguration(klass);
        this.tableNameConverter = this.tableNameConverter(klass);
        this.fieldNameConverter = this.fieldNameConverter(klass);
        this.sequenceNameConverter = this.sequenceNameConverter(klass);
        this.triggerNameConverter = this.triggerNameConverter(klass);
        this.indexNameConverter = this.indexNameConverter(klass);
        this.withIndex = this.withIndex(klass);
    }

    protected List<MethodRule> rules(Object test) {
        LinkedList<MethodRule> methodRules = new LinkedList<MethodRule>(super.rules(test));
        methodRules.add(new ActiveObjectTransactionMethodRule(test, this.jdbcConfiguration, this.withIndex, this.tableNameConverter, this.fieldNameConverter, this.sequenceNameConverter, this.triggerNameConverter, this.indexNameConverter));
        return methodRules;
    }

    private boolean withIndex(Class<?> klass) {
        return klass.isAnnotationPresent(WithIndex.class);
    }

    private TableNameConverter tableNameConverter(Class<?> klass) {
        return this.newInstance(this.getNameConvertersAnnotation(klass).table());
    }

    private FieldNameConverter fieldNameConverter(Class<?> klass) {
        return this.newInstance(this.getNameConvertersAnnotation(klass).field());
    }

    private SequenceNameConverter sequenceNameConverter(Class<?> klass) {
        return this.newInstance(this.getNameConvertersAnnotation(klass).sequence());
    }

    private TriggerNameConverter triggerNameConverter(Class<?> klass) {
        return this.newInstance(this.getNameConvertersAnnotation(klass).trigger());
    }

    private IndexNameConverter indexNameConverter(Class<?> klass) {
        return this.newInstance(this.getNameConvertersAnnotation(klass).index());
    }

    private NameConverters getNameConvertersAnnotation(Class<?> klass) {
        return this.getAnnotation(klass, NameConverters.class);
    }

    private <A extends Annotation> A getAnnotation(Class<?> klass, Class<A> annotationClass) {
        if (klass.isAnnotationPresent(annotationClass)) {
            return klass.getAnnotation(annotationClass);
        }
        return Annotated.class.getAnnotation(annotationClass);
    }

    private JdbcConfiguration jdbcConfiguration(Class<?> klass) {
        return this.newInstance(this.getAnnotation(klass, Jdbc.class).value());
    }

    private <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @NameConverters
    @Jdbc
    private static final class Annotated {
        private Annotated() {
        }
    }
}

