/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.junit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import net.java.ao.DelegateConnection;
import net.java.ao.EntityManager;
import net.java.ao.builder.EntityManagerBuilder;
import net.java.ao.builder.EntityManagerBuilderWithDatabaseProperties;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.IndexNameConverter;
import net.java.ao.schema.SequenceNameConverter;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.schema.TriggerNameConverter;
import net.java.ao.sql.SqlUtils;
import net.java.ao.test.jdbc.Data;
import net.java.ao.test.jdbc.DatabaseUpdater;
import net.java.ao.test.jdbc.JdbcConfiguration;
import net.java.ao.test.jdbc.NonTransactional;
import net.java.ao.test.jdbc.NullDatabase;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class ActiveObjectTransactionMethodRule
implements MethodRule {
    private static final Map<JdbcConfiguration, DatabaseConfiguration> DATABASES = new HashMap<JdbcConfiguration, DatabaseConfiguration>();
    private final Object test;
    private final JdbcConfiguration jdbc;
    private final boolean withIndex;
    private final TableNameConverter tableNameConverter;
    private final FieldNameConverter fieldNameConverter;
    private final SequenceNameConverter sequenceNameConverter;
    private final TriggerNameConverter triggerNameConverter;
    private final IndexNameConverter indexNameConverter;
    private EntityManager entityManager;
    private File indexDirectory;

    public ActiveObjectTransactionMethodRule(Object test, JdbcConfiguration jdbc, boolean withIndex, TableNameConverter tableNameConverter, FieldNameConverter fieldNameConverter, SequenceNameConverter sequenceNameConverter, TriggerNameConverter triggerNameConverter, IndexNameConverter indexNameConverter) {
        this.test = test;
        this.jdbc = jdbc;
        this.withIndex = withIndex;
        this.tableNameConverter = tableNameConverter;
        this.fieldNameConverter = fieldNameConverter;
        this.sequenceNameConverter = sequenceNameConverter;
        this.triggerNameConverter = triggerNameConverter;
        this.indexNameConverter = indexNameConverter;
    }

    public final Statement apply(final Statement base, final FrameworkMethod method, Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ActiveObjectTransactionMethodRule.this.before(method);
                boolean useTransaction = ActiveObjectTransactionMethodRule.this.useTransaction(method);
                Connection c = null;
                try {
                    if (useTransaction) {
                        c = ActiveObjectTransactionMethodRule.this.entityManager.getProvider().startTransaction();
                    }
                    base.evaluate();
                }
                finally {
                    if (useTransaction && c != null) {
                        ActiveObjectTransactionMethodRule.this.entityManager.getProvider().rollbackTransaction(c);
                        if (c instanceof DelegateConnection) {
                            ((DelegateConnection)c).setCloseable(true);
                        }
                        SqlUtils.closeQuietly((Connection)c);
                    }
                    ActiveObjectTransactionMethodRule.this.entityManager.flushAll();
                    ActiveObjectTransactionMethodRule.this.after(method);
                }
            }
        };
    }

    protected void before(FrameworkMethod method) throws Throwable {
        if (this.withIndex) {
            this.createIndexDir();
        }
        this.entityManager = this.createEntityManagerAndUpdateDatabase();
        this.injectEntityManager();
    }

    private void createIndexDir() {
        try {
            this.indexDirectory = File.createTempFile("ao_test", "index");
            this.indexDirectory.delete();
            this.indexDirectory.mkdirs();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void after(FrameworkMethod method) {
        if (!this.useTransaction(method)) {
            DATABASES.remove(this.jdbc);
        }
        this.entityManager = null;
        if (this.withIndex) {
            this.removeIndexDir();
        }
    }

    private boolean useTransaction(FrameworkMethod method) {
        return !method.getMethod().isAnnotationPresent(NonTransactional.class);
    }

    private void removeIndexDir() {
        this.removeFile(this.indexDirectory);
    }

    private void removeFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else {
            for (File f : file.listFiles()) {
                this.removeFile(f);
            }
            file.delete();
        }
    }

    private EntityManager createEntityManagerAndUpdateDatabase() throws Exception {
        EntityManager entityManager;
        Class<? extends DatabaseUpdater> databaseUpdater = this.isDataAnnotationPresent() ? this.getDataAnnotationValue() : this.getDataAnnotationDefaultValue();
        DatabaseConfiguration dbConfiguration = this.newDatabaseConfiguration(databaseUpdater);
        if (databaseUpdater == NullDatabase.class) {
            entityManager = this.createEntityManager();
            entityManager.migrate(new Class[0]);
            DATABASES.remove(this.jdbc);
        } else if (!DATABASES.containsKey(this.jdbc) || !DATABASES.get(this.jdbc).equals(dbConfiguration) || this.withIndex) {
            entityManager = this.createEntityManager();
            entityManager.migrate(new Class[0]);
            this.newInstance(databaseUpdater).update(entityManager);
            dbConfiguration.setEntityManager(entityManager);
            DATABASES.put(this.jdbc, dbConfiguration);
        } else {
            entityManager = DATABASES.get(this.jdbc).getEntityManager();
        }
        return entityManager;
    }

    private DatabaseConfiguration newDatabaseConfiguration(Class<? extends DatabaseUpdater> databaseUpdater) {
        Class<?> tableNameConverterClass = this.getClass(this.tableNameConverter);
        Class<?> fieldNameConverterClass = this.getClass(this.fieldNameConverter);
        Class<?> sequenceNameConverterClass = this.getClass(this.sequenceNameConverter);
        Class<?> triggerNameConverterClass = this.getClass(this.triggerNameConverter);
        Class<?> indexNameConverterClass = this.getClass(this.indexNameConverter);
        return new DatabaseConfiguration(databaseUpdater, tableNameConverterClass, fieldNameConverterClass, sequenceNameConverterClass, triggerNameConverterClass, indexNameConverterClass, this.withIndex);
    }

    private Class<?> getClass(Object o) {
        return o != null ? o.getClass() : null;
    }

    private EntityManager createEntityManager() {
        EntityManagerBuilderWithDatabaseProperties entityManagerBuilder = EntityManagerBuilder.url((String)this.jdbc.getUrl()).username(this.jdbc.getUsername()).password(this.jdbc.getPassword()).schema(this.jdbc.getSchema()).auto();
        if (this.tableNameConverter != null) {
            entityManagerBuilder = (EntityManagerBuilderWithDatabaseProperties)entityManagerBuilder.tableNameConverter(this.tableNameConverter);
        }
        if (this.fieldNameConverter != null) {
            entityManagerBuilder = (EntityManagerBuilderWithDatabaseProperties)entityManagerBuilder.fieldNameConverter(this.fieldNameConverter);
        }
        if (this.sequenceNameConverter != null) {
            entityManagerBuilder = (EntityManagerBuilderWithDatabaseProperties)entityManagerBuilder.sequenceNameConverter(this.sequenceNameConverter);
        }
        if (this.triggerNameConverter != null) {
            entityManagerBuilder = (EntityManagerBuilderWithDatabaseProperties)entityManagerBuilder.triggerNameConverter(this.triggerNameConverter);
        }
        if (this.indexNameConverter != null) {
            entityManagerBuilder = (EntityManagerBuilderWithDatabaseProperties)entityManagerBuilder.indexNameConverter(this.indexNameConverter);
        }
        return this.withIndex ? entityManagerBuilder.withIndex(this.indexDirectory).build() : entityManagerBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectEntityManager() {
        Field field = this.getEntityManagerField(this.getTestClass());
        boolean isFieldAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            try {
                field.set(this.test, this.entityManager);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            field.setAccessible(isFieldAccessible);
        }
    }

    private Class<? extends DatabaseUpdater> getDataAnnotationDefaultValue() throws NoSuchMethodException {
        @Data
        final class C {
            C() {
            }
        }
        return C.class.getAnnotation(Data.class).value();
    }

    private Class<? extends DatabaseUpdater> getDataAnnotationValue() {
        return this.getTestClass().getAnnotation(Data.class).value();
    }

    private boolean isDataAnnotationPresent() {
        return this.getTestClass().isAnnotationPresent(Data.class);
    }

    private <T> T newInstance(Class<T> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> getTestClass() {
        return this.test.getClass();
    }

    private Field getEntityManagerField(Class<?> aClass) {
        for (Field field : aClass.getDeclaredFields()) {
            if (!field.getType().equals(EntityManager.class)) continue;
            return field;
        }
        if (!aClass.getSuperclass().equals(Object.class)) {
            return this.getEntityManagerField(aClass.getSuperclass());
        }
        return null;
    }

    private static final class DatabaseConfiguration {
        private final Class<? extends DatabaseUpdater> databaseUpdaterClass;
        private final Class<? extends TableNameConverter> tableNameConverterClass;
        private final Class<? extends FieldNameConverter> fieldNameConverterClass;
        private final Class<? extends SequenceNameConverter> sequenceNameConverterClass;
        private final Class<? extends TriggerNameConverter> triggerNameConverterClass;
        private final Class<? extends IndexNameConverter> indexNameConverterClass;
        private final boolean withIndex;
        private EntityManager entityManager;

        public DatabaseConfiguration(Class<? extends DatabaseUpdater> databaseUpdaterClass, Class<? extends TableNameConverter> tableNameConverterClass, Class<? extends FieldNameConverter> fieldNameConverterClass, Class<? extends SequenceNameConverter> sequenceNameConverterClass, Class<? extends TriggerNameConverter> triggerNameConverterClass, Class<? extends IndexNameConverter> indexNameConverterClass, boolean withIndex) {
            this.databaseUpdaterClass = databaseUpdaterClass;
            this.tableNameConverterClass = tableNameConverterClass;
            this.fieldNameConverterClass = fieldNameConverterClass;
            this.sequenceNameConverterClass = sequenceNameConverterClass;
            this.triggerNameConverterClass = triggerNameConverterClass;
            this.indexNameConverterClass = indexNameConverterClass;
            this.withIndex = withIndex;
        }

        public void setEntityManager(EntityManager entityManager) {
            this.entityManager = entityManager;
        }

        public EntityManager getEntityManager() {
            return this.entityManager;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DatabaseConfiguration that = (DatabaseConfiguration)o;
            if (this.withIndex != that.withIndex) {
                return false;
            }
            if (this.databaseUpdaterClass != null ? !this.databaseUpdaterClass.equals(that.databaseUpdaterClass) : that.databaseUpdaterClass != null) {
                return false;
            }
            if (this.fieldNameConverterClass != null ? !this.fieldNameConverterClass.equals(that.fieldNameConverterClass) : that.fieldNameConverterClass != null) {
                return false;
            }
            if (this.indexNameConverterClass != null ? !this.indexNameConverterClass.equals(that.indexNameConverterClass) : that.indexNameConverterClass != null) {
                return false;
            }
            if (this.sequenceNameConverterClass != null ? !this.sequenceNameConverterClass.equals(that.sequenceNameConverterClass) : that.sequenceNameConverterClass != null) {
                return false;
            }
            if (this.tableNameConverterClass != null ? !this.tableNameConverterClass.equals(that.tableNameConverterClass) : that.tableNameConverterClass != null) {
                return false;
            }
            return !(this.triggerNameConverterClass != null ? !this.triggerNameConverterClass.equals(that.triggerNameConverterClass) : that.triggerNameConverterClass != null);
        }

        public int hashCode() {
            int result = this.databaseUpdaterClass != null ? this.databaseUpdaterClass.hashCode() : 0;
            result = 31 * result + (this.tableNameConverterClass != null ? this.tableNameConverterClass.hashCode() : 0);
            result = 31 * result + (this.fieldNameConverterClass != null ? this.fieldNameConverterClass.hashCode() : 0);
            result = 31 * result + (this.sequenceNameConverterClass != null ? this.sequenceNameConverterClass.hashCode() : 0);
            result = 31 * result + (this.triggerNameConverterClass != null ? this.triggerNameConverterClass.hashCode() : 0);
            result = 31 * result + (this.indexNameConverterClass != null ? this.indexNameConverterClass.hashCode() : 0);
            result = 31 * result + (this.withIndex ? 1 : 0);
            return result;
        }
    }
}

