/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.jdbc;

import com.google.common.io.Files;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.java.ao.test.jdbc.AbstractJdbcConfiguration;
import org.h2.tools.Server;

public class H2Server
extends AbstractJdbcConfiguration {
    private static final File TEMP_DIR = Files.createTempDir();
    private static final String DEFAULT_URL = "jdbc:h2:tcp://localhost/" + TEMP_DIR.getPath() + "/ao-test;MVCC=TRUE";
    private static final String DEFAULT_USER = "";
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_SCHEMA = "PUBLIC";
    private static Server h2Server;
    private static Lock h2ServerLock;

    public H2Server() {
        this(DEFAULT_URL, "", "", DEFAULT_SCHEMA);
    }

    public H2Server(String url, String username, String password, String schema) {
        super(url, username, password, schema);
    }

    @Override
    protected String getDefaultUsername() {
        return "";
    }

    @Override
    protected String getDefaultPassword() {
        return "";
    }

    @Override
    protected String getDefaultSchema() {
        return DEFAULT_SCHEMA;
    }

    @Override
    protected String getDefaultUrl() {
        return DEFAULT_URL;
    }

    @Override
    public void init() {
        block5: {
            h2ServerLock.lock();
            try {
                if (h2Server != null) break block5;
                try {
                    h2Server = Server.createTcpServer((String[])H2Server.getTcpServerParams()).start();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                h2ServerLock.unlock();
            }
        }
    }

    private static String[] getTcpServerParams() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("-baseDir");
        params.add(TEMP_DIR.getPath());
        if (H2Server.isH2VersionGreaterThanOrEqualTo(1, 4, 198)) {
            params.add("-ifNotExists");
        }
        return params.toArray(new String[0]);
    }

    private static boolean isH2VersionGreaterThanOrEqualTo(int major, int minor, int buildId) {
        if (1 > major) {
            return true;
        }
        if (1 < major) {
            return false;
        }
        if (3 > minor) {
            return true;
        }
        if (3 < minor) {
            return false;
        }
        return 176 >= buildId;
    }

    static {
        h2ServerLock = new ReentrantLock();
    }
}

