/*
 * Decompiled with CFR 0.152.
 */
package org.javax.csv.csvio;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.javax.util.EnvironmentProperties;
import org.javax.util.MergedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericCsvFactory {
    private Properties properties;
    private Constructor<?> constructor;

    protected GenericCsvFactory(ClassLoader classLoader, Properties properties, Class<?> factoryClass, Class<?> enclosedClass) {
        String propertyPrefix = factoryClass.getName() + ".";
        String resourcePrefix = factoryClass.getName().replace('.', '/');
        Properties customProperties = GenericCsvFactory.loadProperties(classLoader, resourcePrefix, ".properties");
        Properties defaultProperties = GenericCsvFactory.loadProperties(classLoader, resourcePrefix, ".default.properties");
        this.properties = new MergedProperties(new EnvironmentProperties(propertyPrefix), properties, customProperties, defaultProperties);
    }

    protected Object create(Object enclosedInstance) {
        try {
            if (this.constructor == null) {
                String className = this.properties.getProperty("Class");
                if (className == null) {
                    throw new RuntimeException(String.format("No '%s' property defined!", "Class"));
                }
                this.constructor = Class.forName(className).getConstructor(Properties.class, enclosedInstance instanceof Reader ? Reader.class : Writer.class);
                System.out.println(this.constructor);
            }
            return this.constructor.newInstance(this.properties, enclosedInstance);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private static Properties loadProperties(ClassLoader classLoader, String resourcePrefix, String resourceSuffix) {
        Properties result = new Properties();
        String resourceName = resourcePrefix + resourceSuffix;
        InputStream stream = classLoader.getResourceAsStream(resourceName);
        if (stream != null) {
            try {
                result.load(stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static interface Property {
        public static final String Class = "Class";
        public static final String PropertyValueSeparator = "PropertyValueSeparator";
        public static final String FieldSeparator = "FieldSeparator";
        public static final String RecordSeparator = "RecordSeparator";
    }
}

