/*
 * Decompiled with CFR 0.152.
 */
package org.javax.csv.csvio.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.javax.csv.csvio.GenericCsvReader;
import org.javax.csv.csvio.GenericCsvReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedCsvReader
extends GenericCsvReader {
    private BufferedReader reader;
    private String delimiter;
    private boolean skipEmptyLines;

    public BufferedCsvReader(Properties properties, Reader reader) {
        this(reader, properties.getProperty("FieldSeparator").charAt(0), Boolean.parseBoolean(properties.getProperty("SkipEmptyLines", "false")));
    }

    public BufferedCsvReader(Reader reader, char delimiter, boolean skipEmptyLines) {
        this.reader = this.bufferedReader(reader);
        this.delimiter = "\\" + delimiter;
        this.skipEmptyLines = skipEmptyLines;
    }

    public BufferedCsvReader(Reader reader, char delimiter) {
        this(reader, delimiter, false);
    }

    @Override
    public List<String> read() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        if (line.trim().isEmpty()) {
            if (this.skipEmptyLines) {
                return this.read();
            }
            return Collections.emptyList();
        }
        String[] words = line.split(this.delimiter);
        return Arrays.asList(words);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private BufferedReader bufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader);
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public static interface Property
    extends GenericCsvReaderFactory.Property {
        public static final String SkipEmptyLines = "SkipEmptyLines";
    }
}

