/*
 * Decompiled with CFR 0.152.
 */
package org.javax.csv.csvio.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.javax.csv.csvio.CsvWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedCsvWriter
implements CsvWriter {
    private BufferedWriter writer;
    private char delimiter;

    public BufferedCsvWriter(Writer writer, char delimiter) {
        this.writer = this.resolveBufferedWriter(writer);
        this.delimiter = delimiter;
    }

    @Override
    public void write(List<String> line) throws IOException {
        if (line == null) {
            return;
        }
        Iterator<String> lineIt = line.iterator();
        if (lineIt.hasNext()) {
            this.writer.write(lineIt.next());
            while (lineIt.hasNext()) {
                this.writer.write(this.delimiter);
                this.writer.write(lineIt.next());
            }
        }
        this.writer.newLine();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private BufferedWriter resolveBufferedWriter(Writer writer) {
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public char getDelimiter() {
        return this.delimiter;
    }
}

